#***********************************************************************************************************************
# DMTF - Distributed Management Task Force, Inc. - http://www.dmtf.org
# See dsp2023_readme.txt for copyright information.
#
# embed-css-file.awk - part of the DMTF DSP2023 zip archive.
#
# awk script to embed a CSS file into generated HTML.
# The script removes any CSS comments (e.g. /* a comment */). 
#
#***********************************************************************************************************************

BEGIN {
    in_comment = 0   # flag controlling whether we are in a comment
    ORS = ""         # empty the output record separator - we insert newlines ourselves
}

{
    out_line = ""
    in_line = $0
	    
    # print "Debug: in_line='"in_line"'"
    while (in_line) {
        if (!in_comment) {
            cb_pos = match(in_line, "/\\*")
            if (cb_pos > 0) {
                in_comment = 1
                out = substr(in_line,1,cb_pos-1) 
                # print "Debug: Comment begin, in_line='"in_line"' cb_pos="cb_pos" out='"out"'"
                out_line = out_line out 
                in_line = substr(in_line,cb_pos+2)
                continue # while loop 
            }
            else {
                out = in_line 
                # print "Debug: Not in comment, in_line='"in_line"' out='"out"'"
                out_line = out_line out 
                in_line = ""
                break # while loop
            }
	    }
        else {
            ce_pos = match(in_line, "\\*/")
            if (ce_pos > 0) {
                in_comment = 0
                out = substr(in_line,ce_pos+2)
                # print "Debug: Comment end, in_line='"in_line"' ce_pos="ce_pos" out='"out"'"
                out_line = out_line out 
                in_line = ""
                continue # while loop 
            }
            else {
                in_line = ""
                # print "Debug: In comment"
                break # while loop
            }
    	}
    }
    if (out_line) {
        print out_line "\n"
    }
    next
}
