@setlocal
@echo off
rem #*******************************************************************************************************************
rem # DMTF - Distributed Management Task Force, Inc. - http://www.dmtf.org
rem # See dsp2023_readme.txt for copyright information.
rem #
rem # mrpmigrate_100e_100f.bat - part of the DMTF DSP2023 zip archive.
rem #
rem # Migrate MRP XML profiles from MRP 1.0.0e to MRP 1.0.0f
rem # Requirements: cygwin, with commands: cp, sed, grep

if %2.==. goto usage
if not %3.==. goto usage
if %2.==.%3 goto usage

cp %1 %2
if errorlevel 1 goto cperror

rem Version migration
sed -i -b 's!dsp8028_1.0.0e.xsd!dsp8028_1.0.0f.xsd!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8050_1.0.0e.xsd!dsp8050_1.0.0f.xsd!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8051_1.0.0e.xsd!dsp8051_1.0.0f.xsd!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8052_1.0.0e.xsd!dsp8052_1.0.0f.xsd!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8053_1.0.0e.xsd!dsp8053_1.0.0f.xsd!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8054_1.0.0e.css!dsp8054_1.0.0f.css!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8008_1.0.0e.xml!dsp8008_1.0.0f.xml!' %2
if errorlevel 1 goto sederror
sed -i -b 's!dsp8029_1.0.0e.xsl!dsp8029_1.0.0f.xsl!' %2
if errorlevel 1 goto sederror

rem Migration to new text fragment referencing approach
sed -i -b 's!textFragmentID="MRPT0101"!textFragmentName="Copyright Notice"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0102"!textFragmentName="Logo"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0103"!textFragmentName="Acknowledgements Introduction"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0104"!textFragmentName="Typographical Conventions"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0105"!textFragmentName="ABNF Usage Conventions"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0106"!textFragmentName="OCL Usage Conventions"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0107"!textFragmentName="Deprecated Material Conventions"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0108"!textFragmentName="Experimental Material Conventions"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0109"!textFragmentName="Normative References Introduction"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0110"!textFragmentName="Bibliography Introduction"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0111"!textFragmentName="Terms Introduction"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0112"!textFragmentName="Provisional Terms Definition"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0113"!textFragmentName="Clause Terms Definition"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0114"!textFragmentName="Normative Terms Definition"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0115"!textFragmentName="Symbols Introduction"!' %2
if errorlevel 1 goto sederror
sed -i -b 's!textFragmentID="MRPT0116"!textFragmentName="Foreword"!' %2
if errorlevel 1 goto sederror

grep 'textFragmentID=' %2 >nul
if not errorlevel 1 goto iderror

echo Success, generated output profile: %2
goto end

:usage
echo Error: Invalid command line parameters.
echo Usage: mrpmigrate_100e_100f input_profile_path output_profile_path
echo Example: mrpmigrate_100e_100f profiles\dsp1033_1.1.0a.mrp.xml dsp1033_1.1.0a.new.mrp.xml
exit /b 100

:sederror
echo Error: sed returns rc=%errorlevel%
exit /b %errorlevel%

:cperror
echo Error: cp returns rc=%errorlevel%
exit /b %errorlevel%

:iderror
echo Error: Generated output profile, but it uses text registry fragments with unknown message IDs:
grep -n 'textFragmentID=' %2
exit /b 1

:end
