<?xml version="1.0" encoding="UTF-8"?>
<!--
DMTF - Distributed Management Task Force, Inc. - http://www.dmtf.org

Release URLs (once DMTF Standard):
http://schemas.dmtf.org/wbem/mgmtprofile/1/dsp8029_1.0.1.xsl
http://schemas.dmtf.org/wbem/mgmtprofile/1/dsp8029_1.0.xsl

Document number: DSP8029
Date: 2012-08-19
Version: 1.0.1
Document status: DMTF Standard

Title: Management Profile Print XSLT Stylesheet

Document type: Specification (W3C XSLT Stylesheet)
Document language: en-US

Copyright notice:
Copyright (C) 2008-2012 Distributed Management Task Force, Inc. (DMTF). All rights reserved.
DMTF is a not-for-profit association of industry members dedicated to promoting enterprise and systems management and
interoperability.  Members and non-members may reproduce DMTF specifications and documents for uses consistent with this
purpose, provided that correct attribution is given.  As DMTF specifications may be revised from time to time, the
particular version and release date should always be noted.
Implementation of certain elements of this standard or proposed standard may be subject to third party patent rights,
including provisional patent rights (herein "patent rights").  DMTF makes no representations to users of the standard as
to the existence of such rights, and is not responsible to recognize, disclose, or identify any or all such third party
patent right, owners or claimants, nor for any incomplete or inaccurate identification or disclosure of such rights,
owners or claimants.  DMTF shall have no liability to any party, in any manner or circumstance, under any legal theory
whatsoever, for failure to recognize, disclose, or identify any such third party patent rights, or for such party's
reliance on the standard or incorporation thereof in its product, protocols or testing procedures.  DMTF shall have no
liability to any party implementing such standard, whether such implementation is foreseeable or not, nor to any patent
owner or claimant, and shall have no liability or responsibility for costs or losses incurred if a standard is withdrawn
or modified after publication, and shall be indemnified and held harmless by any party implementing the standard from
any and all claims of infringement by a patent owner for such implementations.
For information about patents held by third-parties which have notified the DMTF that, in their opinion, such patent may
relate to or impact implementations of DMTF standards, visit http://www.dmtf.org/about/policies/disclosures.php.

Foreword:
This document was prepared by the Profile Infrastructure Working Group. DMTF is a not-for-profit association of
industry members dedicated to promoting enterprise and systems management and interoperability. For information about
the DMTF, see http://www.dmtf.org.

Acknowledgments:
The DMTF acknowledges the following individuals for their contributions to this document:
* Andreas Maier, IBM (editor)
* Bob Blair, AMD
* George Ericson, EMC
* Steve Hand, Symantec

Introduction:
This XSLT stylesheet converts a Management Profile XML instance document into an HTML 4.0 document.
It requires the CIM-XML files of the CIM Schema that is used by the profile, to be available in the file system.
Customize the "cim-xml-root-url" variable to point to the directory with these files.
A good overview on browser support for HTML 4.0 and XHTML 1.0 is on http://www.webdevout.net/browser-support-html.

Normative references:
* DMTF DSP0004, CIM Infrastructure Specification 2.6,
  http://www.dmtf.org/standards/published_documents/DSP0004_2.6.pdf
* DMTF DSP0223, Generic Operations 1.0,
  http://www.dmtf.org/standards/published_documents/DSP0223_1.0.pdf
* DMTF DSP0228, Standard Message XML schema 1.2,
  http://schemas.dmtf.org/wbem/messageregistry/1/dsp0228_1.2.xsd
* DMTF DSP1001, Management Profile Specification Usage Guide 1.1,
  http://www.dmtf.org/standards/published_documents/DSP1001_1.1.pdf
* DMTF DSP8008, Management Profile Text Registry 1.0,
  http://schemas.dmtf.org/wbem/mgmtprofile/1/dsp8008_1.0.xml
* DMTF DSP8020, Standard Metric XML schema 1.1,
  http://schemas.dmtf.org/wbem/metricregistry/1/dsp8020_1.1.xsd
* DMTF DSP8028, Management Profile XML Schema 1.0,
  http://schemas.dmtf.org/wbem/mgmtprofile/1/dsp8028_1.0.xsd
* DMTF DSP8050, Document Control XML Schema 1.0,
  http://schemas.dmtf.org/document/noxmlns/dsp8050_1.0.xsd
* DMTF DSP8051, Document Glossary XML Schema 1.0,
  http://schemas.dmtf.org/document/noxmlns/dsp8051_1.0.xsd
* DMTF DSP8052, Document Reference XML Schema 1.0,
  http://schemas.dmtf.org/document/noxmlns/dsp8052_1.0.xsd
* DMTF DSP8053, Document Common Types XML Schema 1.0,
  http://schemas.dmtf.org/document/noxmlns/dsp8053_1.0.xsd
* DMTF DSP8054, Document CSS Stylesheet 1.0,
  http://schemas.dmtf.org/document/dsp8054_1.0.css
* ISO/IEC Directives, Part 2:2004, Rules for the structure and drafting of International Standards,
  http://isotc.iso.org/livelink/livelink?func=ll&objId=4230456&objAction=browse
* W3C Cascading Style Sheets, level 2,
  W3C Recommendation 12 May 1998, revised 11 April 2008,
  http://www.w3.org/TR/2008/REC-CSS2-20080411/
* W3C HTML 4.01 Specification,
  W3C Recommendation 24 December 1999,
  http://www.w3.org/TR/html4
* W3C XHTML 1.0 The Extensible HyperText Markup Language (Second Edition),
  W3C Recommendation 26 January 2000, revised 1 August 2002,
  http://www.w3.org/TR/xhtml1
* W3C XML Path Language (XPath) Version 1.0,
  W3C Recommendation 16 November 1999,
  http://www.w3.org/TR/xpath
* W3C XSL Transformations (XSLT) Version 1.0,
  W3C Recommendation 16 November 1999,
  http://www.w3.org/TR/xslt

Change log:
0.9.1  - 2008-11-06 - Released as a first Work in Progress.
0.9.3  - 2009-05-31 - Released as a second Work in Progress.
1.0.0a - 2009-02-15 - Released as a third Work in Progress.
1.0.0b - 2010-05-31 - Released as a fourth Work in Progress.
1.0.0c - 2011-02-22 - Released as a fifth Work in Progress.
1.0.0d - 2011-06-21 - Released as a sixth Work in Progress.
1.0.0e - 2011-08-16 - Released as a seventh Work in Progress.
1.0.0f - 2011-09-13 - Released as a Work in Progress.
1.0.0g - 2011-09-13 - Member review of Draft Standard.
1.0.0  - 2012-03-19 - Released as DMTF Standard.
1.0.1  - 2012-08-19 - Released as DMTF Standard, with the following changes:
- Added tolerance for whitespace in the CIM-XML values of the following (whitespace-tolerant) qualifiers:
  Boolean-typed qualifiers: ASSOCIATION, INDICATION, ABSTRACT, KEY, REQUIRED, IN, OUT.
  Integer-typed qualifiers: MIN, MAX.
  String-typed qualifiers: EMBEDDEDINSTANCE.
- Added missing double quote in the message text of a profile error.
-->
<xsl:stylesheet version="1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mrp="http://schemas.dmtf.org/wbem/mgmtprofile/1" xmlns:mr="http://schemas.dmtf.org/wbem/messageregistry/1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
    <!-- Note:  In order to speed up processing, to enable offline work, and to deal with service refusals when
    accessing a file too often from the same source IP address, an XML catalog can be used to redirect the URLs stated
    in schema locations to local copies of these files.  -->
    <!-- Note:  The XML namespace declarations in the xsl:stylesheet element intentionally do not define the default namespace
    to be the XHTML namespace (i.e. xmlns="http://www.w3.org/1999/xhtml"). The reason is that the XSLT output method HTML
    only generates HTML-style tags (i.e. unclosed tags and separated end tags instead of self-closing tags) instead of XML-style
    tags when the HTML elements have no namespace. Note that for some HTML elements, it is crucial that they be generated
    as HTML-style tags (e.g. "script"). -->
    <!-- Note:  Although this XSLT stylesheet uses XSLT 1.0, it uses the XML Schema for XSLT 2.0.
    This has been done because there is no official XML schema for XSLT 1.0, and because the XML
    Schema for XSLT 2.0 is compatible to XSLT 1.0 in most areas. -->
    <!-- Note:  This XSLT stylesheet assumes that the input XML has been validated according to its XSD and
    does not perform any such XSD related checks. It does however implement a best effort approach
    to checking any rules on top of what is defined by the XSD. -->
    <xsl:output method="html" version="4.0" encoding="UTF-8" media-type="text/html" doctype-public="-//W3C//DTD HTML 4.01//EN" standalone="yes" omit-xml-declaration="yes" indent="no"/>
    <!-- The following global parameters can be overridden when invoking the XSLT transformation.
With the Xalan-J command line XSLT processor, the values for global parameters defined in this XSLT stylesheet can be overridden
using the -param command line option.
For example: -param standalone true.
For Web browsers, the values for global parameters defined in this XSLT stylesheet can be overridden by placing an xslt-param
processing instruction into the .mrp.xml file, before or after the xml-stylesheet processing instruction.
For example: <?xslt-param name="standalone" value="true"?>
This may not be supported by all web browsers; for Firefox, see https://developer.mozilla.org/en/XSLT/PI_Parameters. -->
    <xsl:param name="standalone">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether the generated output is standalone (that is, embeds any images and CSS stylesheets) or not. -->
    </xsl:param>
    <xsl:param name="cim-xml-root-url">
        <xsl:text>../resources/cim-xml</xsl:text>
        <!-- A URL referencing the root directory with the CIM-XML files of an underlying schema, with one .xml file per CIM class.
For performance reasons, these CIM-XML files must be local. Since Web browsers typically do not support URI resolution using XML catalogs,
the URL must be the final (local) URL to be used. Relative URLs are interpreted relative to the .mrp.xml file using this XSLT file.
The CIM-XML files for the CIM Schema can be downloaded from the public DMTF CIM page.
The CIM-XML files for other schemas can be generated from CIM MOF files using tools such as "cimmof" from OpenPegasus.
These CIM-XML files are expected to be in a directrory structure below that root directory that is defined as follows (using ABNF):
    cim-xml-url = cim-xml-root-url "/" schema-name "/" schema-version "/" class-name ".xml";
    schema-version = m "." n ["+"];
Where:
    cim-xml-url is the URL to the single CIM-XML file.
    cim-xml-root-url is the value of this variable, that is, the URL to the root directory.
    schema-name is the name of the schema, as specified in the @name attribute of the SchemaReference element, e.g.
        "CIM".
    schema-version is the major and minor version number of the schema specified in the @version attribute of the
        SchemaReference element, e.g. "2.19"; the latest published update verison number is implied (and must be in the
        directory), and the "+" is added when referencing the experimental version of the schema instead of the final
        version.
    class-name is the name of the class including its schema prefix, e.g. "CIM_ComputerSystem".
-->
    </xsl:param>
    <xsl:param name="css-url">
        <xsl:text>../resources/dsp8054_1.0.0.css</xsl:text>
        <!-- A URL referencing the CSS stylesheet that is used by the generated HTML output. To let the HTML output use
no CSS stylesheet, set the value to the empty string. The referenced CSS stylesheet needs to be compatible to DSP8054,
particularly in the use of its style names.
With current Web browsers, there is no support for XML catalogs, so the URL specified above should be a local URL, for
performance reasons.
In non-standalone HTML output (see global parameter "standalone"), this URL is used unchanged as a value for the "href"
attribute of a "link" element in the HTML output; relative URLs in this case are interpreted relative to the HTML
output file.
In standalone HTML output, this URL is resolved by the build environment using an XML catalog, and the resulting URL is
used to embed the CSS file into the HTML output. However, since the currently specified relative URL is not found in the
provided XML catalog, it is used directly; relative URLs in this case are interpreted relative to the current directory
of the build tool that embed the CSS file (normally, the profiles/xmp... directory), which is the directory where the
HTML output file is generated.
-->
    </xsl:param>
    <xsl:param name="tocgen-url">
        <xsl:text>../resources/tocgen.js</xsl:text>
        <!-- A URL referencing the Javascript file that is used by the generated HTML output to generate the tables of
contents, figures and tables. To let the HTML output not generate these tables,
set the value to the empty string. The referenced Javascript file nees to define a function body_load() that
replaces the contents of the "div" elements with the "id" attribute values "div-toc", "div-tof", "div-tot" with the
generated tables.
In non-standalone HTML output (see global parameter "standalone"), this URL is used unchanged as a value for the "src"
attribute of a "script" element in the HTML output; relative URLs in this case are interpreted relative to the HTML
output file.
In standalone HTML output, this URL is resolved by the build environment using an XML catalog, and the resulting URL is
used to embed the Javascript file into the HTML output. However, since the currently specified relative URL is not found in the
provided XML catalog, it is used directly; relative URLs in this case are interpreted relative to the current directory
of the build tool that embed the Javascript file (normally, the profiles/xmp... directory), which is the directory where the
HTML output file is generated.
-->
    </xsl:param>
    <xsl:param name="include-schema">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether the generated output includes information from the underlying CIM schema (e.g.
datatypes, qualifiers).
Todo: Add support for qualifiers. -->
    </xsl:param>
    <!-- The following variables might be customized by users of this stylesheet, but not all combinations of output
control variables have been tested. -->
    <xsl:variable name="description-table-limit">
        <xsl:text>200</xsl:text>
        <!-- Number of characters in a description that is still placed in a table.
              When that limit is exceeded, a subclause is triggered and the table will get a reference to the subclause.
              The number of characters simply counts the XML source definition of all child elements of the Description
              element.
        -->
    </xsl:variable>
    <xsl:variable name="heading-link-arrow">
        <xsl:text>&#x21D2;</xsl:text>
        <!-- Arrow at the beginning of links below headings:
              U+2192: RIGHTWARDS ARROW
              U+21D2: RIGHTWARDS DOUBLE ARROW
              U+21E8: RIGHTWARDS WHITE ARROW
        -->
    </xsl:variable>
    <xsl:variable name="output-heading-links">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether or not links below headings (back to some table or subclause) are created. -->
    </xsl:variable>
    <xsl:variable name="output-base-adaptations-in-adaptations-table">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether the base adaptations of an adaptation are shown in the overview table that
             shows all adaptations. If this variable is set to false and an adaptation defines base adaptations,
             creation of an adaptation subclause is triggered. -->
    </xsl:variable>
    <xsl:variable name="output-metrics-in-adaptations-table">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether the metric requirements of an adaptation are shown in the overview table that
             shows all adaptations. If this variable is set fo false and an adaptation defines metric requirements,
             creation of an adaptation subclause is triggered. -->
    </xsl:variable>
    <xsl:variable name="output-alert-messages-in-adaptations-table">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether the alert message requirements of an adaptation are shown in the overview table
             that shows all adaptations. If this variable is set to false and an adaptation defines alert message
             requirements, creation of an adaptation subclause is triggered. -->
    </xsl:variable>
    <xsl:variable name="output-property-datatypes">
        <xsl:value-of select="$include-schema"/>
        <!-- Boolean controlling whether or not a Datatype column is created for properties in adaptation element tables. -->
    </xsl:variable>
    <xsl:variable name="output-parameter-datatypes">
        <xsl:value-of select="$include-schema"/>
        <!-- Boolean controlling whether or not a Datatype column is created for parameters and return values in parameter tables. -->
    </xsl:variable>
    <xsl:variable name="output-operations-methods-class">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether or not a Class column is created in the operations and methods table. -->
    </xsl:variable>
    <xsl:variable name="output-operations-methods-table">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether or not the global operations and methods table is generated. -->
    </xsl:variable>
    <xsl:variable name="output-link-span-element">
        <xsl:text>false</xsl:text>
        <!-- Boolean controlling whether or not a "span" element is generated around the text content
of each "a" element (i.e. for all links). The DSP8054 CSS uses this span element for its "a.span:before"
and "a.span:after" statements that generate small cues before and after links. -->
    </xsl:variable>
    <!-- The following variables really should not be changed by users of this stylesheet. -->
    <xsl:variable name="headnum-delimiter">
        <xsl:text>&#xA0;&#xA0;&#xA0;</xsl:text>
        <!-- Delimiter text between XSLT generated heading numbers and the heading text:
              U+00A0: NO-BREAK SPACE
        -->
    </xsl:variable>
    <xsl:variable name="generate-headnum">
        <xsl:text>false</xsl:text>
        <!-- Control whether this XSLT stylesheet generates any heading numbers.
            If set to false, the expectation is that a CSS stylesheet generates the heading numbers before the heading text.
            The DSP8054 CSS stylesheet does generate heading numbers, so this control switch should be set to false.
            There is currently at least one case (operation subclauses) where the XSLT generated heading numbers produce
            incorrect numbers, due to encapsulating a very complex for-each loop condition, so do not set this control switch to true.
            The idea is to leave the XSLT number generation in the XSLT code for a while, until we are sure that we want to go with
            CSS based numbering. At that point, the code should be removed.
            Note that not all browsers currently support CSS based heading numbering. -->
    </xsl:variable>
    <xsl:variable name="generated-heading-id-prefix">
        <xsl:text>HG-</xsl:text>
        <!-- Prefix used in any generated values for the "id" attribute of heading elements and for the "name" attribute of anchor
            elements added to heading elements (e.g. for association operations). -->
    </xsl:variable>
    <xsl:variable name="qualifier-required-keyword">
        <xsl:text>Required</xsl:text>
        <!-- Keyword generated in output for indicating that the REQUIRED qualifier has an effective value of True. -->
    </xsl:variable>
    <xsl:variable name="qualifier-key-keyword">
        <xsl:text>Key</xsl:text>
        <!-- Keyword generated in output for indicating that the KEY qualifier has an effective value of True. -->
    </xsl:variable>
    <xsl:variable name="qualifier-in-keyword">
        <xsl:text>In</xsl:text>
        <!-- Keyword generated in output for indicating that the IN qualifier has an effective value of True. -->
    </xsl:variable>
    <xsl:variable name="qualifier-out-keyword">
        <xsl:text>Out</xsl:text>
        <!-- Keyword generated in output for indicating that the OUT qualifier has an effective value of True. -->
    </xsl:variable>
    <xsl:variable name="return-value-parameter-name">
        <xsl:text>ReturnValue</xsl:text>
        <!-- Parameter name of method return values in method parameter tables. -->
    </xsl:variable>
    <xsl:variable name="operation-set">
        <xsl:text>DSP0223</xsl:text>
        <!-- Operation set used in profiles. DSP1001 1.1 requires DSP0223 to be used as the only operation set. -->
    </xsl:variable>
    <xsl:variable name="PRP-profile-name">
        <xsl:text>Profile Registration</xsl:text>
        <!-- Registered name of the Profile Registration Profile (DSP1033). -->
    </xsl:variable>
    <xsl:variable name="PRP-profile-organization">
        <xsl:text>DMTF</xsl:text>
        <!-- Registered organization of the Profile Registration Profile (DSP1033). -->
    </xsl:variable>
    <xsl:variable name="PRP-RegisteredProfile-adaptation-name">
        <xsl:text>RegisteredProfile</xsl:text>
        <!-- Name of the adaptation of the CIM_RegisteredProfile class in the Profile Registration Profile (DSP1033). -->
    </xsl:variable>
    <xsl:variable name="xmlns-mrp">
        <xsl:text>http://schemas.dmtf.org/wbem/mgmtprofile/1</xsl:text>
        <!-- The XML namespace URI of the MRP schema. -->
    </xsl:variable>
    <xsl:variable name="uri-translate-from">
        <xsl:text> &amp;&lt;&gt;&apos;&quot;&#160;/:()</xsl:text>
        <!-- String with characters to translate from in document-local HTML references. These characters correspond to
             the characters defined in variable uri-translate-to, by their position in the string. -->
    </xsl:variable>
    <xsl:variable name="uri-translate-to">
        <xsl:text>-----------</xsl:text>
        <!-- String with characters to translate to in document-local HTML references. These characters correspond to
             the characters defined in variable uri-translate-from, by their position in the string. -->
    </xsl:variable>
    <xsl:variable name="lower-case">
        <xsl:text>abcdefghijklmnopqrstuvwxyz</xsl:text>
        <!-- String with lower case characters. These characters correspond to the characters defined in variable
             upper-case, by their position in the string. The character set to be covered is the set of allowed
             character for CIM names, which is nearly every Unicode character. Hence, this rather small set defined
             here represents a limitation. With XSLT 2.0 and XPATH 2.0, toupper() and tolower() functions will become
             available for this purpose. -->
    </xsl:variable>
    <xsl:variable name="upper-case">
        <xsl:text>ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:text>
        <!-- String with upper case characters. These characters correspond to the characters defined in variable
             lower-case, by their position in the string. -->
    </xsl:variable>
    <xsl:variable name="empty-cell">
        <xsl:text>&#xA0;</xsl:text>
        <!-- Value to be used for empty table cells. The intention of this variable is to ensure that an empty cell in
             a table is displayed consistently with non-empty cells, since the default display behavior seems to be that
             the borders are stripped away for empty cells. However, to date we did not find a way to do this. Any way
             to produce a blank character fails, since the blank is stripped away by some XSLT processing stage. For
             IE, the "nbsp" symbol works if the deprecated attribute disable-output-escaping="yes" is used, but it
             displays ampersand followed by "nbsp;" for those XSLT processors that do not support
             disable-output-escaping (e.g. SeaMonkey). -->
    </xsl:variable>
    <xsl:variable name="soft-hyphen">
        <xsl:text>&#x200B;</xsl:text>
        <!-- Characters used for soft hyphenation within a word, usually for column heading text.
             U+00AD (soft hyphen) is supposed to do the job. Some browsers (e.g. IE) support that, some
             others seem to ignore it (e.g. Firefox).
             U+200B (zero width space) breaks the word in all browsers if needed, but does not produce a hyphen.
             U+00AD+U+200B in combination causes the zero width space to take precedence in IE, so again no
             hyphen is generated.
             A comprehensive but somewhat opinionated discussion of the long story around the soft hyphen can be
             found here: http://www.cs.tut.fi/~jkorpela/shy.html -->
    </xsl:variable>
    <xsl:template match="/">
        <!-- Main template, invoked on the top level element of the MRP (that is, once). -->
        <xsl:variable name="mrp-version" select="/mrp:ProfileSpecification/@version"/>
        <xsl:variable name="profile-id" select="translate(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ID,$upper-case,$lower-case)"/>
        <xsl:variable name="profile-version-exact" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version"/>
        <xsl:variable name="profile-version-mn" select="concat(substring-before($profile-version-exact,'.'),'.',substring-before(substring-after($profile-version-exact,'.'),'.'))"/>
        <xsl:variable name="release-url-exact" select="concat('http://schemas.dmtf.org/wbem/mgmtprofile/',$profile-id,'_',$profile-version-exact,'.html')"/>
        <xsl:variable name="release-url-mn" select="concat('http://schemas.dmtf.org/wbem/mgmtprofile/',$profile-id,'_',$profile-version-mn,'.html')"/>
        <xsl:variable name="release2-url-exact" select="concat('http://www.dmtf.org/standards/published_documents/',$profile-id,'_',$profile-version-exact,'.html')"/>
        <xsl:variable name="release2-url-mn" select="concat('http://www.dmtf.org/standards/published_documents/',$profile-id,'_',$profile-version-mn,'.html')"/>
        <xsl:comment>
            <xsl:text>
DMTF - Distributed Management Task Force, Inc. - http://www.dmtf.org

Release URLs:
</xsl:text>
            <!-- For now: release only to published_documents.
            <xsl:value-of select="$release-url-exact"/>
            <xsl:text>
</xsl:text>
            <xsl:value-of select="$release-url-mn"/>
            <xsl:text>
</xsl:text>
-->
            <xsl:value-of select="$release2-url-exact"/>
            <xsl:text>
</xsl:text>
            <xsl:value-of select="$release2-url-mn"/>
            <xsl:text>

For document control information (e.g. title, date), copyright notice, and any disclaimers, open this document using a Web browser.
</xsl:text>
        </xsl:comment>
        <xsl:text>
</xsl:text>
        <html>
            <xsl:text>
</xsl:text>
            <head>
                <!-- Some standalone XSLT processors produce this meta statement automatically. Some browsers (e.g. IE) do not. It does not hurt to have two such statements.
                    This meta statement is needed to make the browser interpret characters as UTF-8 when the HTML or MRP XML file is local; for remote files served using
                    HTTP, the HTTP Content-Type header field takes precedence over this meta statement. -->
                <xsl:text>
</xsl:text>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                <xsl:text>
</xsl:text>
                <meta name="generator" content="DMTF DSP8029 XSLT Stylesheet, version 1.0.0"/>
                <xsl:text>
</xsl:text>
                <meta http-equiv="Content-Script-Type" content="text/javascript"/>
                <xsl:text>
</xsl:text>
                <meta id="docid">
                    <xsl:attribute name="content"><xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ID"/></xsl:attribute>
                </meta>
                <xsl:text>
</xsl:text>
                <meta id="doctitle">
                    <xsl:attribute name="content"><xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Title"/></xsl:attribute>
                </meta>
                <xsl:text>
</xsl:text>
                <meta id="docversion">
                    <xsl:attribute name="content"><xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version"/></xsl:attribute>
                </meta>
                <xsl:text>
</xsl:text>
                <xsl:variable name="document-status" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Status"/>
                <xsl:variable name="document-owning-entity" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:OwningEntity"/>
                <xsl:variable name="docstatusline">
                    <xsl:choose>
                        <xsl:when test="$document-status = 'In Development'">
                            <xsl:value-of select="$document-owning-entity"/>
                            <xsl:text> Confidential - </xsl:text>
                            <xsl:value-of select="$document-status"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$document-status"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <meta id="docstatusline">
                    <xsl:attribute name="content"><xsl:value-of select="$docstatusline"/></xsl:attribute>
                </meta>
                <xsl:text>
</xsl:text>
                <xsl:if test="$tocgen-url != ''">
                    <xsl:choose>
                        <xsl:when test="$standalone = 'true'">
                            <xsl:text>
</xsl:text>
                            <xsl:comment> Embedded Javascript file from "<xsl:value-of select="$tocgen-url"/>".</xsl:comment>
                            <xsl:text>
</xsl:text>
                            <script type="text/javascript">
                                <xsl:text>#EMBED-FILE(</xsl:text>
                                <xsl:value-of select="$tocgen-url"/>
                                <xsl:text>)</xsl:text>
                            </script>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>
</xsl:text>
                            <script type="text/javascript">
                                <xsl:attribute name="src"><xsl:value-of select="$tocgen-url"/></xsl:attribute>
                            </script>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:text>
</xsl:text>
                <xsl:if test="$css-url != ''">
                    <xsl:choose>
                        <xsl:when test="$standalone = 'true'">
                            <xsl:text>
</xsl:text>
                            <xsl:comment> Embedded CSS file from "<xsl:value-of select="$css-url"/>", with any comments stripped. </xsl:comment>
                            <xsl:text>
</xsl:text>
                            <style type="text/css">
                                <xsl:text>#EMBED-CSS-FILE(</xsl:text>
                                <xsl:value-of select="$css-url"/>
                                <xsl:text>)</xsl:text>
                            </style>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>
</xsl:text>
                            <link rel="stylesheet" type="text/css">
                                <xsl:attribute name="href"><xsl:value-of select="$css-url"/></xsl:attribute>
                            </link>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:variable name="title-tag">
                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ID"/>
                    <xsl:text>_</xsl:text>
                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version"/>
                </xsl:variable>
                <xsl:text>
</xsl:text>
                <title>
                    <xsl:value-of select="$title-tag"/>
                </title>
                <xsl:text>
</xsl:text>
            </head>
            <xsl:text>
</xsl:text>
            <body onload="body_load()">
                <xsl:if test="$mrp-version != '1.0'">
                    <!-- The above version check needs to be extended accordingly in future versions of MRP. -->
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Error: The MRP schema version "<xsl:value-of select="$mrp-version"/>" of this MRP profile is not supported by this version of the XSLT stylesheet DSP8029.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="output-Title"/>
                <xsl:call-template name="output-Copyright"/>
                <xsl:call-template name="output-TOC"/>
                <xsl:call-template name="output-Foreword"/>
                <xsl:call-template name="output-Introduction"/>
                <xsl:call-template name="output-H1-Scope">
                    <xsl:with-param name="h1-number" select="1"/>
                </xsl:call-template>
                <xsl:call-template name="output-H1-NormativeReferences">
                    <xsl:with-param name="h1-number" select="2"/>
                </xsl:call-template>
                <xsl:call-template name="output-H1-TermsAndDefinitions">
                    <xsl:with-param name="h1-number" select="3"/>
                </xsl:call-template>
                <xsl:call-template name="output-H1-SymbolsAndAbbreviations">
                    <xsl:with-param name="h1-number" select="4"/>
                </xsl:call-template>
                <!-- On the following test:  Either it is a profile and all of the clauses for profiles are generated,
                     or it is a glossary and none of the clauses for profiles is generated. The intention is NOT to
                     allow arbitrary combinations of these elements to be present or absent. -->
                <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/*[ self::mrp:ProfileAttributes or
self::mrp:Synopsis or self::mrp:Description or self::mrp:RelatedProfiles or
self::mrp:MessageRegistries or self::mrp:MetricRegistries or self::mrp:Features or self::mrp:Elements or
self::mrp:UseCases or self::mrp:Actors]) &gt; 0">
                    <!-- This is a profile (not a glossary). The presence of certain optional elements required for a
                         profile is verified inside of the invoked templates. -->
                    <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements) = 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: No profile elements (class adaptations, etc.) are defined in this profile (that is, the "Elements" element is missing).</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:call-template name="output-H1-Synopsis">
                        <xsl:with-param name="h1-number" select="5"/>
                    </xsl:call-template>
                    <xsl:call-template name="output-H1-Description">
                        <xsl:with-param name="h1-number" select="6"/>
                    </xsl:call-template>
                    <xsl:call-template name="output-H1-Impl">
                        <xsl:with-param name="h1-number" select="7"/>
                    </xsl:call-template>
                    <xsl:call-template name="output-H1-UseCases">
                        <xsl:with-param name="h1-number" select="8"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="output-A1-ChangeLog">
                    <xsl:with-param name="a1-number" select="'A'"/>
                </xsl:call-template>
                <xsl:call-template name="output-Bibliography"/>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="output-Title">
        <!-- Purpose: Output the title page of the profile. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="document-organization" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:OwningEntity"/>
        <xsl:variable name="document-type" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Type"/>
        <xsl:variable name="document-status" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Status"/>
        <xsl:variable name="document-title" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Title"/>
        <xsl:variable name="document-id" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ID"/>
        <xsl:variable name="document-version" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version"/>
        <xsl:text>
</xsl:text>
        <!-- The tocgen.js script uses the "id" attribute to identify the "div" element, in order to replace its
            contents with an error summary (in case of errors). -->
        <div id="div-err">
        </div>
        <p class="CoverLogoRight">
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Logo"/>
                <!-- no subject (logical) profile context -->
            </xsl:call-template>
        </p>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldRight">
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile) = 1 and $document-organization != /mrp:ProfileSpecification/mrp:Profile[1]/@organization">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Organization owning the document "<xsl:value-of select="$document-organization"/>" does not match registered profile organization "<xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile[1]/@organization"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:text>Document Number: </xsl:text>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ID"/>
        </p>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldRight">
            <xsl:text>Date: </xsl:text>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Date"/>
        </p>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldRight">
            <xsl:text>Version: </xsl:text>
            <xsl:value-of select="$document-version"/>
            <!-- This somewhat clumsy approach here simply strips a possible present draft level from the document version. -->
            <xsl:variable name="document-version-mnu" select="translate($document-version,$lower-case,'')"/>
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile) = 1 and $document-version-mnu != /mrp:ProfileSpecification/mrp:Profile[1]/@version">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Document version (without draft level) "<xsl:value-of select="$document-version-mnu"/>" does not match registered profile version "<xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile[1]/@version"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </p>
        <!-- Verify and output the development information, for profile documents owned by DMTF -->
        <xsl:if test="$document-organization = 'DMTF'">
            <xsl:choose>
                <xsl:when test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:DevelopmentInfo) &gt; 0">
                    <xsl:if test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:DevelopmentInfo/mrp:DevelopmentVersion) &gt; 0">
                        <xsl:text>
</xsl:text>
                        <p class="CoverFieldRight" style="color: blue;">
                            <xsl:text>Development Version: </xsl:text>
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:DevelopmentInfo/mrp:DevelopmentVersion"/>
                        </p>
                    </xsl:if>
                    <xsl:if test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:DevelopmentInfo/mrp:EditDate) &gt; 0">
                        <xsl:text>
</xsl:text>
                        <p class="CoverFieldRight" style="color: blue;">
                            <xsl:text>Development Edit Date: </xsl:text>
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:DevelopmentInfo/mrp:EditDate"/>
                        </p>
                    </xsl:if>
                    <xsl:if test="$document-status != 'In Development'">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Development information (mrp:DevelopmentInfo element) must not be specified for document status "<xsl:value-of select="$document-status"/>" but has been specified.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="$document-status = 'In Development'">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Development information (mrp:DevelopmentInfo element) needs to be specified for document status "In Development" but has not been specified.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <br/>
        <br/>
        <br/>
        <p class="CoverTitle">
            <xsl:value-of select="$document-title"/>
        </p>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile) = 1 and $document-title != concat(/mrp:ProfileSpecification/mrp:Profile[1]/@name,' Profile')">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: Document title "<xsl:value-of select="$document-title"/>" does not match registered profile name "<xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile[1]/@name"/>" followed by the word "Profile".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <br/>
        <br/>
        <br/>
        <!-- Verify and output the work in progress information, for profile documents owned by DMTF -->
        <xsl:if test="$document-organization = 'DMTF'">
            <xsl:choose>
                <xsl:when test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:WorkInProgressInfo) &gt; 0">
                    <xsl:text>
</xsl:text>
                    <table class="CoverWIPBox">
                        <tbody>
                            <xsl:text>
</xsl:text>
                            <tr>
                                <td>
                                    <div class="CoverWIPText">
                                        <p>IMPORTANT:  This specification is not a standard. It does not
necessarily reflect the views of the DMTF or all of its members. Because this document is a Work in Progress, this
specification may still change, perhaps profoundly. This document is available for public review and comment until the
stated expiration date.</p>
                                        <p>
                                            <xsl:text>This document expires on:  </xsl:text>
                                            <b>
                                                <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:WorkInProgressInfo/mrp:ExpirationDate"/>
                                            </b>
                                            <xsl:text>.</xsl:text>
                                        </p>
                                        <xsl:if test="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:WorkInProgressInfo/mrp:TargetVersion != ''">
                                            <p>
                                                <xsl:text>Target version for DMTF Standard:  </xsl:text>
                                                <b>
                                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:WorkInProgressInfo/mrp:TargetVersion"/>
                                                </b>
                                                <xsl:text>.</xsl:text>
                                            </p>
                                        </xsl:if>
                                        <p>
                                            <xsl:text>Provide any comments through the DMTF Feedback Portal: </xsl:text>
                                            <a class="UrlRef" href="http://www.dmtf.org/standards/feedback">
                                                <xsl:choose>
                                                    <xsl:when test="$output-link-span-element = 'true'">
                                                        <span class="UrlRef">
                                                            <xsl:text>http://www.dmtf.org/standards/feedback</xsl:text>
                                                        </span>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:text>http://www.dmtf.org/standards/feedback</xsl:text>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </a>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                            <xsl:text>
</xsl:text>
                        </tbody>
                    </table>
                    <xsl:text>
</xsl:text>
                    <br/>
                    <br/>
                    <br/>
                    <xsl:if test="$document-status != 'Work in Progress'">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Work-in-Progress information (that is, a "WorkInProgressInfo" element) must not be specified for document status "<xsl:value-of select="$document-status"/>" but has been specified.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="$document-status = 'Work in Progress'">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Work-in-Progress information (that is, a "WorkInProgressInfo" element) needs to be specified for document status "Work in Progress" but has not been specified.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldLeft">
            <xsl:text>Document Type: </xsl:text>
            <xsl:value-of select="$document-type"/>
        </p>
        <!-- Verify the permissible subset of document type values for profiles. -->
        <xsl:if test="$document-organization = 'DMTF' and $document-type != 'Specification'">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: The specified document type "<xsl:value-of select="$document-type"/>" is not allowed for a profile; the only valid document type is "Specification".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldLeft">
            <xsl:text>Document Status: </xsl:text>
            <xsl:value-of select="$document-status"/>
        </p>
        <!-- Verify the permissible subset of document status values for profiles. -->
        <xsl:if test="$document-organization = 'DMTF' and not( $document-status = 'DMTF Standard' or $document-status = 'DMTF Draft Standard' or $document-status = 'Work in Progress' or $document-status = 'In Development' )">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: The specified document status "<xsl:value-of select="$document-status"/>" is not allowed for a profile; valid document status values are "DMTF Standard", "DMTF Draft Standard", "Work in Progress", and "In Development".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:text>
</xsl:text>
        <p class="CoverFieldLeft">
            <xsl:text>Document Language: </xsl:text>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Language/@xml:lang"/>
        </p>
        <br/>
        <br/>
        <br/>
    </xsl:template>
    <xsl:template name="output-Copyright">
        <!-- Purpose: Output the "Copyright" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="heading-text" select="'Copyright notice'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Copyright')"/>
            <xsl:with-param name="heading-class" select="'Heading2-NoTOC'"/>
            <xsl:with-param name="heading-style" select="'page-break-before: always;'"/>
        </xsl:call-template>
        <!-- Output the copyright text. The element is required to be defined in the XSD. -->
        <xsl:text>
</xsl:text>
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Copyright"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h3'"/>
                <!-- no subject (logical) profile context -->
            </xsl:call-template>
        </div>
    </xsl:template>
    <xsl:template name="output-TOC">
        <!-- Purpose: Output the table of contents. -->
        <!-- Invocation context: Top level element. -->
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="heading-text" select="'CONTENTS'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'TOC')"/>
            <xsl:with-param name="heading-class" select="'Heading1-NoTOC'"/>
            <xsl:with-param name="heading-style" select="'font-weight: normal; text-align: center; page-break-before: always;'"/>
        </xsl:call-template>
        <xsl:text>
</xsl:text>
        <!-- The tocgen.js script uses the "id" attribute to identify the "div" element, in order to replace its contents with the generated table. -->
        <div id="div-toc">
            <xsl:text>[Insert table of contents here ...]</xsl:text>
        </div>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="heading-text" select="'Figures'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Figures')"/>
            <xsl:with-param name="heading-class" select="'Heading2-NoTOC'"/>
        </xsl:call-template>
        <xsl:text>
</xsl:text>
        <!-- The tocgen.js script uses the "id" attribute to identify the "div" element, in order to replace its contents with the generated table. -->
        <div id="div-tof">
            <xsl:text>[Insert table of figures here ...]</xsl:text>
        </div>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="heading-text" select="'Tables'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Tables')"/>
            <xsl:with-param name="heading-class" select="'Heading2-NoTOC'"/>
        </xsl:call-template>
        <xsl:text>
</xsl:text>
        <!-- The tocgen.js script uses the "id" attribute to identify the "div" element, in order to replace its contents with the generated table. -->
        <div id="div-tot">
            <xsl:text>[Insert table of tables here ...]</xsl:text>
        </div>
    </xsl:template>
    <xsl:template name="output-Foreword">
        <!-- Purpose: Output the "Foreword" clause. This includes acknowledgements. -->
        <!-- Invocation context: Top level element. -->
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="heading-text" select="'Foreword'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Foreword')"/>
            <xsl:with-param name="heading-class" select="'Heading1-NoNum'"/>
            <xsl:with-param name="heading-style" select="'font-weight: normal; text-align: center;'"/>
        </xsl:call-template>
        <!-- Output the foreword text. The element is required to be defined in the XSD. -->
        <xsl:text>
</xsl:text>
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Foreword"/>
                <!-- no subject (logical) profile context -->
            </xsl:call-template>
        </div>
        <!-- mrp:Acknowledgements is optional, as defined in the XSD. -->
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Acknowledgements) &gt; 0">
            <xsl:call-template name="output-heading-H2">
                <xsl:with-param name="heading-text" select="'Acknowledgements'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Acknowledgements')"/>
                <xsl:with-param name="heading-class" select="'Heading2-NoTOC'"/>
            </xsl:call-template>
            <!-- Output the acknowledgement introduction text. The element is required to be defined in the XSD. -->
            <xsl:text>
</xsl:text>
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Acknowledgements/mrp:Introduction"/>
                    <!-- no subject (logical) profile context -->
                </xsl:call-template>
            </div>
            <xsl:text>
</xsl:text>
            <ul class="List-Bullet">
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Acknowledgements/mrp:Person">
                    <xsl:text>
</xsl:text>
                    <li class="List-Bullet">
                        <xsl:value-of select="mrp:Name"/>
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="mrp:Entity"/>
                        <xsl:if test="count(mrp:Role) &gt; 0">
                            <xsl:text> (</xsl:text>
                            <xsl:value-of select="mrp:Role"/>
                            <xsl:text>)</xsl:text>
                        </xsl:if>
                    </li>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </ul>
            <xsl:text>
</xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-Introduction">
        <!-- Purpose: Output the "Introduction" clause, including document conventions. -->
        <!-- Invocation context: Top level element. -->
        <!-- mrp:Introduction is optional, as defined in the XSD. -->
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Introduction) &gt; 0">
            <xsl:call-template name="output-heading-H1">
                <xsl:with-param name="heading-text" select="'Introduction'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Introduction')"/>
                <xsl:with-param name="heading-class" select="'Heading1-NoNum'"/>
                <xsl:with-param name="heading-style" select="'font-weight: normal; text-align: center;'"/>
            </xsl:call-template>
            <!-- Output the document introduction text (presence was checked above). -->
            <xsl:text>
</xsl:text>
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Introduction"/>
                    <!-- no subject (logical) profile context -->
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- mrp:Conventions is optional, as defined in the XSD. -->
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Conventions) &gt; 0">
            <xsl:call-template name="output-heading-H2">
                <xsl:with-param name="heading-text" select="'Document conventions'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'DocConventions')"/>
                <xsl:with-param name="heading-class" select="'Heading2-NoTOC'"/>
            </xsl:call-template>
            <!-- Output the document convention text (presence was checked above). -->
            <xsl:text>
</xsl:text>
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Conventions"/>
                    <xsl:with-param name="topmost-allowed-heading-level" select="'h3'"/>
                    <!-- no subject (logical) profile context -->
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Scope">
        <!-- Purpose: Output the "Scope" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="heading-text" select="'Scope'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Scope')"/>
            <xsl:with-param name="heading-style" select="'page-break-before: always;'"/>
        </xsl:call-template>
        <!-- Output the document scope text. The element is required to be defined in the XSD. -->
        <xsl:text>
</xsl:text>
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Scope"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h2'"/>
                <!-- no subject (logical) profile context -->
            </xsl:call-template>
        </div>
    </xsl:template>
    <xsl:template name="output-H1-NormativeReferences">
        <!-- Purpose: Output the "Normative References" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:NormativeReferences) &gt; 0">
            <xsl:call-template name="output-heading-H1">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="heading-text" select="'Normative references'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'References')"/>
            </xsl:call-template>
            <!-- Output the normative references introduction text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:Introduction) &gt; 0">
                <xsl:text>
</xsl:text>
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:Introduction"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:text>
</xsl:text>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference">
                <xsl:call-template name="output-DocumentReference"/>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-DocumentReference">
        <!-- Purpose: Output a single document reference element in the "Normative References" clause or "Bibliography". -->
        <!-- Invocation context: The mrp:DocumentReference element to be output. -->
        <xsl:text>
</xsl:text>
        <p>
            <xsl:text>
</xsl:text>
            <a>
                <xsl:attribute name="name"><xsl:value-of select="translate(@name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
            </a>
            <xsl:choose>
                <xsl:when test="mrp:OwningEntity = 'DMTF'">
                    <!-- Output all the elements that are stated to be required for DMTF owned documents. -->
                    <!-- Note that not all of that is enforced by the XSD, but it is described to be required there. -->
                    <xsl:value-of select="mrp:OwningEntity"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="mrp:ID"/>
                    <xsl:text>, </xsl:text>
                    <i>
                        <xsl:value-of select="mrp:Title"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="mrp:Version"/>
                    </i>
                    <xsl:text>,</xsl:text>
                    <br/>
                    <xsl:text>
</xsl:text>
                    <a class="UrlRef">
                        <xsl:attribute name="href"><xsl:value-of select="mrp:Location"/></xsl:attribute>
                        <xsl:attribute name="title">Link to the referenced document, using the displayed URL</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$output-link-span-element = 'true'">
                                <span class="UrlRef">
                                    <xsl:value-of select="mrp:Location"/>
                                </span>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="mrp:Location"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Do a best effort job to accommodate all the possibly present elements. -->
                    <xsl:if test="mrp:OwningEntity != ''">
                        <xsl:value-of select="mrp:OwningEntity"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="mrp:ID"/>
                        <xsl:text>, </xsl:text>
                    </xsl:if>
                    <xsl:if test="count(mrp:Author) &gt; 0">
                        <i>
                            <xsl:for-each select="mrp:Author">
                                <xsl:value-of select="self::*"/>
                                <xsl:if test="position() &lt; last()">
                                    <xsl:text>, </xsl:text>
                                </xsl:if>
                            </xsl:for-each>
                            <xsl:text>: </xsl:text>
                        </i>
                    </xsl:if>
                    <i>
                        <xsl:value-of select="mrp:Title"/>
                    </i>
                    <xsl:if test="mrp:Version != ''">
                        <i>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="mrp:Version"/>
                        </i>
                    </xsl:if>
                    <xsl:if test="mrp:Date != ''">
                        <i>
                            <xsl:text>, </xsl:text>
                            <xsl:value-of select="mrp:Date"/>
                        </i>
                    </xsl:if>
                    <xsl:if test="mrp:Location != ''">
                        <xsl:text>,</xsl:text>
                        <br/>
                        <xsl:text>
</xsl:text>
                        <a class="UrlRef">
                            <xsl:attribute name="href"><xsl:value-of select="mrp:Location"/></xsl:attribute>
                            <xsl:attribute name="title">Link to the referenced document, using the displayed URL</xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="UrlRef">
                                        <xsl:value-of select="mrp:Location"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="mrp:Location"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>
</xsl:text>
        </p>
    </xsl:template>
    <xsl:template name="output-H1-TermsAndDefinitions">
        <!-- Purpose: Output the "Terms and Definitions" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions) &gt; 0">
            <xsl:call-template name="output-heading-H1">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="heading-text" select="'Terms and definitions'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Terms')"/>
            </xsl:call-template>
            <xsl:variable name="general-element-count" select="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermReferences) + count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinitionDocument)"/>
            <!-- Output the terms and definitions introduction text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:Introduction) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:Introduction"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinition) &gt; 0 and $general-element-count &gt; 0">
                <xsl:call-template name="output-heading-H2">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="1"/>
                    <xsl:with-param name="heading-text" select="'General'"/>
                    <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Terms-General')"/>
                </xsl:call-template>
            </xsl:if>
            <!-- Output the term references text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermReferences) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermReferences"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinitionDocument) &gt; 0">
                <xsl:text>The terms defined in </xsl:text>
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinitionDocument">
                    <xsl:call-template name="output-link-NormativeReferences-entry">
                        <xsl:with-param name="ref-name" select="@refName"/>
                        <xsl:with-param name="linktext" select="self::*"/>
                    </xsl:call-template>
                    <xsl:choose>
                        <xsl:when test="position() &lt; last() - 1">
                            <xsl:text>, </xsl:text>
                        </xsl:when>
                        <xsl:when test="position() = last() - 1">
                            <xsl:text>, and </xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
                <xsl:text> apply to this document.</xsl:text>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinition) &gt; 0">
                    <p>The following additional terms are defined in this document.</p>
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinition">
                        <xsl:choose>
                            <xsl:when test="$general-element-count &gt; 0">
                                <xsl:call-template name="output-H1-TermsAndDefinitions-H2-Definition">
                                    <xsl:with-param name="h1-number" select="$h1-number"/>
                                    <xsl:with-param name="h2-number" select="1+position()"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="output-H1-TermsAndDefinitions-H2-Definition">
                                    <xsl:with-param name="h1-number" select="$h1-number"/>
                                    <xsl:with-param name="h2-number" select="position()"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="$general-element-count &gt; 0">
                            <p>This document does not define any additional terms.</p>
                        </xsl:when>
                        <xsl:otherwise>
                            <p>This document does not define any terms.</p>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-TermsAndDefinitions-H2-Definition">
        <!-- Purpose: Output a single term definition clause in the "Terms and Definitions" clause. -->
        <!-- Invocation context: The mrp:TermDefinition element to be output. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:variable name="term">
            <xsl:value-of select="mrp:Term"/>
        </xsl:variable>
        <xsl:variable name="term-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="term-heading-id">
            <xsl:value-of select="translate($term-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="heading-text" select="' '"/>
            <!-- Headings without heading text cause strange effects in some browsers. So we generate a blank. -->
            <xsl:with-param name="heading-id" select="$term-heading-id"/>
            <xsl:with-param name="heading-class" select="'Term-RefNum'"/>
        </xsl:call-template>
        <p class="Term-Name">
            <xsl:value-of select="$term"/>
        </p>
        <div class="Term-Definition">
            <xsl:choose>
                <xsl:when test="count(mrp:Definition) &gt; 1">
                    <p>This term has multiple definitions:</p>
                    <xsl:text>
</xsl:text>
                    <ul class="List-Number">
                        <xsl:for-each select="mrp:Definition">
                            <xsl:text>
</xsl:text>
                            <li class="List-Number">
                                <xsl:call-template name="output-XHTMLText">
                                    <xsl:with-param name="XHTML-text-element" select="self::node()"/>
                                    <!-- no subject (logical) profile context -->
                                </xsl:call-template>
                            </li>
                        </xsl:for-each>
                        <xsl:text>
</xsl:text>
                    </ul>
                </xsl:when>
                <xsl:otherwise>
                    <!-- At least one is required to be specified, as defined in the XSD -->
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="mrp:Definition"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    <xsl:template name="output-H1-SymbolsAndAbbreviations">
        <!-- Purpose: Output the "Symbols and Abbreviations" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations) &gt; 0">
            <xsl:call-template name="output-heading-H1">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="heading-text" select="'Symbols and abbreviated terms'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Symbols')"/>
            </xsl:call-template>
            <xsl:variable name="general-element-count" select="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolReferences) + count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinitionDocument)"/>
            <!-- Output the symbols and abbreviations introduction text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:Introduction) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:Introduction"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinition) &gt; 0 and $general-element-count &gt; 0">
                <xsl:call-template name="output-heading-H2">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="1"/>
                    <xsl:with-param name="heading-text" select="'General'"/>
                    <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Symbols-General')"/>
                </xsl:call-template>
            </xsl:if>
            <!-- Output the symbols and abbreviations reference text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolReferences) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolReferences"/>
                        <!-- no subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinitionDocument) &gt; 0">
                <p>
                    <xsl:text>The abbreviations defined in </xsl:text>
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinitionDocument">
                        <xsl:call-template name="output-link-NormativeReferences-entry">
                            <xsl:with-param name="ref-name" select="@refName"/>
                            <xsl:with-param name="linktext" select="self::*"/>
                        </xsl:call-template>
                        <xsl:choose>
                            <xsl:when test="position() &lt; last() - 1">
                                <xsl:text>, </xsl:text>
                            </xsl:when>
                            <xsl:when test="position() = last() - 1">
                                <xsl:text>, and </xsl:text>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:for-each>
                    <xsl:text> apply to this document.</xsl:text>
                </p>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinition) &gt; 0">
                    <p>The following additional abbreviations are defined in this document.</p>
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinition">
                        <xsl:choose>
                            <xsl:when test="$general-element-count &gt; 0">
                                <xsl:call-template name="output-H1-SymbolsAndAbbreviations-H2-Definition">
                                    <xsl:with-param name="h1-number" select="$h1-number"/>
                                    <xsl:with-param name="h2-number" select="1+position()"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="output-H1-SymbolsAndAbbreviations-H2-Definition">
                                    <xsl:with-param name="h1-number" select="$h1-number"/>
                                    <xsl:with-param name="h2-number" select="position()"/>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="$general-element-count &gt; 0">
                            <p>This document does not define any additional abbreviations.</p>
                        </xsl:when>
                        <xsl:otherwise>
                            <p>This document does not define any abbreviations.</p>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-SymbolsAndAbbreviations-H2-Definition">
        <!-- Purpose: Output a single symbol definition clause in the "Symbols and Abbreviations" clause. -->
        <!-- Invocation context: The mrp:SymbolDefinition element to be output. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:variable name="symbol">
            <xsl:value-of select="mrp:Symbol"/>
        </xsl:variable>
        <xsl:variable name="symbol-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="symbol-heading-id">
            <xsl:value-of select="translate($symbol-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="heading-text" select="' '"/>
            <!-- Headings without heading text cause strange effects in some browsers. So we generate a blank. -->
            <xsl:with-param name="heading-id" select="$symbol-heading-id"/>
            <xsl:with-param name="heading-class" select="'Sym-RefNum'"/>
        </xsl:call-template>
        <p class="Sym-Name">
            <xsl:value-of select="$symbol"/>
        </p>
        <!-- Output the symbol definition text. The element is required to be defined in the XSD. -->
        <div class="Sym-Definition">
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:Definition"/>
                <!-- no subject (logical) profile context -->
            </xsl:call-template>
        </div>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis">
        <!-- Purpose: Output the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="heading-text" select="'Synopsis'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Synopsis')"/>
        </xsl:call-template>
        <xsl:call-template name="output-H1-Synopsis-Attributes"/>
        <xsl:call-template name="output-H1-Synopsis-Description"/>
        <xsl:call-template name="output-H1-Synopsis-ProfileReferencesTable"/>
        <xsl:call-template name="output-H1-Synopsis-MessageRegistryReferencesTable"/>
        <xsl:call-template name="output-H1-Synopsis-MetricRegistryReferencesTable"/>
        <xsl:call-template name="output-H1-Synopsis-FeaturesTable"/>
        <xsl:call-template name="output-H1-Synopsis-AdaptationsTable"/>
        <xsl:if test="$output-operations-methods-table = 'true'">
            <xsl:call-template name="output-H1-Synopsis-OperationsAndMethodsTable"/>
        </xsl:if>
        <!-- disabled for the time being (table has too many columns, and information can also be retrieved from diagrams).
            <xsl:call-template name="output-H1-Synopsis-InstanceGraphTable"/>
        -->
        <xsl:call-template name="output-H1-Synopsis-UseCasesTable"/>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-Attributes">
        <!-- Purpose: Output the list of profile attributes in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes) = 0">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: No profile attributes are defined in this profile (that is, the "ProfileAttributes" element is missing).</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <p>
            <b>Profile name:&#xA0;&#xA0;</b>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        </p>
        <p>
            <b>Version:&#xA0;&#xA0;</b>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/@version"/>
        </p>
        <p>
            <b>Organization:&#xA0;&#xA0;</b>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        </p>
        <p>
            <b>Abstract indicator:&#xA0;&#xA0;</b>
            <xsl:choose>
                <xsl:when test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/@abstract = 'true'">
                    <!-- This test also covers the default case of "false". -->
                    <xsl:text>True</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>False</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </p>
        <p>
            <b>Profile type:&#xA0;&#xA0;</b>
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/@profileType"/>
        </p>
        <p>
            <xsl:choose>
                <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference) &gt;= 1">
                    <b>Schema:&#xA0;&#xA0;</b>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: No schema references are defined in this profile (that is, the "Schemas" element is missing).</xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference">
                <xsl:if test="position() &gt; 1">
                    <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="@organization"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="@version"/>
                <xsl:choose>
                    <xsl:when test="@experimental = 'true'">
                        <!-- This test also covers the default case of "false". -->
                        <xsl:text> (experimental)</xsl:text>
                        <xsl:variable name="document-organization" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:OwningEntity"/>
                        <xsl:variable name="document-status" select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Status"/>
                        <xsl:if test="$document-organization = 'DMTF' and ( $document-status = 'DMTF Draft Standard' or $document-status = 'DMTF Standard' )">
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: An experimental schema must not be referenced from a profile with status "<xsl:value-of select="$document-status"/>".</xsl:with-param>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- xsl:text> (final)</xsl:text -->
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </p>
        <!-- mrp:CentralClassAdaptation is required, as defined in the XSD -->
        <xsl:variable name="central-class-adaptation-name">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:CentralClassAdaptation/@name"/>
        </xsl:variable>
        <!-- mrp:ScopingClassAdaptation is required, as defined in the XSD -->
        <xsl:variable name="scoping-class-adaptation-name">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:ScopingClassAdaptation/@name"/>
        </xsl:variable>
        <p>
            <b>Central class adaptation:&#xA0;&#xA0;</b>
            <xsl:call-template name="output-link-Adaptation-tableentry">
                <xsl:with-param name="adaptation-name" select="$central-class-adaptation-name"/>
            </xsl:call-template>
        </p>
        <p>
            <b>Scoping class adaptation:&#xA0;&#xA0;</b>
            <xsl:call-template name="output-link-Adaptation-tableentry">
                <xsl:with-param name="adaptation-name" select="$scoping-class-adaptation-name"/>
            </xsl:call-template>
        </p>
        <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/@profileType = 'Component'">
            <p>
                <!-- mrp:ScopingPath is optional, as defined in the XSD (but required as per the PUG, for component profiles) -->
                <xsl:choose>
                    <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:ScopingPath) = 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: No scoping path is defined in this component profile (that is, the "ProfileAttributes/ScopingPath" element is missing).</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <b>Scoping path:&#xA0;&#xA0;</b>
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:ScopingPath/*">
                            <xsl:if test="position() &gt; 1">
                                <xsl:text>, </xsl:text>
                            </xsl:if>
                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                <xsl:with-param name="adaptation-name" select="self::*/@name"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </p>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-Description">
        <!-- Purpose: Output the description text in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Synopsis) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: No synopsis description is defined in this profile (that is, the "Synopsis" element is missing).</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Output the synopsis text (presence has been checked above). -->
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:Synopsis"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-ProfileReferencesTable">
        <!-- Purpose: Output the profile references table (aka "related profiles table") in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles) = 0">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: No profile references are defined in this profile (that is, the "RelatedProfiles" element is missing).</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile) &gt; 0">
                <p>The following table identifies the profile references defined in this profile.</p>
                <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile [@relationship = 'Derivation']) &gt; 1">
                    <p class="DeprecatedStart"/>
                    <span class="DeprecatedKeyword">DEPRECATED: </span>
                    <xsl:text>This profile references more than one base profile. Referencing more than one base profile has been deprecated in </xsl:text>
                    <xsl:call-template name="output-link-NormativeReferences-entry">
                        <xsl:with-param name="ref-name" select="'Ref_DMTF_DSP1001'"/>
                        <xsl:with-param name="linktext" select="'DSP1001'"/>
                    </xsl:call-template>
                    <xsl:text>.</xsl:text>
                    <p class="DeprecatedEnd"/>
                </xsl:if>
                <xsl:text>
</xsl:text>
                <table class="Table" id="T-ProfileReferences">
                    <caption class="Table-Caption">Profile references</caption>
                    <thead class="Table-Head">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <th class="Table-HeadCell">Profile reference name</th>
                            <th class="Table-HeadCell">Profile name</th>
                            <th class="Table-HeadCell">Organi<xsl:value-of select="$soft-hyphen"/>zation</th>
                            <th class="Table-HeadCell">Version</th>
                            <th class="Table-HeadCell">Relation<xsl:value-of select="$soft-hyphen"/>ship</th>
                            <th class="Table-HeadCell">Description</th>
                        </tr>
                        <xsl:text>
</xsl:text>
                    </thead>
                    <tbody class="Table-Body">
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile">
                            <xsl:text>
</xsl:text>
                            <tr>
                                <td class="Table-BodyCell">
                                    <!-- Column: Profile reference name -->
                                    <xsl:text>
</xsl:text>
                                    <a>
                                        <xsl:attribute name="name"><xsl:text>T-P-</xsl:text><xsl:value-of select="translate(@refName, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    </a>
                                    <xsl:value-of select="@refName"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Profile name -->
                                    <xsl:choose>
                                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                                        <xsl:when test="not(@docRefName != '')">
                                            <xsl:if test="@name != /mrp:ProfileSpecification/mrp:Profile/@name">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: The profile reference with registered profile name "<xsl:value-of select="@name"/>" does not reference a corresponding normative references entry (that is, the "docRefName" attribute is missing).</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>
                                            <xsl:value-of select="@name"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:if test="@name = /mrp:ProfileSpecification/mrp:Profile/@name">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: The profile reference with registered profile name "<xsl:value-of select="@name"/>" is the subject profile but it references a normative references entry (that is, the "docRefName" attribute is specified when it must not be specified).</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>
                                            <xsl:call-template name="output-link-NormativeReferences-entry">
                                                <xsl:with-param name="ref-name" select="@docRefName"/>
                                                <xsl:with-param name="linktext" select="@name"/>
                                            </xsl:call-template>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Organization -->
                                    <xsl:value-of select="@organization"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Version -->
                                    <xsl:value-of select="@version"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Relationship -->
                                    <xsl:choose>
                                        <xsl:when test="@relationship = 'Usage'">
                                            <xsl:if test="count(mrp:Requirement) = 0">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: A requirement level (that is, a "Requirement" element) is missing for the profile reference to the used profile with registered name "<xsl:value-of select="@name"/>".</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:when test="@relationship = 'Derivation'">
                                            <xsl:text>Derivation</xsl:text>
                                            <xsl:if test="count(mrp:Requirement) &gt; 0">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: A requirement level (that is, a "Requirement" element) is specified for the profile reference to the profile with registered name "<xsl:value-of select="@name"/>" but the subject profile is derived from that profile.</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <!-- Cannot happen if the MRP profile conforms to the XSD, but we want to issue an error regardless in this case. -->
                                            <xsl:call-template name="ErrorMsg">
                                                <xsl:with-param name="msg">Profile Error: Unknown profile relationship type "<xsl:value-of select="@relationship"/>" is specified for the profile reference with registered name "<xsl:value-of select="@name"/>".</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Description -->
                                    <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                    <xsl:if test="count(mrp:Description) &gt; 0">
                                        <div>
                                            <xsl:call-template name="output-XHTMLText">
                                                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                        </div>
                                    </xsl:if>
                                    <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                        <div>
                                            <p>Condition:</p>
                                            <xsl:call-template name="output-Condition">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                        </div>
                                    </xsl:if>
                                    <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                        <div>
                                            <xsl:call-template name="output-XHTMLText">
                                                <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                        </div>
                                    </xsl:if>
                                </td>
                            </tr>
                        </xsl:for-each>
                        <xsl:text>
</xsl:text>
                    </tbody>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any profile references.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-MessageRegistryReferencesTable">
        <!-- Purpose: Output the message registry references table (if any) in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:MessageRegistries/mrp:Registry) &gt; 0">
            <p>The following table identifies the message registry references defined in this profile.</p>
            <xsl:text>
</xsl:text>
            <table class="Table" id="T-MessageRegistryReferences">
                <caption class="Table-Caption">Message registry references</caption>
                <thead class="Table-Head">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <th class="Table-HeadCell">Registry reference name</th>
                        <th class="Table-HeadCell">Registry ID</th>
                        <th class="Table-HeadCell">Organization</th>
                        <th class="Table-HeadCell">Version</th>
                        <th class="Table-HeadCell">Description</th>
                    </tr>
                    <xsl:text>
</xsl:text>
                </thead>
                <tbody class="Table-Body">
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:MessageRegistries/mrp:Registry">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td class="Table-BodyCell">
                                <!-- Column: Registry reference name -->
                                <xsl:text>
</xsl:text>
                                <a>
                                    <xsl:attribute name="name"><xsl:text>T-MessageRegistries-</xsl:text><xsl:value-of select="translate(@refName, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                </a>
                                <xsl:value-of select="@refName"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Registry ID -->
                                <xsl:call-template name="output-link-NormativeReferences-entry">
                                    <xsl:with-param name="ref-name" select="@docRefName"/>
                                    <xsl:with-param name="linktext" select="@id"/>
                                </xsl:call-template>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Organization -->
                                <xsl:value-of select="@organization"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Version -->
                                <xsl:value-of select="@version"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Description -->
                                <xsl:if test="count(mrp:Description) &gt; 0">
                                    <xsl:call-template name="output-XHTMLText">
                                        <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                    </xsl:call-template>
                                </xsl:if>
                            </td>
                        </tr>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-MetricRegistryReferencesTable">
        <!-- Purpose: Output the metric registry references table (if any) in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:MetricRegistries/mrp:Registry) &gt; 0">
            <p>The following table identifies the metric registry references defined in this profile.</p>
            <xsl:text>
</xsl:text>
            <table class="Table" id="T-MetricRegistryReferences">
                <caption class="Table-Caption">Metric registry references</caption>
                <thead class="Table-Head">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <th class="Table-HeadCell">Registry reference name</th>
                        <th class="Table-HeadCell">Registry ID</th>
                        <th class="Table-HeadCell">Organization</th>
                        <th class="Table-HeadCell">Version</th>
                        <th class="Table-HeadCell">Description</th>
                    </tr>
                    <xsl:text>
</xsl:text>
                </thead>
                <tbody class="Table-Body">
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:MetricRegistries/mrp:Registry">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td class="Table-BodyCell">
                                <!-- Column: Registry reference name -->
                                <xsl:text>
</xsl:text>
                                <a>
                                    <xsl:attribute name="name"><xsl:text>T-MetricRegistries-</xsl:text><xsl:value-of select="translate(@organization, $uri-translate-from, $uri-translate-to)"/><xsl:text>-</xsl:text><xsl:value-of select="translate(@id, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                </a>
                                <xsl:value-of select="@refName"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Registry ID -->
                                <xsl:call-template name="output-link-NormativeReferences-entry">
                                    <xsl:with-param name="ref-name" select="@docRefName"/>
                                    <xsl:with-param name="linktext" select="@id"/>
                                </xsl:call-template>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Organization -->
                                <xsl:value-of select="@organization"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Version -->
                                <xsl:value-of select="@version"/>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Description -->
                                <xsl:if test="count(mrp:Description) &gt; 0">
                                    <xsl:call-template name="output-XHTMLText">
                                        <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                    </xsl:call-template>
                                </xsl:if>
                            </td>
                        </tr>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-FeaturesTable">
        <!-- Purpose: Output the features table (if any) in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature) &gt; 0">
                <p>The following table identifies the features defined in this profile.</p>
                <xsl:text>
</xsl:text>
                <table class="Table" id="T-Features">
                    <caption class="Table-Caption">Features</caption>
                    <thead class="Table-Head">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <th class="Table-HeadCell">Feature</th>
                            <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                            <th class="Table-HeadCell">Description</th>
                        </tr>
                        <xsl:text>
</xsl:text>
                    </thead>
                    <tbody class="Table-Body">
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature">
                            <xsl:variable name="feature-name">
                                <xsl:value-of select="@name"/>
                            </xsl:variable>
                            <xsl:text>
</xsl:text>
                            <tr>
                                <td class="Table-BodyCell">
                                    <!-- Column: Feature -->
                                    <xsl:text>
</xsl:text>
                                    <a>
                                        <xsl:attribute name="name"><xsl:text>T-F-</xsl:text><xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    </a>
                                    <xsl:value-of select="$feature-name"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Requirement -->
                                    <xsl:call-template name="output-RequirementLevel">
                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                    </xsl:call-template>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Description -->
                                    <xsl:text>See </xsl:text>
                                    <xsl:call-template name="output-link-Feature-subclause">
                                        <xsl:with-param name="feature-name" select="$feature-name"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </td>
                            </tr>
                        </xsl:for-each>
                        <xsl:text>
</xsl:text>
                    </tbody>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any features.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-AdaptationsTable">
        <!-- Purpose: Output the adaptations table in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <p>The following table identifies the class adaptations defined in this profile.</p>
        <xsl:text>
</xsl:text>
        <table class="Table" id="T-Adaptations">
            <caption class="Table-Caption">Adaptations</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Adaptation</th>
                    <th class="Table-HeadCell">Elements</th>
                    <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:text>
</xsl:text>
                <tr>
                    <td class="Table-BodySeparatorCell" colspan="4">Instantiated, embedded and abstract adaptations</td>
                </tr>
                <xsl:choose>
                    <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [
                        not (@implementationType != '') or @implementationType = 'Instantiated' or
                        @implementationType = 'Embedded' or @implementationType = 'Abstract' ]) &gt; 0">
                        <!-- In the above and below tests, the double inversion for the empty value is required to detect that the attribute is not specified. -->
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [
                                not (@implementationType != '') or @implementationType = 'Instantiated' or
                                @implementationType = 'Embedded' or @implementationType = 'Abstract' ] ">
                            <xsl:variable name="adaptation-name">
                                <xsl:value-of select="@name"/>
                            </xsl:variable>
                            <xsl:variable name="implementation-type">
                                <xsl:call-template name="get-effective-implementation-type">
                                    <xsl:with-param name="implementation-type" select="@implementationType"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:variable name="shown-number-base-adaptations">
                                <!-- number of base adaptations to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-base-adaptations-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:variable name="shown-number-metrics">
                                <!-- number of metrics to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-metrics-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation/mrp:Metric)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:variable name="shown-number-alert-messages">
                                <!-- number of alert messages to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-alert-messages-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation/mrp:AlertMessage)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <tr>
                                <td class="Table-BodyCell">
                                    <xsl:attribute name="rowspan"><xsl:value-of select="1+$shown-number-base-adaptations+$shown-number-metrics+$shown-number-alert-messages"/></xsl:attribute>
                                    <!-- Column: Adaptation -->
                                    <xsl:text>
</xsl:text>
                                    <a>
                                        <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate(@name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    </a>
                                    <xsl:value-of select="$adaptation-name"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Elements -->
                                    <xsl:value-of select="@className"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Requirement -->
                                    <xsl:call-template name="output-RequirementLevelOfAdaptation">
                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                        <xsl:with-param name="implementation-type" select="$implementation-type"/>
                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                    </xsl:call-template>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Description -->
                                    <xsl:choose>
                                        <xsl:when test="( count(mrp:BaseAdaptation) &gt; 0 and $output-base-adaptations-in-adaptations-table='false' ) or
                                            ( count(mrp:BaseAdaptation/mrp:Metric) &gt; 0 and $output-metrics-in-adaptations-table='false' ) or
                                            ( count(mrp:BaseAdaptation/mrp:AlertMessage) &gt; 0 and $output-alert-messages-in-adaptations-table='false' ) or
                                            ( count(mrp:ModelDescription) + count(mrp:Property) + count(mrp:Method) + count(mrp:Operation) +
                                                count(mrp:InstanceRequirement) + count(mrp:Constraint) &gt; 0 ) or
                                            ( count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 ) or
                                            ( string-length(mrp:Description) &gt; $description-table-limit ) or count(mrp:ConcreteSubclassRequirement) &gt; 0">
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-subclause">
                                                <xsl:with-param name="adaptation-name" select="@name"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:call-template name="output-ImplementationType">
                                                <xsl:with-param name="implementation-type" select="$implementation-type"/>
                                                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                <xsl:with-param name="is-association" select="@isAssociation"/>
                                            </xsl:call-template>
                                            <xsl:text>. See schema definition.</xsl:text>
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <br/>
                                                <xsl:call-template name="output-XHTMLText">
                                                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                            <xsl:if test="$shown-number-base-adaptations &gt; 0">
                                <xsl:for-each select="mrp:BaseAdaptation">
                                    <tr>
                                        <!-- Column: Adaptation is already occupied via row spanning -->
                                        <td class="Table-BodyCell">
                                            <!-- Column: Elements -->
                                            <xsl:if test="@profileRefName != ''">
                                                <xsl:value-of select="@profileRefName"/>
                                                <xsl:text>::</xsl:text>
                                            </xsl:if>
                                            <xsl:value-of select="@name"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                <xsl:with-param name="adaptation-name" select="@name"/>
                                                <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                            <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                            <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                                <div>
                                                    <p>Condition:</p>
                                                    <xsl:call-template name="output-Condition">
                                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$shown-number-metrics &gt; 0">
                                <xsl:for-each select="mrp:BaseAdaptation/mrp:Metric">
                                    <xsl:variable name="metric-local-id">
                                        <xsl:value-of select="@localId"/>
                                    </xsl:variable>
                                    <xsl:variable name="metric-reg-ref-name">
                                        <xsl:value-of select="@regRefName"/>
                                    </xsl:variable>
                                    <tr>
                                        <!-- Column: Adaptation is already occupied via row spanning -->
                                        <td class="Table-BodyCell">
                                            <!-- Column: Elements -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-Metric-</xsl:text><xsl:value-of select="translate($metric-local-id, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:call-template name="output-link-MetricRegistries-tableentry">
                                                <xsl:with-param name="ref-name" select="$metric-reg-ref-name"/>
                                            </xsl:call-template>
                                            <xsl:text>::</xsl:text>
                                            <xsl:value-of select="$metric-local-id"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                            <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                                <div>
                                                    <p>Condition:</p>
                                                    <xsl:call-template name="output-Condition">
                                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$shown-number-alert-messages &gt; 0">
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines alert message requirements but is not an indication.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td class="Table-BodyCell" colspan="4">This profile does not define any such adaptations.</td>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>
</xsl:text>
                <tr>
                    <td class="Table-BodySeparatorCell" colspan="4">Indications and exceptions</td>
                </tr>
                <xsl:choose>
                    <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [
                        @implementationType = 'Indication' or @implementationType = 'Exception' ]) &gt; 0">
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [
                        @implementationType = 'Indication' or @implementationType = 'Exception' ]">
                            <xsl:variable name="adaptation-name">
                                <xsl:value-of select="@name"/>
                            </xsl:variable>
                            <xsl:variable name="implementation-type">
                                <xsl:call-template name="get-effective-implementation-type">
                                    <xsl:with-param name="implementation-type" select="@implementationType"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:variable name="shown-number-base-adaptations">
                                <!-- number of base adaptations to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-base-adaptations-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:variable name="shown-number-metrics">
                                <!-- number of metrics to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-metrics-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation/mrp:Metric)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:variable name="shown-number-alert-messages">
                                <!-- number of alert messages to show in the table -->
                                <xsl:choose>
                                    <xsl:when test="$output-alert-messages-in-adaptations-table = 'true'">
                                        <xsl:value-of select="count(mrp:BaseAdaptation/mrp:AlertMessage)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="0"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <tr>
                                <td class="Table-BodyCell">
                                    <xsl:attribute name="rowspan"><xsl:value-of select="1+$shown-number-base-adaptations+$shown-number-metrics+$shown-number-alert-messages"/></xsl:attribute>
                                    <!-- Column: Adaptation -->
                                    <xsl:text>
</xsl:text>
                                    <a>
                                        <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate(@name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    </a>
                                    <xsl:value-of select="$adaptation-name"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Elements -->
                                    <xsl:value-of select="@className"/>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Requirement -->
                                    <xsl:call-template name="output-RequirementLevelOfAdaptation">
                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                        <xsl:with-param name="implementation-type" select="$implementation-type"/>
                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                    </xsl:call-template>
                                </td>
                                <td class="Table-BodyCell">
                                    <!-- Column: Description -->
                                    <xsl:choose>
                                        <xsl:when test="( count(mrp:BaseAdaptation) &gt; 0 and $output-base-adaptations-in-adaptations-table='false' ) or
                                            ( count(mrp:BaseAdaptation/mrp:Metric) &gt; 0 and $output-metrics-in-adaptations-table='false' ) or
                                            ( count(mrp:BaseAdaptation/mrp:AlertMessage) &gt; 0 and $output-alert-messages-in-adaptations-table='false' ) or
                                            ( count(mrp:Property) + count(mrp:Method) + count(mrp:Operation) + count(mrp:InstanceRequirement) + count(mrp:Constraint) &gt; 0 ) or
                                            ( count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 ) or
                                            ( string-length(mrp:Description) &gt; $description-table-limit ) or count(mrp:ConcreteSubclassRequirement) &gt; 0">
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-subclause">
                                                <xsl:with-param name="adaptation-name" select="@name"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>See schema definition.</xsl:text>
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <br/>
                                                <xsl:call-template name="output-XHTMLText">
                                                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                            <xsl:if test="$shown-number-base-adaptations &gt; 0">
                                <xsl:for-each select="mrp:BaseAdaptation">
                                    <tr>
                                        <!-- Column: Adaptation is already occupied via row spanning -->
                                        <td class="Table-BodyCell">
                                            <!-- Column: Elements -->
                                            <xsl:if test="@profileRefName != ''">
                                                <xsl:value-of select="@profileRefName"/>
                                                <xsl:text>::</xsl:text>
                                            </xsl:if>
                                            <xsl:value-of select="@name"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                <xsl:with-param name="adaptation-name" select="@name"/>
                                                <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                            <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                            <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                                <div>
                                                    <p>Condition:</p>
                                                    <xsl:call-template name="output-Condition">
                                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$shown-number-metrics &gt; 0">
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines metric requirements but is an indication or exception.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                            <xsl:if test="$shown-number-alert-messages &gt; 0">
                                <xsl:for-each select="mrp:BaseAdaptation/mrp:AlertMessage">
                                    <xsl:variable name="message-id">
                                        <xsl:value-of select="@prefix"/>
                                        <xsl:value-of select="@sequenceNumber"/>
                                    </xsl:variable>
                                    <xsl:variable name="text-registry-ref-name">
                                        <xsl:value-of select="@regRefName"/>
                                    </xsl:variable>
                                    <tr>
                                        <!-- Column: Adaptation is already occupied via row spanning -->
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-AlertMessage-</xsl:text><xsl:value-of select="translate($message-id, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:call-template name="output-link-MessageRegistries-tableentry">
                                                <xsl:with-param name="ref-name" select="$text-registry-ref-name"/>
                                            </xsl:call-template>
                                            <xsl:text>::</xsl:text>
                                            <xsl:value-of select="$message-id"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                            <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                                <div>
                                                    <p>Condition:</p>
                                                    <xsl:call-template name="output-Condition">
                                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td class="Table-BodyCell" colspan="4">This profile does not define any such adaptations.</td>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-OperationsAndMethodsTable">
        <!-- Purpose: Output the operations and methods table (if any) in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Operation) &gt; 0 or count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method) &gt; 0">
                <p>The following table identifies the operations and methods defined in this profile.</p>
                <xsl:text>
</xsl:text>
                <table class="Table" id="T-OperationsAndMethods">
                    <caption class="Table-Caption">Operations and methods</caption>
                    <thead class="Table-Head">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <th class="Table-HeadCell">Adaptation</th>
                            <xsl:if test="$output-operations-methods-class = 'true'">
                                <th class="Table-HeadCell">Class</th>
                            </xsl:if>
                            <th class="Table-HeadCell">Operation / method</th>
                            <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                            <th class="Table-HeadCell">Description</th>
                        </tr>
                        <xsl:text>
</xsl:text>
                    </thead>
                    <tbody class="Table-Body">
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation">
                            <xsl:variable name="adaptation-name">
                                <xsl:value-of select="@name"/>
                            </xsl:variable>
                            <xsl:variable name="class-name">
                                <xsl:value-of select="@className"/>
                            </xsl:variable>
                            <!-- Output the operation entries in the table -->
                            <xsl:for-each select="mrp:Operation">
                                <xsl:variable name="operation-name">
                                    <xsl:value-of select="@name"/>
                                </xsl:variable>
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Adaptation -->
                                        <xsl:text>
</xsl:text>
                                        <a>
                                            <xsl:attribute name="name"><xsl:text>T-OperationsMethods-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-operation-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                        </a>
                                        <xsl:call-template name="output-link-Adaptation-tableentry">
                                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                        </xsl:call-template>
                                    </td>
                                    <xsl:if test="$output-operations-methods-class = 'true'">
                                        <td class="Table-BodyCell">
                                            <!-- Column: Class -->
                                            <xsl:value-of select="$class-name"/>
                                        </td>
                                    </xsl:if>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Operation / method -->
                                        <xsl:text>Operation </xsl:text>
                                        <xsl:value-of select="$operation-name"/>
                                        <xsl:text>(&#xA0;)</xsl:text>
                                    </td>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Requirement -->
                                        <xsl:call-template name="output-RequirementLevel">
                                            <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                        </xsl:call-template>
                                    </td>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Description -->
                                        <xsl:text>See </xsl:text>
                                        <!-- Todo: Operation link does not work for association operations (add the association-adaptation-name parameter).
                                                Needs to be fixed if the 'output-operations-methods-table' control switch is supposed to be enabled again. -->
                                        <xsl:call-template name="output-link-Operation-tableentry">
                                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                            <xsl:with-param name="operation-name" select="$operation-name"/>
                                        </xsl:call-template>
                                        <xsl:text>.</xsl:text>
                                    </td>
                                </tr>
                            </xsl:for-each>
                            <!-- Output the method entries in the table -->
                            <xsl:for-each select="mrp:Method">
                                <xsl:variable name="method-name">
                                    <xsl:value-of select="@name"/>
                                </xsl:variable>
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Adaptation -->
                                        <xsl:text>
</xsl:text>
                                        <a>
                                            <xsl:attribute name="name"><xsl:text>T-OperationsMethods-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-method-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                        </a>
                                        <xsl:call-template name="output-link-Adaptation-tableentry">
                                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                        </xsl:call-template>
                                    </td>
                                    <xsl:if test="$output-operations-methods-class = 'true'">
                                        <td class="Table-BodyCell">
                                            <!-- Column: Class -->
                                            <xsl:value-of select="$class-name"/>
                                        </td>
                                    </xsl:if>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Operation / method -->
                                        <xsl:text>Method </xsl:text>
                                        <xsl:value-of select="$method-name"/>
                                        <xsl:text>(&#xA0;)</xsl:text>
                                    </td>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Requirement -->
                                        <xsl:call-template name="output-RequirementLevel">
                                            <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                        </xsl:call-template>
                                    </td>
                                    <td class="Table-BodyCell">
                                        <!-- Column: Description -->
                                        <xsl:text>See </xsl:text>
                                        <xsl:call-template name="output-link-Method-tableentry">
                                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                            <xsl:with-param name="method-name" select="$method-name"/>
                                        </xsl:call-template>
                                        <xsl:text>.</xsl:text>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </xsl:for-each>
                        <xsl:text>
</xsl:text>
                    </tbody>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any operations or methods.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-InstanceGraphTable">
        <!-- Purpose: Output the instance graph table in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <p>The following table lists all association adaptations defined in this profile, providing information that allows an instance graph to be created for the profile.</p>
        <xsl:text>
</xsl:text>
        <table class="Table" id="T-InstanceGraph">
            <caption class="Table-Caption">Instance graph</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell" colspan="2">Association</th>
                    <th class="Table-HeadCell" colspan="3">End #1</th>
                    <th class="Table-HeadCell" colspan="3">End #2</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Adaptation</th>
                    <th class="Table-HeadCell">Arity</th>
                    <th class="Table-HeadCell">Adaptation</th>
                    <th class="Table-HeadCell">Role</th>
                    <th class="Table-HeadCell">Effective multiplicity</th>
                    <th class="Table-HeadCell">Adaptation</th>
                    <th class="Table-HeadCell">Role</th>
                    <th class="Table-HeadCell">Effective multiplicity</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @isAssociation = 'true' ]">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                <xsl:with-param name="adaptation-name" select="@name"/>
                            </xsl:call-template>
                        </td>
                        <td class="Table-BodyCell">
                            <xsl:value-of select="count(mrp:Property[ @refClassAdaptation != '' ])"/>
                        </td>
                        <xsl:for-each select="mrp:Property[ @refClassAdaptation != '' ]">
                            <td class="Table-BodyCell">
                                <xsl:call-template name="output-link-Adaptation-tableentry">
                                    <xsl:with-param name="adaptation-name" select="@refClassAdaptation"/>
                                </xsl:call-template>
                            </td>
                            <td class="Table-BodyCell">
                                <xsl:call-template name="output-link-Property-tableentry">
                                    <xsl:with-param name="adaptation-name" select="../@name"/>
                                    <xsl:with-param name="property-name" select="@name"/>
                                </xsl:call-template>
                            </td>
                            <td class="Table-BodyCell">
                                <xsl:call-template name="output-effective-ref-multiplicity">
                                    <xsl:with-param name="adaptation-name" select="../@name"/>
                                    <xsl:with-param name="class-name" select="../@className"/>
                                    <xsl:with-param name="reference-name" select="@name"/>
                                    <xsl:with-param name="profile-ref-min" select="@refMin"/>
                                    <xsl:with-param name="profile-ref-max" select="@refMax"/>
                                </xsl:call-template>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
        <p>The "effective multiplicity" in the table above is the multiplicity when taking into account the multiplicity
defined in the adapted schema association (or global defaults if not specified there), and any multiplicity
constraints defined in the profile.</p>
        <p>For information about whether or not this profile constrains the schema-defined multiplicities for a
reference, see the description of that reference.</p>
    </xsl:template>
    <xsl:template name="output-H1-Synopsis-UseCasesTable">
        <!-- Purpose: Output the use cases and state descriptios table (if any) in the "Synopsis" clause. -->
        <!-- Invocation context: Top level element. -->
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/*) &gt; 0">
                <p>The following table identifies the use cases and state descriptions defined in this profile.</p>
                <xsl:text>
</xsl:text>
                <table class="Table" id="T-UseCasesAndStateDescriptions">
                    <caption class="Table-Caption">Use cases and state descriptions</caption>
                    <thead class="Table-Head">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <th class="Table-HeadCell">Name</th>
                            <th class="Table-HeadCell">Description</th>
                        </tr>
                        <xsl:text>
</xsl:text>
                    </thead>
                    <tbody class="Table-Body">
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/*">
                            <xsl:choose>
                                <xsl:when test="local-name(self::*) = 'UseCase'">
                                    <xsl:variable name="usecase-name">
                                        <xsl:value-of select="@name"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Name -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-UC-</xsl:text><xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:text>Use case </xsl:text>
                                            <xsl:value-of select="$usecase-name"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-UseCase-subclause">
                                                <xsl:with-param name="usecase-name" select="$usecase-name"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                        </td>
                                    </tr>
                                </xsl:when>
                                <xsl:when test="local-name(self::*) = 'StateDescription'">
                                    <xsl:variable name="statedescription-name">
                                        <xsl:value-of select="@name"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Name -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-SD-</xsl:text><xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:text>State description </xsl:text>
                                            <xsl:value-of select="$statedescription-name"/>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-StateDescription-subclause">
                                                <xsl:with-param name="statedescription-name" select="$statedescription-name"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                        </td>
                                    </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- Cannot happen if the MRP profile conforms to the XSD, but we want to issue an error regardless in this case. -->
                                    <xsl:call-template name="ErrorMsg">
                                        <xsl:with-param name="msg">Profile Error: Unknown child element "<xsl:value-of select="local-name(self::*)"/>" defined in a "UseCases" element.</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                        <xsl:text>
</xsl:text>
                    </tbody>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any use cases or state descriptions.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Description">
        <!-- Purpose: Output the "Description" clause of the profile. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="h1-number"/>
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="heading-text" select="'Description'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Description')"/>
        </xsl:call-template>
        <xsl:variable name="subject-profile-name" select="/mrp:ProfileSpecification/mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="/mrp:ProfileSpecification/mrp:Profile/@organization"/>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Description) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: No profile description is defined in this profile (that is, the profile-level "Description" element is missing).</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Output the profile description (presence has been checked above). -->
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:Description"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        <xsl:with-param name="topmost-allowed-heading-level" select="'h2'"/>
                    </xsl:call-template>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Impl">
        <!-- Purpose: Output the "Implementation" clause of the profile. -->
        <!-- Invocation context: Top level element. -->
        <!-- Note:  To support the generation of numbered headings under the funcitonal rules of XSLT processing, this
             template and the templates for the subclauses of the "Implementation" clause use a "chaining" approach, as
             follows:  If the next subclause to be output has a less significant (that is, higher numbered) heading level
             than the current template, it is invoked at the end of the current template with 1 as the new least than
             significant heading number. If the next subclause to be output has a the same heading level as the than
             current template, it is invoked at the end of the current template with an increased least significant than
             heading number. If the next subclause to be output has a more significant (that is, lower numbered) heading
             level than the current template, the current template simply returns without calling any other template.
        -->
        <xsl:param name="h1-number"/>
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="heading-text" select="'Implementation'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Implementation')"/>
        </xsl:call-template>
        <xsl:call-template name="output-H1-Impl-H2-Features">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="1"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Features">
        <!-- Purpose: Output the "Features" subclause (if any) in the "Implementation" clause. -->
        <!-- Invocation context: Top level element. -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature) &gt; 0">
                <xsl:call-template name="output-heading-H2">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number"/>
                    <xsl:with-param name="heading-text" select="'Features'"/>
                    <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Features')"/>
                </xsl:call-template>
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature">
                    <xsl:call-template name="output-H1-Impl-H2-Features-H3-FeatureX">
                        <xsl:with-param name="h1-number" select="$h1-number"/>
                        <xsl:with-param name="h2-number" select="$h2-number"/>
                        <xsl:with-param name="h3-number" select="position()"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:call-template name="output-H1-Impl-H2-Adapts">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number+1"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="output-H1-Impl-H2-Adapts">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number+1"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Features-H3-FeatureX">
        <!-- Purpose: Output a single feature subclause in the "Features" subclause. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="feature-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="feature-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>F-</xsl:text>
            <xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Feature: </xsl:text>
            <xsl:value-of select="$feature-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H3">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$feature-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <xsl:call-template name="output-link-Feature-tableentry">
                <xsl:with-param name="feature-name" select="$feature-name"/>
                <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Features table entry')"/>
            </xsl:call-template>
        </xsl:if>
        <!-- Output the feature description. The element is required to be defined in the XSD. -->
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h4'"/>
            </xsl:call-template>
        </div>
        <div>
            <xsl:call-template name="output-RequirementText">
                <xsl:with-param name="text-begin" select="'The requirement level for this feature is '"/>
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <p>
            <xsl:if test="count(mrp:Granularity/*) != 1">
                <!-- Cannot happen if the MRP profile conforms to the XSD, but we want to issue an error regardless in this case. -->
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Feature "<xsl:value-of select="$feature-name"/>" does not specify exactly one granularity.</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:text>This feature can be made available to clients at the granularity of </xsl:text>
            <xsl:choose>
                <xsl:when test="local-name(mrp:Granularity/*) = 'Instance'">
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="mrp:Granularity/mrp:Instance/@adaptationName"/>
                    </xsl:call-template>
                    <xsl:text> instances.</xsl:text>
                </xsl:when>
                <xsl:when test="local-name(mrp:Granularity/*) = 'Profile'">
                    <xsl:text>an implementation of this profile.</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Cannot happen if the MRP profile conforms to the XSD, but we want to issue an error regardless in this case. -->
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Feature "<xsl:value-of select="$feature-name"/>" specifies an unsupported type of granularity "<xsl:value-of select="local-name(mrp:Granularity/*)"/>".</xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </p>
        <xsl:variable name="granularity-type">
            <xsl:choose>
                <xsl:when test="local-name(mrp:Granularity/*) = 'Instance'">
                    <xsl:text>instance</xsl:text>
                </xsl:when>
                <xsl:when test="local-name(mrp:Granularity/*) = 'Profile'">
                    <xsl:text>profile</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>unknown</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="count(mrp:Discovery) &gt; 1">
                <p>Availability of this feature can be discovered by clients through any of the following mechanisms:</p>
                <xsl:if test="count(mrp:Discovery[@preferred = 'true']) = 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Feature "<xsl:value-of select="$feature-name"/>" has more than one discovery mechanism defined but none of these mechanisms is designated as preferred.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(mrp:Discovery[@preferred = 'true']) &gt; 1">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Feature "<xsl:value-of select="$feature-name"/>" has more than one discovery mechanism defined but more than one of these mechanisms is designated as preferred.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <xsl:text>
</xsl:text>
                <ul>
                    <xsl:for-each select="mrp:Discovery">
                        <xsl:text>
</xsl:text>
                        <li>
                            <xsl:if test="@preferred = 'true'">
                                <p>This discovery mechanism is the preferred mechanism.</p>
                            </xsl:if>
                            <xsl:call-template name="output-FeatureDiscovery">
                                <xsl:with-param name="discovery-element" select="self::*"/>
                                <xsl:with-param name="feature-name" select="$feature-name"/>
                                <xsl:with-param name="granularity-type" select="$granularity-type"/>
                                <xsl:with-param name="instance-granularity-adaptation-name" select="../mrp:Granularity/mrp:Instance/@adaptationName"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <xsl:when test="count(mrp:Discovery) = 1">
                <!-- We ignore whether or not the @preferred attribute is specified, if exactly one discovery mechanism is specified. -->
                <!-- No introductory statement is needed, since this template will produce such a sentence already. -->
                <xsl:call-template name="output-FeatureDiscovery">
                    <xsl:with-param name="discovery-element" select="mrp:Discovery"/>
                    <xsl:with-param name="feature-name" select="$feature-name"/>
                    <xsl:with-param name="granularity-type" select="$granularity-type"/>
                    <xsl:with-param name="instance-granularity-adaptation-name" select="mrp:Granularity/mrp:Instance/@adaptationName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <p>Availability of this feature cannot be discovered by clients (other than trying the functionality provided by the feature).</p>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:variable name="feature-usage-count">
            <xsl:call-template name="output-FeatureUsageCount">
                <xsl:with-param name="feature-name" select="$feature-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="$feature-usage-count &gt; 0">
            <p>The following profile elements are conditional or conditional exclusive on the implementation of this feature:</p>
            <xsl:call-template name="output-FeatureUsage">
                <xsl:with-param name="feature-name" select="$feature-name"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts">
        <!-- Purpose: Output the "Adaptations" subclause in the "Implementation" clause. -->
        <!-- Invocation context: Top level element. -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="heading-text" select="'Adaptations'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Adaptations')"/>
        </xsl:call-template>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/*) &gt; 0">
                <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-Conventions">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number"/>
                    <xsl:with-param name="h3-number" select="1"/>
                </xsl:call-template>
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [
                    ( count(mrp:BaseAdaptation) &gt; 0 and $output-base-adaptations-in-adaptations-table='false' ) or
                    ( count(mrp:BaseAdaptation/mrp:Metric) &gt; 0 and $output-metrics-in-adaptations-table='false' ) or
                    ( count(mrp:BaseAdaptation/mrp:AlertMessage) &gt; 0 and $output-alert-messages-in-adaptations-table='false' ) or
                    ( count(mrp:ModelDescription) + count(mrp:Property) + count(mrp:Method) + count(mrp:Operation) + count(mrp:InstanceRequirement) + count(mrp:Constraint) &gt; 0 ) or
                    ( count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 ) or
                    ( string-length(mrp:Description) &gt; $description-table-limit ) ]">
                    <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX">
                        <xsl:with-param name="h1-number" select="$h1-number"/>
                        <xsl:with-param name="h2-number" select="$h2-number"/>
                        <xsl:with-param name="h3-number" select="1+position()"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any class adaptations.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-Conventions">
        <!-- Purpose: Output the "Conventions" subclause in the "Adaptations" subclause. -->
        <!-- Invocation context: Top level element. -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:call-template name="output-heading-H3">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="heading-text" select="'Conventions'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'AdaptationConventions')"/>
        </xsl:call-template>
        <!-- Output conventions for operations -->
        <p>
            <xsl:text>This profile defines operation requirements based on </xsl:text>
            <xsl:call-template name="output-link-NormativeReferencesOperationSet-entry">
                <xsl:with-param name="operation-set" select="$operation-set"/>
            </xsl:call-template>
            <xsl:text>.</xsl:text>
        </p>
        <p>For adaptations of ordinary classes and of associations the requirements for operations are defined in adaptation-specific subclauses of the "Adaptations" clause.</p>
        <p>For association traversal operation requirements that are specified only in the elements table of an adaptation (i.e. without operation-specific subclauses), the names of the association adaptations to be traversed are listed in the elements table.</p>
        <p>The default initialization requirement level for property requirements is optional.</p>
        <p>The default modification requirement level for property requirements is optional.</p>
        <!-- Output conventions for certain qualifiers -->
        <xsl:text>
</xsl:text>
        <p>This profile repeats the effective values of certain Boolean qualifiers as part of property, method parameter, or method return value requirements.
The following convention is established:
If the name of a qualifier is listed, its effective value is True; if the qualifier name is not listed, its effective value is False.
The convention is applied in the following cases:</p>
        <xsl:text>
</xsl:text>
        <ul>
            <li>In: indicates that the parameter is an input parameter</li>
            <li>Out: indicates that the parameter is an output parameter</li>
            <li>Key: indicates that the property is a key (that is, its value is part of the instance path)</li>
            <li>Required: indicates that the element value shall be non-Null</li>
            <li>Null OK: indicates explicitly that the element value may be Null for mandatory, conditional or conditional exclusive properties.
This information is not specified as a qualifier in the schema but as an indicator in the profile</li>
            <xsl:text>
</xsl:text>
        </ul>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX">
        <!-- Purpose: Output a single adaptation subclause in the "Adaptations" subclause. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="@className"/>
        </xsl:variable>
        <xsl:variable name="adaptation-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Adaptation: </xsl:text>
            <xsl:value-of select="$adaptation-name"/>
            <xsl:text>: </xsl:text>
            <xsl:value-of select="$class-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H3">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$adaptation-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <xsl:call-template name="output-link-Adaptation-tableentry">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Adaptations table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <xsl:variable name="property-subclause-count">
            <xsl:value-of select="count(mrp:Property[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                @refClassAdaptation != '' or count(mrp:Constraint) &gt; 0 or
                count(mrp:Modification) &gt; 0 or count(mrp:Initialization) &gt; 0])"/>
        </xsl:variable>
        <xsl:variable name="method-subclause-count">
            <xsl:value-of select="count(mrp:Method[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                count(mrp:Constraint) &gt; 0 or count(mrp:Error) &gt; 0 or count(mrp:Parameter) &gt; 0 or count(mrp:ReturnValue) &gt; 0 ])"/>
        </xsl:variable>
        <xsl:variable name="operation-subclause-count">
            <xsl:value-of select="count(mrp:Operation[ count(mrp:Description) &gt; 0 or
                count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                count(mrp:Constraint) &gt; 0 or count(mrp:Message) &gt; 0 ])"/>
        </xsl:variable>
        <xsl:choose>
            <!-- The subclause-based output and the simple output have separate templates for historical reasons (the subclause-based output had separate
            subclauses for general, implementation requirements, and element requirements up to 1.0.0c). At this point, the output of both templates is the
            same for the first subclause, so they could be merged, once that turns out to be stable. -->
            <xsl:when test="$property-subclause-count + $method-subclause-count + $operation-subclause-count &gt; 0">
                <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number"/>
                    <xsl:with-param name="h3-number" select="$h3-number"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Simple">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number"/>
                    <xsl:with-param name="h3-number" select="$h3-number"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Simple">
        <!-- Purpose: Output an adaptation subclause in simple mode (that is, no subclauses). -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="@className"/>
        </xsl:variable>
        <xsl:variable name="implementation-type">
            <xsl:call-template name="get-effective-implementation-type">
                <xsl:with-param name="implementation-type" select="@implementationType"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the adaptation model description, if specified. -->
        <xsl:choose>
            <xsl:when test="count(mrp:ModelDescription) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="mrp:ModelDescription"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <p>This adaptation does not define a model description.</p>
            </xsl:otherwise>
        </xsl:choose>
        <!-- Output the adaptation description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="topmost-allowed-heading-level" select="'h5'"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output implementation type and presentation requirement level -->
        <div>
            <xsl:call-template name="output-ImplementationTypeAndRequirementTextOfAdaptation">
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="concrete-subclass-requirement-element" select="mrp:ConcreteSubclassRequirement"/>
                <xsl:with-param name="implementation-type" select="$implementation-type"/>
                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="is-association" select="@isAssociation"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <!-- Output adaptation constraints, if any -->
        <xsl:choose>
            <xsl:when test="count(mrp:Constraint) = 1">
                <p>The implementation shall satisfy the following constraint for this adaptation:</p>
                <xsl:text>
</xsl:text>
                <div class="Normal-Indent1">
                    <xsl:call-template name="output-Constraint">
                        <xsl:with-param name="constraint-element" select="mrp:Constraint"/>
                        <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) &gt; 1">
                <p>The implementation shall satisfy the following constraints for this adaptation:</p>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
                <xsl:text>
</xsl:text>
            </xsl:when>
            <!-- Otherwise: nothing to do -->
        </xsl:choose>
        <!-- Output the instance requirements text, if specified. -->
        <xsl:if test="count(mrp:InstanceRequirements) &gt; 0">
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:InstanceRequirements"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h5'"/>
            </xsl:call-template>
        </xsl:if>
        <!-- Output elements table -->
        <xsl:call-template name="output-Adaptation-ElementsTable">
            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses">
        <!-- Purpose: Output an adaptation subclause in complex mode (that is, with subclauses). -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <!-- First subclause -->
        <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-General">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="1"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-General">
        <!-- Purpose: Output an adaptation subclause in complex mode - subclause "General". -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation -->
        <!-- Note:  This template is part of a "chaining" approach to support numbered headings, as described in the
             template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="@className"/>
        </xsl:variable>
        <xsl:variable name="implementation-type">
            <xsl:call-template name="get-effective-implementation-type">
                <xsl:with-param name="implementation-type" select="@implementationType"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>General</xsl:text>
        </xsl:variable>
        <xsl:variable name="heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-General</xsl:text>
        </xsl:variable>
        <xsl:call-template name="output-heading-H4">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$heading-id"/>
        </xsl:call-template>
        <!-- Output the adaptation model description, if specified. -->
        <xsl:choose>
            <xsl:when test="count(mrp:ModelDescription) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="mrp:ModelDescription"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <p>This adaptation does not define a model description.</p>
            </xsl:otherwise>
        </xsl:choose>
        <!-- Output the adaptation description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="topmost-allowed-heading-level" select="'h5'"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output implementation type and presentation requirement level -->
        <div>
            <xsl:call-template name="output-ImplementationTypeAndRequirementTextOfAdaptation">
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="concrete-subclass-requirement-element" select="mrp:ConcreteSubclassRequirement"/>
                <xsl:with-param name="implementation-type" select="$implementation-type"/>
                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="is-association" select="@isAssociation"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <!-- Output adaptation constraints, if any -->
        <xsl:choose>
            <xsl:when test="count(mrp:Constraint) = 1">
                <p>The implementation shall satisfy the following constraint for this adaptation:</p>
                <div class="Normal-Indent1">
                    <xsl:call-template name="output-Constraint">
                        <xsl:with-param name="constraint-element" select="mrp:Constraint"/>
                        <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) &gt; 1">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraints for this adaptation:</p>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
                <xsl:text>
</xsl:text>
            </xsl:when>
            <!-- Otherwise: nothing to do -->
        </xsl:choose>
        <!-- Output the instance requirements text for a class adaptation, if specified. -->
        <xsl:if test="count(mrp:InstanceRequirements) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:InstanceRequirements"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="topmost-allowed-heading-level" select="'h5'"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output elements table -->
        <xsl:call-template name="output-Adaptation-ElementsTable">
            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
        </xsl:call-template>
        <!-- Next subclause -->
        <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-ElementSubclauses">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number+1"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-ElementSubclauses">
        <!-- Purpose: Output an adaptation subclause in complex mode - element subclauses. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="@className"/>
        </xsl:variable>
        <!-- Output property subclauses, if any -->
        <xsl:for-each select="mrp:Property[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
            count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
            @refClassAdaptation != '' or count(mrp:Constraint) &gt; 0 or
            count(mrp:Modification) &gt; 0 or count(mrp:Initialization) &gt; 0 ]">
            <!-- The predicate on the previous line needs to be in sync with the predicate further below, and corresponding tests in the output of the element table. -->
            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="h2-number" select="$h2-number"/>
                <xsl:with-param name="h3-number" select="$h3-number"/>
                <xsl:with-param name="h4-number" select="$h4-number - 1 + position()"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:variable name="property-count">
            <xsl:value-of select="count(mrp:Property[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                @refClassAdaptation != '' or count(mrp:Constraint) &gt; 0 or
                count(mrp:Modification) &gt; 0 or count(mrp:Initialization) &gt; 0 ])"/>
            <!-- The predicate on the previous line needs to be in sync with the predicate further above, and corresponding tests in the output of the element table. -->
        </xsl:variable>
        <!-- Output method subclauses, if any -->
        <xsl:for-each select="mrp:Method[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
            count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
            count(mrp:Constraint) &gt; 0 or count(mrp:Error) &gt; 0 or count(mrp:Parameter) &gt; 0 or count(mrp:ReturnValue) &gt; 0 ]">
            <!-- The predicate on the previous line needs to be in sync with the predicate below, and corresponding tests in the output of the element table. -->
            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="h2-number" select="$h2-number"/>
                <xsl:with-param name="h3-number" select="$h3-number"/>
                <xsl:with-param name="h4-number" select="$h4-number - 1 + $property-count + position()"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:variable name="method-count">
            <xsl:value-of select="count(mrp:Method[ count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                count(mrp:Constraint) &gt; 0 or count(mrp:Error) &gt; 0 or count(mrp:Parameter) &gt; 0 or count(mrp:ReturnValue) &gt; 0 ])"/>
            <!-- The predicate on the previous line needs to be in sync with the predicate above, and corresponding tests in the output of the element table. -->
        </xsl:variable>
        <!-- Output operation subclauses, if any -->
        <xsl:for-each select="mrp:Operation">
            <xsl:variable name="operation-subclause-needed">
                <xsl:call-template name="get-operation-subclause-needed">
                    <xsl:with-param name="operation-element" select="self::*"/>
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="$operation-subclause-needed = 'true'">
                <!-- The predicate on the previous line needs to be in sync with corresponding tests in the output of the element table. -->
                <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-OperX">
                    <xsl:with-param name="h1-number" select="$h1-number"/>
                    <xsl:with-param name="h2-number" select="$h2-number"/>
                    <xsl:with-param name="h3-number" select="$h3-number"/>
                    <xsl:with-param name="h4-number" select="$h4-number - 1 + $property-count + $method-count + position()"/>
                    <!-- Note: The position() in the previous line is now incorrect, after separating the test for operation-subclause-needed from the for-each loop.
                        It does not seem to be possible to fix that (other than constructing a very complicated XPATH statement in the for-each loop).
                        Thus, the DSP8029 generated heading numbers are now finally at the end of its life and cannot currently be re-enabled.
                        The DSP8054 CSS based auto-numberinbg of course works fine. -->
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-Adaptation-ElementsTable">
        <!-- Purpose: Output the elements table of an adaptation subclause, if it has elements. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <!-- Dummy loop just to set the right context. Should do only one turn. -->
        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]">
            <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
            <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
            <xsl:variable name="class-name">
                <xsl:value-of select="@className"/>
            </xsl:variable>
            <xsl:variable name="shown-number-base-adaptations">
                <!-- number of base adaptations to show in the table -->
                <xsl:value-of select="count(mrp:BaseAdaptation)"/>
            </xsl:variable>
            <xsl:variable name="shown-number-metrics">
                <!-- number of metrics to show in the table -->
                <xsl:value-of select="count(mrp:BaseAdaptation/mrp:Metric)"/>
            </xsl:variable>
            <xsl:variable name="shown-number-alert-messages">
                <!-- number of alert messages to show in the table -->
                <xsl:value-of select="count(mrp:BaseAdaptation/mrp:AlertMessage)"/>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="$shown-number-base-adaptations + count(mrp:Property) + count(mrp:Method) + count(mrp:Operation) + $shown-number-metrics + $shown-number-alert-messages&gt; 0">
                    <p>The following table identifies the element requirements for this adaptation.</p>
                    <xsl:text>
</xsl:text>
                    <table class="Table">
                        <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-ElementRequirements')"/></xsl:attribute>
                        <caption class="Table-Caption">
                            <xsl:value-of select="$adaptation-name"/>: Element requirements</caption>
                        <thead class="Table-Head">
                            <xsl:text>
</xsl:text>
                            <tr>
                                <th class="Table-HeadCell">Element</th>
                                <xsl:if test="$output-property-datatypes = 'true'">
                                    <th class="Table-HeadCell">Datatype</th>
                                </xsl:if>
                                <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                                <th class="Table-HeadCell">Description</th>
                            </tr>
                            <xsl:text>
</xsl:text>
                        </thead>
                        <tbody class="Table-Body">
                            <xsl:if test="$shown-number-base-adaptations &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Base adaptations</td>
                                </tr>
                                <xsl:for-each select="mrp:BaseAdaptation">
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:if test="@profileRefName != ''">
                                                <xsl:value-of select="@profileRefName"/>
                                                <xsl:text>::</xsl:text>
                                            </xsl:if>
                                            <xsl:value-of select="@name"/>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <!-- empty -->
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:text>See </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                <xsl:with-param name="adaptation-name" select="@name"/>
                                                <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                            </xsl:call-template>
                                            <xsl:text>.</xsl:text>
                                            <!-- Output condition of conditional requirement level, and requirement description, if any -->
                                            <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                                <div>
                                                    <p>Condition:</p>
                                                    <xsl:call-template name="output-Condition">
                                                        <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                            <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                                <div>
                                                    <xsl:call-template name="output-XHTMLText">
                                                        <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                    </xsl:call-template>
                                                </div>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$shown-number-metrics &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Metrics</td>
                                </tr>
                                <xsl:for-each select="mrp:BaseAdaptation/mrp:Metric">
                                    <xsl:variable name="metric-local-id">
                                        <xsl:value-of select="@localId"/>
                                    </xsl:variable>
                                    <xsl:variable name="metric-reg-ref-name">
                                        <xsl:value-of select="@regRefName"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-Metric-</xsl:text><xsl:value-of select="translate($metric-local-id, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:call-template name="output-link-MetricRegistries-tableentry">
                                                <xsl:with-param name="ref-name" select="$metric-reg-ref-name"/>
                                            </xsl:call-template>
                                            <xsl:text>::</xsl:text>
                                            <xsl:value-of select="$metric-local-id"/>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <!-- empty -->
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <xsl:call-template name="output-XHTMLText">
                                                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$shown-number-alert-messages &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Alert messages</td>
                                </tr>
                                <xsl:for-each select="mrp:BaseAdaptation/mrp:AlertMessage">
                                    <xsl:variable name="message-id">
                                        <xsl:value-of select="@prefix"/>
                                        <xsl:value-of select="@sequenceNumber"/>
                                    </xsl:variable>
                                    <xsl:variable name="text-registry-ref-name">
                                        <xsl:value-of select="@regRefName"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-AlertMessage-</xsl:text><xsl:value-of select="translate($message-id, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:call-template name="output-link-MessageRegistries-tableentry">
                                                <xsl:with-param name="ref-name" select="$text-registry-ref-name"/>
                                            </xsl:call-template>
                                            <xsl:text>::</xsl:text>
                                            <xsl:value-of select="$message-id"/>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <!-- empty -->
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:if test="count(mrp:Description) &gt; 0">
                                                <xsl:call-template name="output-XHTMLText">
                                                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="count(mrp:Property) &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Properties</td>
                                </tr>
                                <xsl:for-each select="mrp:Property">
                                    <xsl:variable name="property-name">
                                        <xsl:value-of select="@name"/>
                                    </xsl:variable>
                                    <xsl:variable name="null-ok">
                                        <xsl:value-of select="@nullOk"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:value-of select="$property-name"/>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <xsl:choose>
                                                    <xsl:when test="@refClassAdaptation != ''">
                                                        <!-- The datatype is reference. Output it, using the name of the referenced class adaptation. -->
                                                        <xsl:variable name="ref-class-adaptation">
                                                            <xsl:value-of select="@refClassAdaptation"/>
                                                        </xsl:variable>
                                                        <xsl:choose>
                                                            <xsl:when test="count( /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ] ) = 0">
                                                                <xsl:call-template name="ErrorMsg">
                                                                    <xsl:with-param name="msg">Profile Error: Referenced adaptation "<xsl:value-of select="$ref-class-adaptation"/>" is not defined in this profile.</xsl:with-param>
                                                                </xsl:call-template>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:text>ref </xsl:text>
                                                                <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ]/@className"/>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <!-- The datatype is other than reference. Output the datatype from the underlying schema. -->
                                                        <xsl:call-template name="get-schema-property-type">
                                                            <xsl:with-param name="class-name" select="$class-name"/>
                                                            <xsl:with-param name="property-name" select="$property-name"/>
                                                        </xsl:call-template>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <!-- Output the KEY qualifier, if effectively true (that is, including when inherited from superclasses). -->
                                            <xsl:variable name="schema-property-is-key">
                                                <xsl:call-template name="get-schema-property-is-key">
                                                    <xsl:with-param name="class-name" select="$class-name"/>
                                                    <xsl:with-param name="property-name" select="$property-name"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <xsl:choose>
                                                <xsl:when test="$schema-property-is-key = 'true'">
                                                    <xsl:value-of select="$qualifier-key-keyword"/>
                                                    <xsl:text>, </xsl:text>
                                                </xsl:when>
                                                <xsl:when test="$schema-property-is-key = 'false'">
                                                    <xsl:text/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <!-- Pass through the error -->
                                                    <xsl:copy-of select="$schema-property-is-key"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Output the REQUIRED qualifier, if effectively true (that is, including when inherited from superclasses). -->
                                            <xsl:variable name="schema-property-is-required">
                                                <xsl:call-template name="get-schema-property-is-required">
                                                    <xsl:with-param name="class-name" select="$class-name"/>
                                                    <xsl:with-param name="property-name" select="$property-name"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <xsl:choose>
                                                <xsl:when test="$schema-property-is-required = 'true'">
                                                    <xsl:value-of select="$qualifier-required-keyword"/>
                                                    <xsl:text>, </xsl:text>
                                                </xsl:when>
                                                <xsl:when test="$schema-property-is-required = 'false'">
                                                    <xsl:text/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <!-- Pass through the error -->
                                                    <xsl:copy-of select="$schema-property-is-required"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Output the nullOk attribute, if effectively true (that is, including when inherited from superclasses). -->
                                            <xsl:choose>
                                                <xsl:when test="$null-ok = 'true'">
                                                    <xsl:text>Null OK, </xsl:text>
                                                    <xsl:if test="$schema-property-is-required = 'true'">
                                                        <!-- Specifying Null OK on a REQUIRED element is not valid. -->
                                                        <xsl:call-template name="ErrorMsg">
                                                            <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" has "nullOk" specified but has an effective value of True for the REQUIRED qualifier.</xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                    <xsl:if test="$schema-property-is-key = 'true'">
                                                        <!-- Specifying Null OK on a key property is not valid. -->
                                                        <xsl:call-template name="ErrorMsg">
                                                            <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" has "nullOk" specified but is a key property.</xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                    <xsl:if test="mrp:Requirement/@level != 'Mandatory' and mrp:Requirement/@level != 'Conditional'">
                                                        <!-- Specifying Null OK on a non-mandatory, non-conditional element is not really desired. Discourage it. -->
                                                        <xsl:call-template name="ErrorMsg">
                                                            <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" has "nullOk" specified but is not Mandatory or Conditional.</xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Output information related to an embedded instance. -->
                                            <xsl:variable name="schema-property-embeddedinstance-class">
                                                <xsl:call-template name="get-schema-property-embeddedinstance-class">
                                                    <xsl:with-param name="class-name" select="$class-name"/>
                                                    <xsl:with-param name="property-name" select="$property-name"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <xsl:choose>
                                                <xsl:when test="@embeddedClassAdaptation != ''">
                                                    <!-- An embedded instance constraint is defined for the property. -->
                                                    <xsl:choose>
                                                        <xsl:when test="$schema-property-embeddedinstance-class = ''">
                                                            <!-- The property is not defined as an embedded instance in the underlying schema. -->
                                                            <xsl:call-template name="ErrorMsg">
                                                                <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" is not defined as an embedded instance in the underlying schema but an "embeddedClassAdaptation" attribute is specified on the "Property" element.</xsl:with-param>
                                                            </xsl:call-template>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <!-- Property is defined as an embedded instance in the underlying schema,
                                                            or the value of the variable contains an error message. -->
                                                            <xsl:text>Embedded instance adaptation: </xsl:text>
                                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                                <xsl:with-param name="adaptation-name" select="@embeddedClassAdaptation"/>
                                                            </xsl:call-template>
                                                            <xsl:text>, </xsl:text>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <!-- An embedded instance constraint has not been defined for the property. -->
                                                    <xsl:choose>
                                                        <xsl:when test="$schema-property-embeddedinstance-class != ''">
                                                            <!-- The property is defined as an embedded instance in the underlying schema. -->
                                                            <xsl:call-template name="ErrorMsg">
                                                                <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" is defined as an embedded instance of class "<xsl:value-of select="$schema-property-embeddedinstance-class"/>" in the underlying schema but no "embeddedClassAdaptation" attribute is specified on the "Property" element.</xsl:with-param>
                                                            </xsl:call-template>
                                                        </xsl:when>
                                                    </xsl:choose>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Output a reference to the generated subclause, if any, or otherwise to the schema -->
                                            <xsl:choose>
                                                <xsl:when test="$schema-property-is-key = 'true' or $schema-property-is-required = 'true' or $null-ok = 'true' or @embeddedClassAdaptation != ''">
                                                    <xsl:text>see </xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>See </xsl:text>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <xsl:choose>
                                                <xsl:when test="count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                                                    count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                                                    @refClassAdaptation != '' or count(mrp:Constraint) &gt; 0 or
                                                    count(mrp:Modification) &gt; 0 or count(mrp:Initialization) &gt; 0">
                                                    <!-- The above test needs to be in sync with the corresponding predicates in the output of the element subclauses. -->
                                                    <xsl:call-template name="output-link-Property-subclause">
                                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                        <xsl:with-param name="property-name" select="$property-name"/>
                                                    </xsl:call-template>
                                                    <xsl:text>.</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>schema definition.</xsl:text>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Verify reference related stuff on the property -->
                                            <xsl:call-template name="check-property-reference-rules">
                                                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                <xsl:with-param name="class-name" select="$class-name"/>
                                                <xsl:with-param name="property-name" select="$property-name"/>
                                            </xsl:call-template>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="count(mrp:Method) &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Methods</td>
                                </tr>
                                <xsl:for-each select="mrp:Method">
                                    <xsl:variable name="method-name">
                                        <xsl:value-of select="@name"/>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:text>
</xsl:text>
                                            <a>
                                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            </a>
                                            <xsl:value-of select="$method-name"/>
                                            <xsl:text>(&#xA0;)</xsl:text>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <!-- empty -->
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:choose>
                                                <xsl:when test="count(mrp:ModelDescription) &gt; 0 or count(mrp:Description) &gt; 0 or
                                                    count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                                                    count(mrp:Constraint) &gt; 0 or count(mrp:Error) &gt; 0 or count(mrp:Parameter) &gt; 0 or count(mrp:ReturnValue) &gt; 0">
                                                    <!-- The above test needs to be in sync with the corresponding predicates in the output of the element subclauses. -->
                                                    <xsl:text>See </xsl:text>
                                                    <xsl:call-template name="output-link-Method-subclause">
                                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                        <xsl:with-param name="method-name" select="$method-name"/>
                                                    </xsl:call-template>
                                                    <xsl:text>.</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>See schema definition.</xsl:text>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="count(mrp:Operation) &gt; 0">
                                <xsl:text>
</xsl:text>
                                <tr>
                                    <!-- Separator row -->
                                    <td class="Table-BodySeparatorCell" colspan="3">Operations</td>
                                </tr>
                                <xsl:for-each select="mrp:Operation">
                                    <xsl:variable name="operation-element" select="self::*"/>
                                    <xsl:variable name="operation-name">
                                        <xsl:value-of select="@name"/>
                                    </xsl:variable>
                                    <xsl:variable name="operation-moniker">
                                        <xsl:call-template name="get-operation-moniker">
                                            <xsl:with-param name="operation-element" select="$operation-element"/>
                                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                        </xsl:call-template>
                                    </xsl:variable>
                                    <xsl:variable name="operation-profile-type">
                                        <xsl:call-template name="get-operation-profile-type">
                                            <xsl:with-param name="operation-set" select="$operation-set"/>
                                            <xsl:with-param name="operation-name" select="$operation-name"/>
                                        </xsl:call-template>
                                    </xsl:variable>
                                    <xsl:text>
</xsl:text>
                                    <tr>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Element -->
                                            <xsl:choose>
                                                <xsl:when test="$operation-profile-type = 'InvalidOperation'">
                                                    <xsl:call-template name="ErrorMsg">
                                                        <xsl:with-param name="msg">Profile Error: Operation "<xsl:value-of select="$operation-name"/>" defined in adaptation "<xsl:value-of select="$adaptation-name"/>" is not a valid operation when using operation set <xsl:value-of select="$operation-set"/>.</xsl:with-param>
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:when test="$operation-profile-type = 'Referenced'">
                                                    <!-- This is an association traversal operation. -->
                                                    <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property [ @refClassAdaptation = $adaptation-name ]) = 0">
                                                        <xsl:call-template name="ErrorMsg">
                                                            <xsl:with-param name="msg">Profile Error: Adaptation "<xsl:value-of select="$adaptation-name"/>" defining association traversal operation "<xsl:value-of select="$operation-name"/>" is not referenced from any association adaptation defined in this profile.</xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                    <xsl:choose>
                                                        <xsl:when test="count(mrp:Association) &gt; 0">
                                                            <!-- The list of association adaptations to be traversed has been specified. -->
                                                            <xsl:for-each select="mrp:Association">
                                                                <xsl:variable name="association-adaptation-name">
                                                                    <xsl:value-of select="@adaptationName"/>
                                                                </xsl:variable>
                                                                <!-- Verify that the specified association adaptation is defined and references this adaptation.
                                                                    These tests are conditional on the operation being of type 'Referenced' in order not to issue the
                                                                    error otherwise, since the general test for that has already been tested above. -->
                                                                <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ @name = $association-adaptation-name ]) = 0">
                                                                    <xsl:call-template name="ErrorMsg">
                                                                        <xsl:with-param name="msg">Profile Error: Association traversal operation "<xsl:value-of select="$operation-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>" specifies an adaptation "<xsl:value-of select="$association-adaptation-name"/>" in its "Association" child element that is not defined in this profile.</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:if>
                                                                <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ @name = $association-adaptation-name and count(mrp:Property [@refClassAdaptation = $adaptation-name]) &gt; 0 ]) = 0">
                                                                    <xsl:call-template name="ErrorMsg">
                                                                        <xsl:with-param name="msg">Profile Error: Association traversal operation "<xsl:value-of select="$operation-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>" specifies an adaptation "<xsl:value-of select="$association-adaptation-name"/>" in its "Association" child element that does not reference adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:if>
                                                                <xsl:text>
</xsl:text>
                                                                <a>
                                                                    <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                                                </a>
                                                            </xsl:for-each>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <!-- The list of association adaptations to be traversed has not been specified and is implied to be
                                                                all association adaptations defined in this profile that reference the adaptation defining this
                                                                operation requirement. -->
                                                            <xsl:variable name="specified-association-adaptation-names">
                                                                <!-- The vertical-bar-separated list of adaptation names of mrp:Association elements that are specified on operations with this name, within this adaptation. -->
                                                                <xsl:for-each select="$operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association | $operation-element/following-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association">
                                                                    <xsl:text>|</xsl:text>
                                                                    <xsl:value-of select="@adaptationName"/>
                                                                </xsl:for-each>
                                                                <xsl:text>|</xsl:text>
                                                            </xsl:variable>
                                                            <xsl:if test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ count(mrp:Property [ @refClassAdaptation = $adaptation-name ]) &gt; 0 and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]) = 0">
                                                                <xsl:call-template name="ErrorMsg">
                                                                    <xsl:with-param name="msg">Profile Error: Operation "<xsl:value-of select="$operation-name"/>" defined in adaptation "<xsl:value-of select="$adaptation-name"/>" is an association traversal operation but there are no association adaptations defined in this profile that reference this adaptation.</xsl:with-param>
                                                                </xsl:call-template>
                                                            </xsl:if>
                                                            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ count(mrp:Property [ @refClassAdaptation = $adaptation-name ]) &gt; 0 and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]">
                                                                <!-- This loop goes through all defaulted referencing association adaptations. -->
                                                                <xsl:sort select="@name"/>
                                                                <xsl:variable name="association-adaptation-name">
                                                                    <xsl:value-of select="@name"/>
                                                                </xsl:variable>
                                                                <xsl:text>
</xsl:text>
                                                                <a>
                                                                    <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                                                </a>
                                                            </xsl:for-each>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:when>
                                                <xsl:when test="$operation-profile-type = 'OrdinaryOrAssociation'">
                                                    <!-- This is not an association traversal operation. -->
                                                    <xsl:if test="count(mrp:Association) &gt; 0">
                                                        <xsl:call-template name="ErrorMsg">
                                                            <xsl:with-param name="msg">Profile Error: Operation "<xsl:value-of select="$operation-name"/>" defined in adaptation "<xsl:value-of select="$adaptation-name"/>" is not an association traversal operation but specifies an "Association" child element.</xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                    <xsl:text>
</xsl:text>
                                                    <a>
                                                        <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                                    </a>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:call-template name="ErrorMsg">
                                                        <xsl:with-param name="msg">DSP8029 Error: Operation type "<xsl:value-of select="$operation-profile-type"/>" is not supported.</xsl:with-param>
                                                    </xsl:call-template>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            <!-- Output the operation moniker -->
                                            <xsl:value-of select="$operation-moniker"/>
                                        </td>
                                        <xsl:if test="$output-property-datatypes = 'true'">
                                            <td class="Table-BodyCell">
                                                <!-- Column: Datatype -->
                                                <!-- empty -->
                                            </td>
                                        </xsl:if>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Requirement -->
                                            <xsl:call-template name="output-RequirementLevel">
                                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            </xsl:call-template>
                                        </td>
                                        <td class="Table-BodyCell">
                                            <!-- Column: Description -->
                                            <xsl:variable name="operation-subclause-needed">
                                                <xsl:call-template name="get-operation-subclause-needed">
                                                    <xsl:with-param name="operation-element" select="self::*"/>
                                                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                </xsl:call-template>
                                            </xsl:variable>
                                            <xsl:choose>
                                                <xsl:when test="$operation-subclause-needed = 'true'">
                                                    <xsl:variable name="first-association-adaptation-name">
                                                        <xsl:choose>
                                                            <xsl:when test="$operation-profile-type = 'Referenced'">
                                                                <xsl:call-template name="get-traversal-operation-first-association-adaptation-name">
                                                                    <xsl:with-param name="operation-element" select="self::*"/>
                                                                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                                </xsl:call-template>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <!-- empty string, indicating it is no association traversal operation for the following template. -->
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </xsl:variable>
                                                    <xsl:text>See </xsl:text>
                                                    <xsl:call-template name="output-link-Operation-subclause">
                                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                                        <xsl:with-param name="operation-name" select="$operation-name"/>
                                                        <xsl:with-param name="association-adaptation-name" select="$first-association-adaptation-name"/>
                                                        <!-- let the template determine the linktext: <xsl:with-param name="linktext" select="$operation-moniker"/> -->
                                                    </xsl:call-template>
                                                    <xsl:text>.</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>See </xsl:text>
                                                    <xsl:call-template name="output-link-NormativeReferencesOperationSet-entry">
                                                        <xsl:with-param name="operation-set" select="$operation-set"/>
                                                    </xsl:call-template>
                                                    <xsl:text>.</xsl:text>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                            <xsl:text>
</xsl:text>
                        </tbody>
                    </table>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="get-traversal-operation-association-count">
        <!-- Purpose: Return the (specified or defaulted) count of association adaptations to which the association traversal operation requirement applies. -->
        <!-- This template does not perform any consistency checking but assumes the definitions are valid; so it only counts. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-element"/>
        <!-- operation-element: The mrp:Operation element defining the association traversal operation requirement. It may have siblings for the same operaiton. -->
        <xsl:param name="adaptation-name"/>
        <!-- adaptation-name: The name of the adaptation (defined in the subject profile) on which the operation requirement is defined. -->
        <xsl:choose>
            <xsl:when test="count($operation-element/mrp:Association) &gt; 0">
                <!-- The set of associations has been specified. -->
                <xsl:value-of select="count($operation-element/mrp:Association)"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- No associations have been specified, the set of associations is defaulted. -->
                <xsl:variable name="operation-name" select="$operation-element/@name"/>
                <!-- The default set is the set of referencing association adaptations, minus those explicitly defined in sibling operation requirements for the same operation. -->
                <xsl:value-of select="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ mrp:Property/@refClassAdaptation = $adaptation-name ]) - count($operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ]/mrp:Association) - count($operation-element/following-sibling::mrp:Operation [ @name = $operation-name ]/mrp:Association)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-operation-subclause-needed">
        <!-- Purpose: Return a Boolean indicating whether a subclause needs to be generated for an operation requirement. -->
        <!-- This template does not perform any consistency checking but assumes the definitions are valid. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-element"/>
        <!-- operation-element: The mrp:Operation element defining the operation requirement.
            In case of association traversal operations, it may have sibling elements for the same operation name. -->
        <xsl:param name="adaptation-name"/>
        <!-- adaptation-name: The name of the adaptation (defined in the subject profile) on which the operation requirement is defined. -->
        <xsl:variable name="operation-profile-type">
            <xsl:call-template name="get-operation-profile-type">
                <xsl:with-param name="operation-set" select="$operation-set"/>
                <xsl:with-param name="operation-name" select="$operation-element/@name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="traversal-operation-association-count">
            <xsl:call-template name="get-traversal-operation-association-count">
                <xsl:with-param name="operation-element" select="self::*"/>
                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$operation-element/mrp:ModelDescription != '' or
                    $operation-element/mrp:Description != '' or
                    count($operation-element/mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or
                    count($operation-element/mrp:Constraint) &gt; 0 or
                    count($operation-element/mrp:Error) &gt; 0 or
                    ($operation-profile-type = 'Referenced' and $traversal-operation-association-count &gt; 2)">
                <!-- The test in the previous line generates subclauses only for more than two associations, because for
                        one and two, the operation moniker lists the associations already. Of course, one could generate subclauses
                        also for just two or even for just one. -->
                <xsl:text>true</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>false</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-operation-moniker">
        <!-- Purpose: Return text that identifies the operation in links or subclause headings (local within the scope of its adaptation). -->
        <!-- This template does not perform any consistency checking but assumes the definitions are valid. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-element"/>
        <!-- operation-element: The mrp:Operation element defining the operation requirement.
            In case of association traversal operations, it may have sibling elements for the same operation name. -->
        <xsl:param name="adaptation-name"/>
        <!-- adaptation-name: The name of the adaptation (defined in the subject profile) on which the operation requirement is defined. -->
        <xsl:param name="short" select="false"/>
        <!-- short: Boolean controlling wether the short form (without association name) is produced. -->
        <xsl:variable name="operation-name" select="$operation-element/@name"/>
        <xsl:variable name="operation-profile-type">
            <xsl:call-template name="get-operation-profile-type">
                <xsl:with-param name="operation-set" select="$operation-set"/>
                <xsl:with-param name="operation-name" select="$operation-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$operation-name"/>
        <xsl:text>(&#xA0;)</xsl:text>
        <xsl:if test="$operation-profile-type = 'Referenced' and not($short = 'true')">
            <xsl:text> for </xsl:text>
            <xsl:choose>
                <xsl:when test="count($operation-element/mrp:Association) &gt; 0">
                    <!-- The complete list of association adaptations to be traversed has been specified. -->
                    <xsl:for-each select="$operation-element/mrp:Association">
                        <xsl:sort select="@adaptationName"/>
                        <xsl:if test="position() = 1">
                            <xsl:value-of select="@adaptationName"/>
                        </xsl:if>
                        <xsl:if test="position() = 2">
                            <xsl:text> and </xsl:text>
                            <xsl:choose>
                                <xsl:when test="position() = last()">
                                    <xsl:value-of select="@adaptationName"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>others</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <!-- The list of association adaptations to be traversed has not been specified and is defaulted to the
                        set of all association adaptations defined in this profile that reference the adaptation defining this
                        operation requirement, minus the association adaptations defined in sibling operations with the same name. -->
                    <xsl:variable name="specified-association-adaptation-names">
                        <!-- The vertical-bar-separated list of adaptation names of mrp:Association elements that are specified on operations with this name, within this adaptation. -->
                        <xsl:for-each select="$operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association | $operation-element/following-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association">
                            <xsl:text>|</xsl:text>
                            <xsl:value-of select="@adaptationName"/>
                        </xsl:for-each>
                        <xsl:text>|</xsl:text>
                    </xsl:variable>
                    <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ mrp:Property/@refClassAdaptation = $adaptation-name and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]">
                        <!-- This loop goes through all defaulted referencing association adaptations. -->
                        <xsl:sort select="@name"/>
                        <xsl:if test="position() = 1">
                            <xsl:value-of select="@name"/>
                        </xsl:if>
                        <xsl:if test="position() = 2">
                            <xsl:text> and </xsl:text>
                            <xsl:choose>
                                <xsl:when test="position() = last()">
                                    <xsl:value-of select="@name"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>others</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="get-traversal-operation-first-association-adaptation-name">
        <!-- Purpose: Return the name of the first association adaptation to be traversed by a traversal operation. -->
        <!-- This template does not perform any consistency checking but assumes the definitions are valid. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-element"/>
        <!-- operation-element: The mrp:Operation element defining the operation requirement.
            Must be an association traversal operation; and it may have sibling elements for the same operation name. -->
        <xsl:param name="adaptation-name"/>
        <!-- adaptation-name: The name of the adaptation (defined in the subject profile) on which the operation requirement is defined. -->
        <xsl:variable name="operation-name" select="$operation-element/@name"/>
        <xsl:variable name="operation-profile-type">
            <xsl:call-template name="get-operation-profile-type">
                <xsl:with-param name="operation-set" select="$operation-set"/>
                <xsl:with-param name="operation-name" select="$operation-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="count($operation-element/mrp:Association) &gt; 0">
                <!-- The complete list of association adaptations to be traversed has been specified. -->
                <xsl:for-each select="$operation-element/mrp:Association">
                    <xsl:sort select="@adaptationName"/>
                    <xsl:if test="position() = 1">
                        <xsl:value-of select="@adaptationName"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <!-- The list of association adaptations to be traversed has not been specified and is defaulted to the
                        set of all association adaptations defined in this profile that reference the adaptation defining this
                        operation requirement, minus the association adaptations defined in sibling operations with the same name. -->
                <xsl:variable name="specified-association-adaptation-names">
                    <!-- The vertical-bar-separated list of adaptation names of mrp:Association elements that are specified on operations with this name, within this adaptation. -->
                    <xsl:for-each select="$operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association | $operation-element/following-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association">
                        <xsl:text>|</xsl:text>
                        <xsl:value-of select="@adaptationName"/>
                    </xsl:for-each>
                    <xsl:text>|</xsl:text>
                </xsl:variable>
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ mrp:Property/@refClassAdaptation = $adaptation-name and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]">
                    <!-- This loop goes through all defaulted referencing association adaptations. -->
                    <xsl:sort select="@name"/>
                    <xsl:if test="position() = 1">
                        <xsl:value-of select="@name"/>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX">
        <!-- Purpose: Output a single property subclause for an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../@className"/>
        </xsl:variable>
        <xsl:variable name="property-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="property-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-P-</xsl:text>
            <xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Property: </xsl:text>
            <xsl:value-of select="$property-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H4">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$property-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <xsl:call-template name="output-link-Property-tableentry">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="property-name" select="$property-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Element requirements table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <!-- Output the presentation requirement level (that is, for the "instantiated instance") -->
        <div>
            <xsl:call-template name="output-RequirementText">
                <xsl:with-param name="text-begin" select="'The presentation requirement level for this property is '"/>
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <!-- Output the property model description, if specified. -->
        <xsl:if test="count(mrp:ModelDescription) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:ModelDescription"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output the property description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Verify reference related stuff on the property -->
        <xsl:call-template name="check-property-reference-rules">
            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
            <xsl:with-param name="class-name" select="$class-name"/>
            <xsl:with-param name="property-name" select="$property-name"/>
        </xsl:call-template>
        <!-- Output property constraints, if any -->
        <xsl:choose>
            <xsl:when test="@refClassAdaptation != ''">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraints for this reference property:</p>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:if test="@refClassAdaptation != ''">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:text>Referenced instances shall be of class adaptation </xsl:text>
                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                <xsl:with-param name="adaptation-name" select="@refClassAdaptation"/>
                            </xsl:call-template>
                            <xsl:text>.</xsl:text>
                        </li>
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-effective-ref-multiplicity-constraint">
                                <xsl:with-param name="adaptation-name" select="../@name"/>
                                <xsl:with-param name="class-name" select="$class-name"/>
                                <xsl:with-param name="reference-name" select="$property-name"/>
                                <xsl:with-param name="profile-ref-min" select="@refMin"/>
                                <xsl:with-param name="profile-ref-max" select="@refMax"/>
                            </xsl:call-template>
                        </li>
                    </xsl:if>
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
                <xsl:text>
</xsl:text>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) = 1">
                <p>The implementation shall satisfy the following constraint for this property:</p>
                <div class="Normal-Indent1">
                    <xsl:call-template name="output-Constraint">
                        <xsl:with-param name="constraint-element" select="mrp:Constraint"/>
                        <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) &gt; 1">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraints for this property:</p>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
                <xsl:text>
</xsl:text>
            </xsl:when>
            <!-- Otherwise: nothing to do -->
        </xsl:choose>
        <!-- Output the property initialization requirements, if specified -->
        <xsl:if test="count(mrp:Initialization) &gt; 0">
            <div>
                <xsl:call-template name="output-RequirementText">
                    <xsl:with-param name="text-begin" select="'The initialization requirement level for this property is '"/>
                    <xsl:with-param name="requirement-element" select="mrp:Initialization/mrp:Requirement"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
            <xsl:if test="count(mrp:Initialization/mrp:Description) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="mrp:Initialization/mrp:Description"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(mrp:Initialization/mrp:Value) &gt; 0">
                <div>
                    <xsl:call-template name="output-PropertyInitializationValueTable">
                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                        <xsl:with-param name="property-name" select="$property-name"/>
                        <xsl:with-param name="initialization-element" select="mrp:Initialization"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
                <!-- Output the value requirement subclauses that need to be generated. -->
                <xsl:for-each select="mrp:Initialization/mrp:Value">
                    <xsl:variable name="value-requirement-description-text">
                        <xsl:call-template name="get-ValueRequirementDescriptionText">
                            <xsl:with-param name="value-requirement-element" select="self::node()"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX-H5-InitValReqX">
                                <xsl:with-param name="h1-number" select="$h1-number"/>
                                <xsl:with-param name="h2-number" select="$h2-number"/>
                                <xsl:with-param name="h3-number" select="$h3-number"/>
                                <xsl:with-param name="h4-number" select="$h4-number"/>
                                <xsl:with-param name="h5-number" select="position()"/>
                                <!-- The position is incorrect, but that does not matter anymore since we are using CSS based numbering. -->
                            </xsl:call-template>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:if>
        </xsl:if>
        <!-- Output the property modification requirements, if specified -->
        <xsl:if test="count(mrp:Modification) &gt; 0">
            <div>
                <xsl:call-template name="output-RequirementText">
                    <xsl:with-param name="text-begin" select="'The modification requirement level for this property is '"/>
                    <xsl:with-param name="requirement-element" select="mrp:Modification/mrp:Requirement"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
            <xsl:if test="count(mrp:Modification/mrp:Description) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="mrp:Modification/mrp:Description"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:if>
            <xsl:if test="count(mrp:Modification/mrp:Value) &gt; 0">
                <div>
                    <xsl:call-template name="output-PropertyModificationValueTable">
                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                        <xsl:with-param name="property-name" select="$property-name"/>
                        <xsl:with-param name="modification-element" select="mrp:Modification"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
                <!-- Output the value requirement subclauses that need to be generated. -->
                <xsl:for-each select="mrp:Modification/mrp:Value">
                    <xsl:variable name="value-requirement-description-text">
                        <xsl:call-template name="get-ValueRequirementDescriptionText">
                            <xsl:with-param name="value-requirement-element" select="self::node()"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX-H5-ModValReqX">
                                <xsl:with-param name="h1-number" select="$h1-number"/>
                                <xsl:with-param name="h2-number" select="$h2-number"/>
                                <xsl:with-param name="h3-number" select="$h3-number"/>
                                <xsl:with-param name="h4-number" select="$h4-number"/>
                                <xsl:with-param name="h5-number" select="position()"/>
                                <!-- The position is incorrect, but that does not matter anymore since we are using CSS based numbering. -->
                            </xsl:call-template>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX-H5-InitValReqX">
        <!-- Purpose: Output a subclause for an initialization value requirement for a property of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property/mrp:Initialization/mrp:Value -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../../../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../../../@className"/>
        </xsl:variable>
        <xsl:variable name="property-name">
            <xsl:value-of select="../../@name"/>
        </xsl:variable>
        <xsl:variable name="value">
            <xsl:value-of select="mrp:Value"/>
        </xsl:variable>
        <xsl:variable name="value-req-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-P-</xsl:text>
            <xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-IV-</xsl:text>
            <xsl:value-of select="translate($value, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Initialization value: </xsl:text>
            <xsl:value-of select="$value"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H5">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="h5-number" select="$h5-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$value-req-heading-id"/>
        </xsl:call-template>
        <xsl:call-template name="get-ValueRequirementDescriptionText">
            <xsl:with-param name="value-requirement-element" select="self::node()"/>
            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-PropX-H5-ModValReqX">
        <!-- Purpose: Output a subclause for a modification value requirement for a property of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property/mrp:Modification/mrp:Value -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../../../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../../../@className"/>
        </xsl:variable>
        <xsl:variable name="property-name">
            <xsl:value-of select="../../@name"/>
        </xsl:variable>
        <xsl:variable name="value">
            <xsl:value-of select="mrp:Value"/>
        </xsl:variable>
        <xsl:variable name="value-req-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-P-</xsl:text>
            <xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-MV-</xsl:text>
            <xsl:value-of select="translate($value, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Modification value: </xsl:text>
            <xsl:value-of select="$value"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H5">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="h5-number" select="$h5-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$value-req-heading-id"/>
        </xsl:call-template>
        <xsl:call-template name="get-ValueRequirementDescriptionText">
            <xsl:with-param name="value-requirement-element" select="self::node()"/>
            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX">
        <!-- Purpose: Output a single method subclause for an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../@className"/>
        </xsl:variable>
        <xsl:variable name="method-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="method-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-M-</xsl:text>
            <xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Method: </xsl:text>
            <xsl:value-of select="$method-name"/>
            <xsl:text>(&#xA0;)</xsl:text>
        </xsl:variable>
        <xsl:call-template name="output-heading-H4">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$method-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <xsl:call-template name="output-link-Method-tableentry">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="method-name" select="$method-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Element requirements table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <!-- Output requirement level -->
        <div>
            <xsl:call-template name="output-RequirementText">
                <xsl:with-param name="text-begin" select="'The requirement level for this method is '"/>
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <!-- Output the method model description, if specified. -->
        <xsl:if test="count(mrp:ModelDescription) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:ModelDescription"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output the method description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output method constraints, if any -->
        <xsl:choose>
            <xsl:when test="count(mrp:Constraint) = 1">
                <p>The implementation shall satisfy the following constraint for this method:</p>
                <div class="Normal-Indent1">
                    <xsl:call-template name="output-Constraint">
                        <xsl:with-param name="constraint-element" select="mrp:Constraint"/>
                        <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) &gt; 1">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraints for this method:</p>
                <ul class="List-Bullet">
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <!-- Otherwise: nothing to do -->
        </xsl:choose>
        <!-- Output parameters table -->
        <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-ParmsTable"/>
        <!-- Output standard messages table for this method. -->
        <xsl:call-template name="output-ErrorTable"/>
        <!-- Output subclauses for the parameters, if needed. -->
        <xsl:for-each select="mrp:Parameter[ mrp:Description != '' or @refClassAdaptation != '' or count(mrp:Value) &gt; 0 ]">
            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-ParmX">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="h2-number" select="$h2-number"/>
                <xsl:with-param name="h3-number" select="$h3-number"/>
                <xsl:with-param name="h4-number" select="$h4-number"/>
                <xsl:with-param name="h5-number" select="position()"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:variable name="parameter-count">
            <xsl:value-of select="count(mrp:Parameter[ mrp:Description != '' or @refClassAdaptation != ''  or count(mrp:Value) &gt; 0 ])"/>
        </xsl:variable>
        <!-- Output subclause for the return value, if needed. -->
        <xsl:for-each select="mrp:ReturnValue[ mrp:Description != '' ]">
            <!-- The schema ensures that there is only one return value. -->
            <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-Return">
                <xsl:with-param name="h1-number" select="$h1-number"/>
                <xsl:with-param name="h2-number" select="$h2-number"/>
                <xsl:with-param name="h3-number" select="$h3-number"/>
                <xsl:with-param name="h4-number" select="$h4-number"/>
                <xsl:with-param name="h5-number" select="$parameter-count + position()"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-ParmsTable">
        <!-- Purpose: Output the parameters table in the method subclause of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../@className"/>
        </xsl:variable>
        <xsl:variable name="method-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <p>The following table identifies the parameter and return value requirements of the method.</p>
        <xsl:text>
</xsl:text>
        <table class="Table">
            <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-M-',$method-name,'-ParameterRequirements')"/></xsl:attribute>
            <caption class="Table-Caption">
                <xsl:value-of select="$method-name"/>(&#xA0;): Parameter requirements</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Parameter</th>
                    <xsl:if test="$output-parameter-datatypes = 'true'">
                        <th class="Table-HeadCell">Datatype</th>
                    </xsl:if>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="mrp:Parameter">
                    <xsl:variable name="parameter-name">
                        <xsl:value-of select="@name"/>
                    </xsl:variable>
                    <xsl:variable name="null-ok">
                        <xsl:value-of select="@nullOk"/>
                    </xsl:variable>
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <!-- Column: Parameter -->
                            <xsl:text>
</xsl:text>
                            <a>
                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            </a>
                            <xsl:value-of select="@name"/>
                        </td>
                        <xsl:if test="$output-parameter-datatypes = 'true'">
                            <td class="Table-BodyCell">
                                <!-- Column: Datatype -->
                                <xsl:choose>
                                    <xsl:when test="@refClassAdaptation != ''">
                                        <!-- The datatype is reference. Output it, using the name of the referenced class adaptation. -->
                                        <xsl:variable name="ref-class-adaptation">
                                            <xsl:value-of select="@refClassAdaptation"/>
                                        </xsl:variable>
                                        <xsl:choose>
                                            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ]) != 1">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$ref-class-adaptation"/>" referenced by the reference-typed parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" is not defined or is defined more than once in this profile.</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>ref </xsl:text>
                                                <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ]/@className"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <!-- The datatype is other than reference. Output the datatype from the underlying schema. -->
                                        <xsl:call-template name="get-schema-parameter-type">
                                            <xsl:with-param name="class-name" select="$class-name"/>
                                            <xsl:with-param name="method-name" select="$method-name"/>
                                            <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </xsl:if>
                        <td class="Table-BodyCell">
                            <!-- Column: Description -->
                            <!-- Output the IN qualifier, if effectively true (that is, including when inherited from superclasses). -->
                            <xsl:variable name="schema-parameter-is-in">
                                <xsl:call-template name="get-schema-parameter-is-in">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                    <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="$schema-parameter-is-in = 'true'">
                                    <xsl:value-of select="$qualifier-in-keyword"/>
                                    <xsl:text>, </xsl:text>
                                </xsl:when>
                                <xsl:when test="$schema-parameter-is-in = 'false'">
                                    <xsl:text/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- Pass through the error -->
                                    <xsl:copy-of select="$schema-parameter-is-in"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output the OUT qualifier, if effectively true (that is, including when inherited from superclasses). -->
                            <xsl:variable name="schema-parameter-is-out">
                                <xsl:call-template name="get-schema-parameter-is-out">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                    <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="$schema-parameter-is-out = 'true'">
                                    <xsl:value-of select="$qualifier-out-keyword"/>
                                    <xsl:text>, </xsl:text>
                                </xsl:when>
                                <xsl:when test="$schema-parameter-is-out = 'false'">
                                    <xsl:text/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- Pass through the error -->
                                    <xsl:copy-of select="$schema-parameter-is-out"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output the REQUIRED qualifier, if effectively true (that is, including when inherited from superclasses). -->
                            <xsl:variable name="schema-parameter-is-required">
                                <xsl:call-template name="get-schema-parameter-is-required">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                    <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="$schema-parameter-is-required = 'true'">
                                    <xsl:value-of select="$qualifier-required-keyword"/>
                                    <xsl:text>, </xsl:text>
                                </xsl:when>
                                <xsl:when test="$schema-parameter-is-required = 'false'">
                                    <xsl:text/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- Pass through the error -->
                                    <xsl:copy-of select="$schema-parameter-is-required"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output the nullOk attribute, if effectively true (that is, including when inherited from superclasses). -->
                            <!-- TBD: Decide whether nullOk on parameters is allowed. -->
                            <xsl:choose>
                                <xsl:when test="$null-ok = 'true'">
                                    <xsl:text>Null OK, </xsl:text>
                                    <xsl:if test="$schema-parameter-is-required = 'true'">
                                        <!-- Specifying Null OK on a REQUIRED element is not valid. -->
                                        <xsl:call-template name="ErrorMsg">
                                            <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" in method "<xsl:value-of select="$method-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" has "nullOk" specified but has an effective value of True for the REQUIRED qualifier.</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output information related to an embedded instance. -->
                            <xsl:variable name="schema-parameter-embeddedinstance-class">
                                <xsl:call-template name="get-schema-parameter-embeddedinstance-class">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                    <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="@embeddedClassAdaptation != ''">
                                    <!-- An embedded instance constraint is defined for the parameter. -->
                                    <xsl:choose>
                                        <xsl:when test="$schema-parameter-embeddedinstance-class = ''">
                                            <!-- The parameter is not defined as an embedded instance in the underlying schema. -->
                                            <xsl:call-template name="ErrorMsg">
                                                <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" is not defined as an embedded instance in the underlying schema but an "embeddedClassAdaptation" attribute is specified on the "Parameter" element.</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <!-- Parameter is defined as an embedded instance in the underlying schema,
                                                            or the value of the variable contains an error message. -->
                                            <xsl:text>Embedded instance adaptation: </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                <xsl:with-param name="adaptation-name" select="@embeddedClassAdaptation"/>
                                            </xsl:call-template>
                                            <xsl:text>, </xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- An embedded instance constraint has not been defined for the parameter. -->
                                    <xsl:choose>
                                        <xsl:when test="$schema-parameter-embeddedinstance-class != ''">
                                            <!-- The parameter is defined as an embedded instance in the underlying schema. -->
                                            <xsl:call-template name="ErrorMsg">
                                                <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" is defined as an embedded instance of class "<xsl:value-of select="$schema-parameter-embeddedinstance-class"/>" in the underlying schema but no "embeddedClassAdaptation" attribute is specified on the "Parameter" element.</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output a reference to the description or schema -->
                            <xsl:choose>
                                <xsl:when test="$schema-parameter-is-in = 'true' or $schema-parameter-is-out = 'true' or
                                        $schema-parameter-is-required = 'true' or $null-ok = 'true' or @embeddedClassAdaptation != ''">
                                    <xsl:text>see </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>See </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:choose>
                                <xsl:when test="mrp:Description != '' or count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0 or @refClassAdaptation != '' or count(mrp:Value) &gt; 0">
                                    <xsl:call-template name="output-link-Parameter-subclause">
                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                        <xsl:with-param name="method-name" select="$method-name"/>
                                        <xsl:with-param name="parameter-name" select="$parameter-name"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>schema definition.</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:for-each select="mrp:ReturnValue">
                    <!-- There should be only one -->
                    <xsl:variable name="null-ok">
                        <xsl:value-of select="@nullOk"/>
                    </xsl:variable>
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <!-- Column: Parameter -->
                            <xsl:text>
</xsl:text>
                            <a>
                                <xsl:attribute name="name"><xsl:text>T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-RV</xsl:text></xsl:attribute>
                            </a>
                            <xsl:value-of select="$return-value-parameter-name"/>
                        </td>
                        <xsl:if test="$output-parameter-datatypes = 'true'">
                            <td class="Table-BodyCell">
                                <!-- Column: Datatype -->
                                <xsl:choose>
                                    <xsl:when test="@refClassAdaptation != ''">
                                        <!-- The datatype is reference. Output it, using the name of the referenced class adaptation. -->
                                        <xsl:variable name="ref-class-adaptation">
                                            <xsl:value-of select="@refClassAdaptation"/>
                                        </xsl:variable>
                                        <xsl:choose>
                                            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ]) != 1">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$ref-class-adaptation"/>" referenced by the reference-typed return value of method "<xsl:value-of select="$method-name"/>" is not defined or is defined more than once in this profile.</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>ref </xsl:text>
                                                <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $ref-class-adaptation ]/@className"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <!-- The datatype is other than reference. Output the datatype from the underlying schema. -->
                                        <xsl:call-template name="get-schema-returnvalue-type">
                                            <xsl:with-param name="class-name" select="$class-name"/>
                                            <xsl:with-param name="method-name" select="$method-name"/>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </xsl:if>
                        <td class="Table-BodyCell">
                            <!-- Column: Description -->
                            <!-- Output the REQUIRED qualifier, if effectively true (that is, including when inherited from superclasses). -->
                            <xsl:variable name="schema-returnvalue-is-required">
                                <xsl:call-template name="get-schema-returnvalue-is-required">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="$schema-returnvalue-is-required = 'true'">
                                    <xsl:value-of select="$qualifier-required-keyword"/>
                                    <xsl:text>, </xsl:text>
                                </xsl:when>
                                <xsl:when test="$schema-returnvalue-is-required = 'false'">
                                    <xsl:text/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- Pass through the error -->
                                    <xsl:copy-of select="$schema-returnvalue-is-required"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output the nullOk attribute, if effectively true (that is, including when inherited from superclasses). -->
                            <!-- TBD: Decide whether nullOk on return values is allowed. -->
                            <xsl:choose>
                                <xsl:when test="$null-ok = 'true'">
                                    <xsl:text>Null OK, </xsl:text>
                                    <xsl:if test="$schema-returnvalue-is-required = 'true'">
                                        <!-- Specifying Null OK on a REQUIRED element is not valid. -->
                                        <xsl:call-template name="ErrorMsg">
                                            <xsl:with-param name="msg">Profile Error: Return value of method "<xsl:value-of select="$method-name"/>" in adaptation "<xsl:value-of select="$adaptation-name"/>" has "nullOk" specified but has an effective value of True for the REQUIRED qualifier.</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output information related to an embedded instance. -->
                            <xsl:variable name="schema-returnvalue-embeddedinstance-class">
                                <xsl:call-template name="get-schema-returnvalue-embeddedinstance-class">
                                    <xsl:with-param name="class-name" select="$class-name"/>
                                    <xsl:with-param name="method-name" select="$method-name"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="@embeddedClassAdaptation != ''">
                                    <!-- An embedded instance constraint is defined for the return value. -->
                                    <xsl:choose>
                                        <xsl:when test="$schema-returnvalue-embeddedinstance-class = ''">
                                            <!-- The return value is not defined as an embedded instance in the underlying schema. -->
                                            <xsl:call-template name="ErrorMsg">
                                                <xsl:with-param name="msg">Profile Error: The return value of method "<xsl:value-of select="$method-name"/>" is not defined as an embedded instance in the underlying schema but an "embeddedClassAdaptation" attribute is specified on the "ReturnValue" element.</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <!-- Method is defined as an embedded instance in the underlying schema,
                                                            or the value of the variable contains an error message. -->
                                            <xsl:text>Embedded instance adaptation: </xsl:text>
                                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                                <xsl:with-param name="adaptation-name" select="@embeddedClassAdaptation"/>
                                            </xsl:call-template>
                                            <xsl:text>, </xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- An embedded instance constraint has not been defined for the return value. -->
                                    <xsl:choose>
                                        <xsl:when test="$schema-returnvalue-embeddedinstance-class != ''">
                                            <!-- The method is defined as an embedded instance in the underlying schema. -->
                                            <xsl:call-template name="ErrorMsg">
                                                <xsl:with-param name="msg">Profile Error: The return value of method "<xsl:value-of select="$method-name"/>" is defined as an embedded instance of class "<xsl:value-of select="$schema-returnvalue-embeddedinstance-class"/>" in the underlying schema but no "embeddedClassAdaptation" attribute is specified on the "ReturnValue" element.</xsl:with-param>
                                            </xsl:call-template>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Output a reference to the description or schema -->
                            <xsl:choose>
                                <xsl:when test="$schema-returnvalue-is-required = 'true' or $null-ok = 'true' or @embeddedClassAdaptation != ''">
                                    <xsl:text>see </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>See </xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:choose>
                                <xsl:when test="mrp:Description != '' or count(mrp:Requirement[ @level = 'Conditional' or @level = 'ConditionalExclusive']) &gt; 0">
                                    <xsl:call-template name="output-link-ReturnValue-subclause">
                                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                        <xsl:with-param name="method-name" select="$method-name"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>schema definition.</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-ParmX">
        <!-- Purpose: Output a single parameter subclause for a method of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method/mrp:Parameter -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../../@className"/>
        </xsl:variable>
        <xsl:variable name="method-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="parameter-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="parameter-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-M-</xsl:text>
            <xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-P-</xsl:text>
            <xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Parameter: </xsl:text>
            <xsl:value-of select="$parameter-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H5">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="h5-number" select="$h5-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$parameter-heading-id"/>
        </xsl:call-template>
        <!-- Output the parameter description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Verify reference related stuff on the parameter -->
        <xsl:call-template name="check-parameter-reference-rules">
            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
            <xsl:with-param name="class-name" select="$class-name"/>
            <xsl:with-param name="method-name" select="$method-name"/>
            <xsl:with-param name="parameter-name" select="$parameter-name"/>
        </xsl:call-template>
        <!-- Output the parameter constraints, if any -->
        <xsl:if test="@refClassAdaptation != ''">
            <p>The implementation shall satisfy the following constraint for this reference parameter:</p>
            <div class="Normal-Indent1">
                <p>
                    <xsl:text>Referenced instances shall be of class adaptation </xsl:text>
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="@refClassAdaptation"/>
                    </xsl:call-template>
                    <xsl:text>.</xsl:text>
                </p>
            </div>
        </xsl:if>
        <!-- Output the input parameter value requirements, if specified -->
        <xsl:if test="count(mrp:Value) &gt; 0">
            <div>
                <xsl:call-template name="output-ParameterInputValueTable">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="method-name" select="$method-name"/>
                    <xsl:with-param name="parameter-name" select="$parameter-name"/>
                    <xsl:with-param name="parameter-element" select="self::node()"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
            <!-- Output the value requirement subclauses that need to be generated. -->
            <xsl:for-each select="mrp:Value">
                <xsl:variable name="value-requirement-description-text">
                    <xsl:call-template name="get-ValueRequirementDescriptionText">
                        <xsl:with-param name="value-requirement-element" select="self::node()"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                        <xsl:call-template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-ParmX-H6-InValReqX">
                            <xsl:with-param name="h1-number" select="$h1-number"/>
                            <xsl:with-param name="h2-number" select="$h2-number"/>
                            <xsl:with-param name="h3-number" select="$h3-number"/>
                            <xsl:with-param name="h4-number" select="$h4-number"/>
                            <xsl:with-param name="h5-number" select="$h5-number"/>
                            <xsl:with-param name="h6-number" select="position()"/>
                            <!-- The position is incorrect, but that does not matter anymore since we are using CSS based numbering. -->
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-Return">
        <!-- Purpose: Output a return value subclause for a method of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method/mrp:ReturnValue -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../../@className"/>
        </xsl:variable>
        <xsl:variable name="method-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="returnvalue-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-M-</xsl:text>
            <xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-RV</xsl:text>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Return value</xsl:text>
        </xsl:variable>
        <xsl:call-template name="output-heading-H5">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="h5-number" select="$h5-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$returnvalue-heading-id"/>
        </xsl:call-template>
        <!-- Output the return value description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-MethX-H5-ParmX-H6-InValReqX">
        <!-- Purpose: Output a single input value requirement for an input parameter of a method of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method/mrp:Parameter/mrp:Value -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:param name="h6-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../../../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../../../@className"/>
        </xsl:variable>
        <xsl:variable name="method-name">
            <xsl:value-of select="../../@name"/>
        </xsl:variable>
        <xsl:variable name="parameter-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="value">
            <xsl:value-of select="mrp:Value"/>
        </xsl:variable>
        <xsl:variable name="value-req-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-M-</xsl:text>
            <xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-P-</xsl:text>
            <xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-IV-</xsl:text>
            <xsl:value-of select="translate($value, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Input value: </xsl:text>
            <xsl:value-of select="$value"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H6">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="h5-number" select="$h5-number"/>
            <xsl:with-param name="h6-number" select="$h6-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$value-req-heading-id"/>
        </xsl:call-template>
        <xsl:call-template name="get-ValueRequirementDescriptionText">
            <xsl:with-param name="value-requirement-element" select="self::node()"/>
            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-ErrorTable">
        <!-- Purpose: Output the error reporting requirement table (if any) for a method or operation of an adaptation. -->
        <!-- Invocation context: The element under which a sequence of mrp:Message elements exists (that is, mrp:Operation or mrp:Method). -->
        <xsl:if test="count(mrp:Error) &gt; 0">
            <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
            <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
            <xsl:variable name="adaptation-name" select="ancestor::mrp:ClassAdaptation/@name"/>
            <p>
                <xsl:choose>
                    <xsl:when test="local-name(self::*) = 'Operation'">
                        <xsl:text>The following table specifies the error reporting requirements of the </xsl:text>
                        <xsl:value-of select="@name"/>
                        <xsl:text>(&#xA0;) operation. These requirements apply in addition to those defined in </xsl:text>
                        <xsl:call-template name="output-link-NormativeReferencesOperationSet-entry">
                            <xsl:with-param name="operation-set" select="$operation-set"/>
                        </xsl:call-template>
                        <xsl:text> for this operation.</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Method -->
                        <xsl:text>The following table specifies the error reporting requirements of the </xsl:text>
                        <xsl:value-of select="@name"/>
                        <xsl:text>(&#xA0;) method. These requirements apply in addition to those defined in </xsl:text>
                        <xsl:call-template name="output-link-NormativeReferencesOperationSet-entry">
                            <xsl:with-param name="operation-set" select="$operation-set"/>
                        </xsl:call-template>
                        <xsl:text> for the operation that invokes this method.</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </p>
            <xsl:text>
</xsl:text>
            <table class="Table">
                <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-MO-',@name,'-ErrorReportingRequirements')"/></xsl:attribute>
                <caption class="Table-Caption">
                    <xsl:value-of select="@name"/>
                    <xsl:text>(&#xA0;): Error reporting requirements</xsl:text>
                </caption>
                <thead class="Table-Head">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <th class="Table-HeadCell">Reporting mechanism</th>
                        <th class="Table-HeadCell">Requirement level</th>
                        <th class="Table-HeadCell">Description</th>
                    </tr>
                    <xsl:text>
</xsl:text>
                </thead>
                <tbody class="Table-Body">
                    <xsl:for-each select="mrp:Error">
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td class="Table-BodyCell">
                                <!-- Column: Reporting mechanism -->
                                <xsl:choose>
                                    <xsl:when test="count(mrp:StatusCode) &gt; 0">
                                        <!-- There is only one if the MRP profile conforms to the XSD. -->
                                        <xsl:value-of select="mrp:StatusCode/@name"/>
                                    </xsl:when>
                                    <xsl:when test="count(mrp:Message) &gt; 0">
                                        <xsl:for-each select="mrp:Message">
                                            <xsl:call-template name="output-link-MessageRegistries-tableentry">
                                                <xsl:with-param name="ref-name" select="@regRefName"/>
                                            </xsl:call-template>
                                            <xsl:text>::</xsl:text>
                                            <xsl:value-of select="@prefix"/>
                                            <xsl:value-of select="@sequenceNumber"/>
                                            <xsl:if test="position() &lt; last()">
                                                <xsl:text>,</xsl:text>
                                                <br/>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <!-- Cannot happen if the MRP profile conforms to the XSD. -->
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Requirement level -->
                                <!-- There is exactly one if the MRP profile conforms to the XSD. -->
                                <xsl:call-template name="output-RequirementLevel">
                                    <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                </xsl:call-template>
                            </td>
                            <td class="Table-BodyCell">
                                <!-- Column: Description -->
                                <xsl:if test="count(mrp:Description) &gt; 0">
                                    <div>
                                        <xsl:call-template name="output-XHTMLText">
                                            <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                        </xsl:call-template>
                                    </div>
                                </xsl:if>
                                <!-- Todo: Check the size of the cell content, and create a subclause if it exceeds the maximum. -->
                                <xsl:if test="mrp:Requirement/@level = 'Conditional' or mrp:Requirement/@level = 'ConditionalExclusive'">
                                    <div>
                                        <p>Condition:</p>
                                        <xsl:call-template name="output-Condition">
                                            <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                        </xsl:call-template>
                                    </div>
                                </xsl:if>
                                <xsl:if test="count(mrp:Requirement/mrp:Description) &gt; 0">
                                    <div>
                                        <xsl:call-template name="output-XHTMLText">
                                            <xsl:with-param name="XHTML-text-element" select="mrp:Requirement/mrp:Description"/>
                                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                        </xsl:call-template>
                                    </div>
                                </xsl:if>
                            </td>
                        </tr>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-Impl-H2-Adapts-H3-AdaptX-Subclauses-H4-OperX">
        <!-- Purpose: Output a single operation subclause of an adaptation. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Operation -->
        <!-- Note: This template is part of a "chaining" approach to support numbered headings, as described in the template for the "Implementation" clause. -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="adaptation-name">
            <xsl:value-of select="../@name"/>
        </xsl:variable>
        <xsl:variable name="class-name">
            <xsl:value-of select="../@className"/>
        </xsl:variable>
        <xsl:variable name="operation-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="operation-element" select="self::*"/>
        <xsl:variable name="operation-moniker">
            <xsl:text>Operation: </xsl:text>
            <xsl:call-template name="get-operation-moniker">
                <xsl:with-param name="operation-element" select="$operation-element"/>
                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="operation-profile-type">
            <xsl:call-template name="get-operation-profile-type">
                <xsl:with-param name="operation-set" select="$operation-set"/>
                <xsl:with-param name="operation-name" select="$operation-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the heading link anchor element(s). -->
        <xsl:choose>
            <xsl:when test="$operation-profile-type = 'Referenced'">
                <!-- This is an association traversal operation. -->
                <xsl:choose>
                    <xsl:when test="count($operation-element/mrp:Association) &gt; 0">
                        <!-- The complete list of association adaptations to be traversed has been specified. -->
                        <xsl:for-each select="$operation-element/mrp:Association">
                            <xsl:sort select="@adaptationName"/>
                            <xsl:variable name="operation-anchor-name">
                                <xsl:value-of select="$generated-heading-id-prefix"/>
                                <xsl:text>A-</xsl:text>
                                <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                                <xsl:text>-O-</xsl:text>
                                <xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/>
                                <xsl:text>-A-</xsl:text>
                                <xsl:value-of select="translate(@adaptationName, $uri-translate-from, $uri-translate-to)"/>
                            </xsl:variable>
                            <xsl:text>
</xsl:text>
                            <!-- Need to wrapper the following global anchor element with a block element that has text content -->
                            <div style="visibility: hidden; line-height: 0; font-size: 0;">&#xA0;
<a>
                                    <xsl:attribute name="name"><xsl:value-of select="$operation-anchor-name"/></xsl:attribute>
                                </a>
                            </div>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The list of association adaptations to be traversed has not been specified and is defaulted to the
                        set of all association adaptations defined in this profile that reference the adaptation defining this
                        operation requirement, minus the association adaptations defined in sibling operations with the same name. -->
                        <xsl:variable name="specified-association-adaptation-names">
                            <!-- The vertical-bar-separated list of adaptation names of mrp:Association elements that are specified on operations with this name, within this adaptation. -->
                            <xsl:for-each select="$operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association | $operation-element/following-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association">
                                <xsl:text>|</xsl:text>
                                <xsl:value-of select="@adaptationName"/>
                            </xsl:for-each>
                            <xsl:text>|</xsl:text>
                        </xsl:variable>
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ mrp:Property/@refClassAdaptation = $adaptation-name and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]">
                            <!-- This loop goes through all defaulted referencing association adaptations. -->
                            <xsl:sort select="@name"/>
                            <xsl:variable name="operation-anchor-name">
                                <xsl:value-of select="$generated-heading-id-prefix"/>
                                <xsl:text>A-</xsl:text>
                                <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                                <xsl:text>-O-</xsl:text>
                                <xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/>
                                <xsl:text>-A-</xsl:text>
                                <xsl:value-of select="translate(@name, $uri-translate-from, $uri-translate-to)"/>
                            </xsl:variable>
                            <xsl:text>
</xsl:text>
                            <!-- Need to wrapper the following global anchor element with a block element that has text content -->
                            <div style="visibility: hidden; line-height: 0; font-size: 0;">&#xA0;
                                <a>
                                    <xsl:attribute name="name"><xsl:value-of select="$operation-anchor-name"/></xsl:attribute>
                                </a>
                            </div>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$operation-profile-type = 'OrdinaryOrAssociation'">
                <!-- This is a non-traversal operation. -->
                <xsl:variable name="operation-anchor-name">
                    <xsl:value-of select="$generated-heading-id-prefix"/>
                    <xsl:text>A-</xsl:text>
                    <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                    <xsl:text>-O-</xsl:text>
                    <xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/>
                </xsl:variable>
                <xsl:text>
</xsl:text>
                <!-- Need to wrapper the following global anchor element with a block element that has text content -->
                <div style="visibility: hidden; line-height: 0; font-size: 0;">&#xA0;
                    <a>
                        <xsl:attribute name="name"><xsl:value-of select="$operation-anchor-name"/></xsl:attribute>
                    </a>
                </div>
            </xsl:when>
        </xsl:choose>
        <xsl:variable name="operation-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
            <xsl:text>-O-</xsl:text>
            <xsl:value-of select="translate($operation-moniker, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H4">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="h3-number" select="$h3-number"/>
            <xsl:with-param name="h4-number" select="$h4-number"/>
            <xsl:with-param name="heading-text" select="$operation-moniker"/>
            <xsl:with-param name="heading-id" select="$operation-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <!-- Todo: Operation link does not work for association operations (add the association-adaptation-name parameter).
                    Needs to be fixed if the 'output-heading-links' control switch is supposed to be enabled again. -->
                <xsl:call-template name="output-link-Operation-tableentry">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="operation-name" select="$operation-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Element requirements table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <!-- Output reference to operation set document -->
        <p>
            <xsl:text>For general requirements on the implementation of this operation, see </xsl:text>
            <xsl:call-template name="output-link-NormativeReferencesOperationSet-entry">
                <xsl:with-param name="operation-set" select="$operation-set"/>
            </xsl:call-template>
            <xsl:text>.</xsl:text>
        </p>
        <!-- Output requirement level -->
        <div>
            <xsl:call-template name="output-RequirementText">
                <xsl:with-param name="text-begin" select="'The requirement level for this operation is '"/>
                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <!-- For association traversal operations, output the traversed associations. -->
        <xsl:if test="$operation-profile-type = 'Referenced'">
            <!-- This is an association traversal operation. -->
            <xsl:text>
</xsl:text>
            <p>This operation requirement applies when traversing the following association adaptations:</p>
            <xsl:text>
</xsl:text>
            <ul>
                <xsl:choose>
                    <xsl:when test="count($operation-element/mrp:Association) &gt; 0">
                        <!-- The complete list of association adaptations to be traversed has been specified. -->
                        <xsl:for-each select="$operation-element/mrp:Association">
                            <xsl:sort select="@adaptationName"/>
                            <xsl:text>
</xsl:text>
                            <li>
                                <xsl:call-template name="output-link-Adaptation-tableentry">
                                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                                </xsl:call-template>
                            </li>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- The list of association adaptations to be traversed has not been specified and is defaulted to the
                    set of all association adaptations defined in this profile that reference the adaptation defining this
                    operation requirement, minus the association adaptations defined in sibling operations with the same name. -->
                        <xsl:variable name="specified-association-adaptation-names">
                            <!-- The vertical-bar-separated list of adaptation names of mrp:Association elements that are specified on operations with this name, within this adaptation. -->
                            <xsl:for-each select="$operation-element/preceding-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association | $operation-element/following-sibling::mrp:Operation [ @name = $operation-name ] /mrp:Association">
                                <xsl:text>|</xsl:text>
                                <xsl:value-of select="@adaptationName"/>
                            </xsl:for-each>
                            <xsl:text>|</xsl:text>
                        </xsl:variable>
                        <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation [ mrp:Property/@refClassAdaptation = $adaptation-name and not(contains($specified-association-adaptation-names,concat('|',@name,'|'))) ]">
                            <!-- This loop goes through all defaulted referencing association adaptations. -->
                            <xsl:sort select="@name"/>
                            <li>
                                <xsl:call-template name="output-link-Adaptation-tableentry">
                                    <xsl:with-param name="adaptation-name" select="@name"/>
                                </xsl:call-template>
                            </li>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>
</xsl:text>
            </ul>
        </xsl:if>
        <!-- Output the operation model description, if specified. -->
        <xsl:if test="count(mrp:ModelDescription) &gt; 0">
            <xsl:text>
</xsl:text>
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:ModelDescription"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output the operation description, if specified. -->
        <xsl:if test="count(mrp:Description) &gt; 0">
            <xsl:text>
</xsl:text>
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <!-- Output operation constraints, if any -->
        <xsl:choose>
            <xsl:when test="count(mrp:Constraint) = 1">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraint for this operation:</p>
                <xsl:text>
</xsl:text>
                <div class="Normal-Indent1">
                    <xsl:call-template name="output-Constraint">
                        <xsl:with-param name="constraint-element" select="mrp:Constraint"/>
                        <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
                <xsl:text>
</xsl:text>
            </xsl:when>
            <xsl:when test="count(mrp:Constraint) &gt; 1">
                <xsl:text>
</xsl:text>
                <p>The implementation shall satisfy the following constraints for this operation:</p>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="mrp:Constraint">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-Constraint">
                                <xsl:with-param name="constraint-element" select="self::node()"/>
                                <xsl:with-param name="ocl-context-adaptation" select="$adaptation-name"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <!-- Otherwise: Nothing to do -->
        </xsl:choose>
        <!-- Output standard messages table for this operation. -->
        <xsl:call-template name="output-ErrorTable"/>
    </xsl:template>
    <xsl:template name="output-H1-UseCases">
        <!-- Purpose: Output the "Use Cases" clause of the profile. -->
        <!-- Invocation context: Top level element. -->
        <!-- Note: To support the generation of numbered headings under the functional rules of XSLT processing, this template
            and the templates for the subclauses of this clause use a "chaining" approach, as described in the template for the "Implementation" clause.
        -->
        <xsl:param name="h1-number"/>
        <xsl:call-template name="output-heading-H1">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="heading-text" select="'Use cases and state descriptions'"/>
            <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'UseCasesStateDescriptions')"/>
        </xsl:call-template>
        <xsl:choose>
            <xsl:when test="count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/*) &gt; 0">
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/*">
                    <xsl:choose>
                        <xsl:when test="local-name(self::*) = 'UseCase'">
                            <xsl:call-template name="output-H1-UseCases-H2-UseCaseX">
                                <xsl:with-param name="h1-number" select="$h1-number"/>
                                <xsl:with-param name="h2-number" select="position()"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="local-name(self::*) = 'StateDescription'">
                            <xsl:call-template name="output-H1-UseCases-H2-StateDescriptionX">
                                <xsl:with-param name="h1-number" select="$h1-number"/>
                                <xsl:with-param name="h2-number" select="position()"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: Unknown child element "<xsl:value-of select="local-name(self::*)"/>" defined in a "UseCases" element.</xsl:with-param>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <p>This profile does not define any use cases.</p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-UseCases-H2-UseCaseX">
        <!-- Purpose: Output a single Use Case subclause. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:UseCase -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="usecase-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="usecase-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>UC-</xsl:text>
            <xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>Use case: </xsl:text>
            <xsl:value-of select="$usecase-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$usecase-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <xsl:call-template name="output-link-UseCase-tableentry">
                    <xsl:with-param name="usecase-name" select="$usecase-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Use cases and state descriptions table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <!-- Output the use case description. The element is required to be defined in the XSD. -->
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h3'"/>
            </xsl:call-template>
        </div>
        <xsl:choose>
            <xsl:when test="count(mrp:SimpleFlow) &gt; 0">
                <!-- Dummy loop just to set the right context. Should do only one turn. -->
                <xsl:for-each select="mrp:SimpleFlow">
                    <xsl:choose>
                        <xsl:when test="count(mrp:PreCondition) &gt; 0">
                            <xsl:text>
</xsl:text>
                            <p>This use case has the following preconditions:</p>
                            <xsl:text>
</xsl:text>
                            <ul class="List-Bullet">
                                <xsl:for-each select="mrp:PreCondition">
                                    <xsl:text>
</xsl:text>
                                    <li class="List-Bullet">
                                        <xsl:call-template name="output-XHTMLText">
                                            <xsl:with-param name="XHTML-text-element" select="mrp:TextConstraint"/>
                                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                        </xsl:call-template>
                                    </li>
                                </xsl:for-each>
                                <xsl:text>
</xsl:text>
                            </ul>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="count(mrp:PostCondition) &gt; 0">
                            <xsl:text>
</xsl:text>
                            <p>This use case has the following postconditions:</p>
                            <xsl:text>
</xsl:text>
                            <ul class="List-Bullet">
                                <xsl:for-each select="mrp:PostCondition">
                                    <xsl:text>
</xsl:text>
                                    <li class="List-Bullet">
                                        <xsl:call-template name="output-XHTMLText">
                                            <xsl:with-param name="XHTML-text-element" select="mrp:TextConstraint"/>
                                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                        </xsl:call-template>
                                    </li>
                                </xsl:for-each>
                                <xsl:text>
</xsl:text>
                            </ul>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="count(mrp:Flow) &gt; 0">
                            <xsl:choose>
                                <xsl:when test="count(mrp:Flow/mrp:Step) = 0">
                                    <xsl:call-template name="ErrorMsg">
                                        <xsl:with-param name="msg">Profile Error: Use case "<xsl:value-of select="$usecase-name"/>" does not define any steps.</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:when test="count(mrp:Flow/mrp:Step) = 1">
                                    <p>The main flow for this use case consists of the following single step:</p>
                                </xsl:when>
                                <xsl:otherwise>
                                    <p>The main flow for this use case consists of the following sequence of steps:</p>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:text>
</xsl:text>
                            <ul class="List-Number">
                                <xsl:for-each select="mrp:Flow/mrp:Step">
                                    <xsl:text>
</xsl:text>
                                    <li class="List-Number">
                                        <xsl:call-template name="output-H1-UseCases-H2-UseCaseX-StepX"/>
                                    </li>
                                </xsl:for-each>
                                <xsl:text>
</xsl:text>
                            </ul>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>
</xsl:text>
                            <p>This use case does not define a flow.</p>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Unknown child element "<xsl:value-of select="local-name(self::*)"/>" defined in a "UseCase" element.</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-H1-UseCases-H2-UseCaseX-StepX">
        <!-- Purpose: Output a single use case step (including any sub-steps and included use cases). -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:UseCase/mrp:SimpleFlow/mrp:Flow/.../mrp:Step -->
        <!-- Output the use case step description. The element is required to be defined in the XSD. -->
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
            </xsl:call-template>
        </div>
        <xsl:if test="count(mrp:Step) &gt; 0">
            <xsl:text>
</xsl:text>
            <ul class="List-Bullet">
                <xsl:for-each select="mrp:Step">
                    <xsl:text>
</xsl:text>
                    <li class="List-Bullet">
                        <xsl:call-template name="output-H1-UseCases-H2-UseCaseX-StepX"/>
                    </li>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </ul>
        </xsl:if>
        <xsl:if test="count(mrp:IncludedUseCase) &gt; 0">
            <xsl:text>
</xsl:text>
            <ul class="List-Bullet">
                <!-- There is only one mrp:IncludedUseCase element allowed. This loop is defined just to set the context. -->
                <xsl:for-each select="mrp:IncludedUseCase">
                    <xsl:text>
</xsl:text>
                    <li class="List-Bullet">
                        <xsl:call-template name="output-H1-UseCases-H2-UseCaseX-IncludedUseCaseX"/>
                    </li>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </ul>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-H1-UseCases-H2-UseCaseX-IncludedUseCaseX">
        <!-- Purpose: Output a single included use case. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:UseCase/mrp:SimpleFlow/mrp:Flow/.../mrp:IncludedUseCase -->
        <p>
            <xsl:text>Perform use case </xsl:text>
            <xsl:value-of select="@useCaseName"/>
            <xsl:if test="@profileRefName != ''">
                <xsl:text> defined in profile </xsl:text>
                <xsl:call-template name="output-link-Profile-tableentry">
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:text>.</xsl:text>
        </p>
    </xsl:template>
    <xsl:template name="output-H1-UseCases-H2-StateDescriptionX">
        <!-- Purpose: Output a single StateDescription subclause. -->
        <!-- Invocation context: /mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:StateDescription -->
        <xsl:param name="h1-number"/>
        <xsl:param name="h2-number"/>
        <xsl:variable name="subject-profile-name" select="ancestor::mrp:Profile/@name"/>
        <xsl:variable name="subject-profile-organization" select="ancestor::mrp:Profile/@organization"/>
        <xsl:variable name="statedescription-name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="statedescription-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>SD-</xsl:text>
            <xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="heading-text">
            <xsl:text>State description: </xsl:text>
            <xsl:value-of select="$statedescription-name"/>
        </xsl:variable>
        <xsl:call-template name="output-heading-H2">
            <xsl:with-param name="h1-number" select="$h1-number"/>
            <xsl:with-param name="h2-number" select="$h2-number"/>
            <xsl:with-param name="heading-text" select="$heading-text"/>
            <xsl:with-param name="heading-id" select="$statedescription-heading-id"/>
        </xsl:call-template>
        <xsl:if test="$output-heading-links = 'true'">
            <p>
                <xsl:call-template name="output-link-StateDescription-tableentry">
                    <xsl:with-param name="statedescription-name" select="$statedescription-name"/>
                    <xsl:with-param name="linktext" select="concat($heading-link-arrow,' Use cases and state descriptions table entry')"/>
                </xsl:call-template>
            </p>
        </xsl:if>
        <!-- Output the state description description. The element is required to be defined in the XSD. -->
        <div>
            <xsl:call-template name="output-XHTMLText">
                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                <xsl:with-param name="topmost-allowed-heading-level" select="'h3'"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    <xsl:template name="output-A1-ChangeLog">
        <!-- Purpose: Output the "Change Log" annex. -->
        <!-- Invocation context: Top level element. -->
        <xsl:param name="a1-number"/>
        <!-- mrp:ChangeLog is required, as defined in the XSD. -->
        <xsl:text>
</xsl:text>
        <h1>
            <xsl:attribute name="id"><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>ChangeLog</xsl:text></xsl:attribute>
            <xsl:attribute name="class"><xsl:text>Annex1</xsl:text></xsl:attribute>
            <xsl:if test="$generate-headnum = 'true'">
                <xsl:value-of select="$a1-number"/>
            </xsl:if>
            <br/>
            <span style="font-weight: normal;">
                <xsl:text>(informative)</xsl:text>
            </span>
            <br/>
            <br/>
            <xsl:text>Change log</xsl:text>
        </h1>
        <xsl:text>
</xsl:text>
        <table class="Table" id="T-ChangeLog">
            <caption class="Table-Caption">Change log</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Version</th>
                    <th class="Table-HeadCell">Date</th>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:ChangeLog/mrp:Entry">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <xsl:value-of select="mrp:Version"/>
                            <xsl:if test="position() = last() and mrp:Version != /mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version">
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: Version of last change log entry "<xsl:value-of select="mrp:Version"/>" does not match the version of the document "<xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Version"/>".</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                        </td>
                        <td class="Table-BodyCell">
                            <xsl:value-of select="mrp:Date"/>
                            <xsl:if test="position() = last() and mrp:Date != /mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Date">
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: Date of last change log entry "<xsl:value-of select="mrp:Date"/>" does not match the date of the document "<xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:Date"/>".</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                        </td>
                        <td class="Table-BodyCell">
                            <xsl:call-template name="output-XHTMLText">
                                <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                                <!-- No subject (logical) profile context -->
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-Bibliography">
        <!-- Purpose: Output the "Bibliography" clause (if any). -->
        <!-- Invocation context: Top level element. -->
        <xsl:if test="count(/mrp:ProfileSpecification/mrp:Bibliography) &gt; 0">
            <xsl:call-template name="output-heading-H1">
                <xsl:with-param name="heading-text" select="'Bibliography'"/>
                <xsl:with-param name="heading-id" select="concat($generated-heading-id-prefix,'Bibliography')"/>
                <xsl:with-param name="heading-class" select="'Heading1-NoNum'"/>
                <xsl:with-param name="heading-style" select="'text-align: center;'"/>
            </xsl:call-template>
            <!-- Output the bibliography introduction text, if specified. -->
            <xsl:if test="count(/mrp:ProfileSpecification/mrp:Bibliography/mrp:Introduction) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="/mrp:ProfileSpecification/mrp:Bibliography/mrp:Introduction"/>
                        <!-- No subject (logical) profile context -->
                    </xsl:call-template>
                </div>
            </xsl:if>
            <div>
                <xsl:for-each select="/mrp:ProfileSpecification/mrp:Bibliography/mrp:DocumentReference">
                    <xsl:call-template name="output-DocumentReference"/>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    <xsl:template name="get-schema-class-metatype">
        <!-- Purpose: Get the meta type of a class, as defined in the underlying schema.
            On success, the returned string values are: "ordinary", "association", "indication".
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of ASSOCIATION qualifier as defined in schema class. -->
                <xsl:variable name="schema-Association-value">
                    <xsl:value-of select="translate(normalize-space(string($schema-class/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'ASSOCIATION' ]/VALUE)), $upper-case, $lower-case)"/>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the ASSOCIATION qualifier. -->
                <xsl:variable name="effective-schema-Association-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Association-value != '')">
                            <!-- Use default value of ASSOCIATION qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Association-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Retrieve value of INDICATION qualifier as defined in schema class. -->
                <xsl:variable name="schema-Indication-value">
                    <xsl:value-of select="translate(normalize-space(string($schema-class/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'INDICATION' ]/VALUE)), $upper-case, $lower-case)"/>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the INDICATION qualifier. -->
                <xsl:variable name="effective-schema-Indication-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Indication-value != '')">
                            <!-- Use default value of INDICATION qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Indication-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the metatype of the class. -->
                <xsl:choose>
                    <xsl:when test="$effective-schema-Association-value = 'false' and $effective-schema-Indication-value = 'false'">
                        <xsl:text>ordinary</xsl:text>
                    </xsl:when>
                    <xsl:when test="$effective-schema-Association-value = 'true' and $effective-schema-Indication-value = 'false'">
                        <xsl:text>association</xsl:text>
                    </xsl:when>
                    <xsl:when test="$effective-schema-Association-value = 'false' and $effective-schema-Indication-value = 'true'">
                        <xsl:text>indication</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- both are true. -->
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Schema Error: Schema class <xsl:value-of select="$class-name"/> defines both ASSOCIATION and INDICATION qualifiers as "true".
                    </xsl:with-param>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-class-is-abstract">
        <!-- Purpose: Get a Boolean indicator for whether the class is abstract, as defined in the underlying schema.
            On success, the returned string values are: "true", "false".
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of ABSTRACT qualifier as defined in schema class. -->
                <xsl:variable name="schema-Abstract-value">
                    <xsl:value-of select="translate(normalize-space(string($schema-class/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'ABSTRACT' ]/VALUE)), $upper-case, $lower-case)"/>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the ABSTRACT qualifier. -->
                <xsl:variable name="effective-schema-Abstract-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Abstract-value != '')">
                            <!-- Use default value of ABSTRACT qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Abstract-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the abstractness of the class. -->
                <xsl:value-of select="$effective-schema-Abstract-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-property-type">
        <!-- Purpose: Get the datatype of a property, as defined in the underlying schema.
            On success, the datatype of the property is returned, ready to be output (e.g. with "[ ]" for arrays).
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Note: This template only handles non-reference properties, since reference properties are handled by the caller already. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="prop" select="$schema-class/PROPERTY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-array" select="$schema-class/PROPERTY.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($prop) &gt; 0">
                <xsl:value-of select="$prop/@TYPE"/>
            </xsl:when>
            <xsl:when test="count($prop-array) &gt; 0">
                <xsl:value-of select="$prop-array/@TYPE"/>
                <xsl:text> [ ]</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-property-is-key">
        <!-- Purpose: Get a Boolean indicating whether a property is a key, as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="prop" select="$schema-class/PROPERTY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-array" select="$schema-class/PROPERTY.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-reference" select="$schema-class/PROPERTY.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-refarray" select="$schema-class/PROPERTY.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($prop) + count($prop-array) + count($prop-reference) + count($prop-refarray) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of KEY qualifier as defined in schema class. -->
                <xsl:variable name="schema-Key-value">
                    <xsl:choose>
                        <xsl:when test="count($prop) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'KEY' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'KEY' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-reference) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'KEY' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-refarray) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-refarray/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'KEY' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the KEY qualifier. -->
                <xsl:variable name="effective-schema-Key-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Key-value != '')">
                            <!-- Use default value of KEY qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Key-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value -->
                <xsl:value-of select="$effective-schema-Key-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-property-is-required">
        <!-- Purpose: Get a Boolean indicating whether a property is required (that is, non-NULL), as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="prop" select="$schema-class/PROPERTY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-array" select="$schema-class/PROPERTY.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-reference" select="$schema-class/PROPERTY.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-refarray" select="$schema-class/PROPERTY.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($prop) + count($prop-array) + count($prop-reference) + count($prop-refarray) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of REQUIRED qualifier as defined in schema class. -->
                <xsl:variable name="schema-Required-value">
                    <xsl:choose>
                        <xsl:when test="count($prop) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-reference) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-refarray) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-refarray/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the REQUIRED qualifier. -->
                <xsl:variable name="effective-schema-Required-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Required-value != '')">
                            <!-- Use default value of REQUIRED qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Required-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value -->
                <xsl:value-of select="$effective-schema-Required-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-property-is-reference">
        <!-- Purpose: Get a Boolean indicating whether a property has reference or reference array type, as defined in the underlying schema.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="prop" select="$schema-class/PROPERTY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-array" select="$schema-class/PROPERTY.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-reference" select="$schema-class/PROPERTY.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-refarray" select="$schema-class/PROPERTY.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($prop-reference) + count($prop-refarray) &gt; 0">
                <xsl:text>true</xsl:text>
            </xsl:when>
            <xsl:when test="count($prop) + count($prop-array) &gt; 0">
                <xsl:text>false</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Property "<xsl:value-of select="$property-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-type">
        <!-- Purpose: Get the datatype of a method parameter, as defined in the underlying schema.
            On success, the datatype of the parameter is returned, ready to be output (e.g. with "[ ]" for arrays).
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Note: This template only handles non-reference parameters, since reference parameters are handled by the caller already. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter) &gt; 0">
                <xsl:value-of select="$parameter/@TYPE"/>
            </xsl:when>
            <xsl:when test="count($parameter-array) &gt; 0">
                <xsl:value-of select="$parameter-array/@TYPE"/>
                <xsl:text> [ ]</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-returnvalue-type">
        <!-- Purpose: Get the datatype of a method return value, as defined in the underlying schema.
            On success, the datatype of the return value is returned, ready to be output.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="method" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($method) &gt; 0">
                <xsl:value-of select="$method/@TYPE"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-is-in">
        <!-- Purpose: Get a Boolean indicating the "In" direction of a method parameter, as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-reference" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-refarray" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter) + count($parameter-array) + count($parameter-reference) + count($parameter-refarray) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of IN qualifier as defined in schema class. -->
                <xsl:variable name="schema-In-value">
                    <xsl:choose>
                        <xsl:when test="count($parameter) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'IN' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'IN' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-reference) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'IN' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-refarray) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-refarray/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'IN' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the IN qualifier. -->
                <xsl:variable name="effective-schema-In-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-In-value != '')">
                            <!-- Use default value of the IN qualifier, if not defined in the schema class. -->
                            <xsl:text>true</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-In-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-In-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-is-out">
        <!-- Purpose: Get a Boolean indicating the "Out" direction of a method parameter, as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-reference" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-refarray" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter) + count($parameter-array) + count($parameter-reference) + count($parameter-refarray) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of OUT qualifier as defined in schema class. -->
                <xsl:variable name="schema-Out-value">
                    <xsl:choose>
                        <xsl:when test="count($parameter) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'OUT' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'OUT' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-reference) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'OUT' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-refarray) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-refarray/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'OUT' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the OUT qualifier. -->
                <xsl:variable name="effective-schema-Out-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Out-value != '')">
                            <!-- Use default value of the OUT qualifier, if not defined in the schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Out-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-Out-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-is-required">
        <!-- Purpose: Get a Boolean indicating whether a method parameter is required (that is, non-NULL), as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-reference" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-refarray" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter) + count($parameter-array) + count($parameter-reference) + count($parameter-refarray) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of REQUIRED qualifier as defined in schema class. -->
                <xsl:variable name="schema-Required-value">
                    <xsl:choose>
                        <xsl:when test="count($parameter) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-reference) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-refarray) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-refarray/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the REQUIRED qualifier. -->
                <xsl:variable name="effective-schema-Required-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Required-value != '')">
                            <!-- Use default value of REQUIRED qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Required-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-Required-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-is-reference">
        <!-- Purpose: Get a Boolean indicating whether a method parameter has reference or reference array type, as defined in the underlying schema.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-reference" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-refarray" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.REFARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter-reference) + count($parameter-refarray) &gt; 0">
                <xsl:text>true</xsl:text>
            </xsl:when>
            <xsl:when test="count($parameter) + count($parameter-array) &gt; 0">
                <xsl:text>false</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-returnvalue-is-required">
        <!-- Purpose: Get a Boolean indicating whether a method return value is required (that is, non-NULL), as defined in the underlying schema and in any global defaults.
            On success, one of the strings "true" or "false" is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="method" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($method) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Method "<xsl:value-of select="$method-name"/>" defined in a class adaptation is not exposed by schema class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of REQUIRED qualifier as defined in schema class. -->
                <xsl:variable name="schema-Required-value">
                    <xsl:choose>
                        <xsl:when test="count($method) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($method/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'REQUIRED' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Determine effective schema value, taking into account the default value of the REQUIRED qualifier. -->
                <xsl:variable name="effective-schema-Required-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Required-value != '')">
                            <!-- Use default value of REQUIRED qualifier, if not defined in schema class. -->
                            <xsl:text>false</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Required-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-Required-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-ref-multiplicity-min">
        <!-- Purpose: Get the MIN multiplicity of a reference, as defined in the underlying schema and in any global defaults.
            On success, the multiplicity value is returned.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="reference-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="reference" select="$schema-class/PROPERTY.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($reference-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($reference) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in an association class adaptation is not exposed by schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve the value of the MIN qualifier as defined in schema class. -->
                <xsl:variable name="schema-Min-value" select="normalize-space(string($reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'MIN' ]))"/>
                <!-- Determine effective schema value, taking into account the default value of the MIN qualifier. -->
                <xsl:variable name="effective-schema-Min-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Min-value != '')">
                            <!-- The global default value for the MIN qualifier is 0. -->
                            <xsl:text>0</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Min-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-Min-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-ref-multiplicity-max">
        <!-- Purpose: Get the MAX multiplicity of a reference, as defined in the underlying schema and in any global defaults.
            On success, the multiplicity value is returned. The value for "*" (that is, NULL) is represented as the string "unbounded".
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="reference-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="reference" select="$schema-class/PROPERTY.REFERENCE[ translate(@NAME, $lower-case, $upper-case) = translate($reference-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($reference) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in an association class adaptation is not exposed by schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve the value of the MAX qualifier as defined in schema class. -->
                <xsl:variable name="schema-Max-value" select="normalize-space(string($reference/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'MAX' ]))"/>
                <!-- Determine effective schema value, taking into account the default value of the MAX qualifier. -->
                <xsl:variable name="effective-schema-Max-value">
                    <xsl:choose>
                        <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                        <xsl:when test="not($schema-Max-value != '')">
                            <!-- The global default value for the MAX qualifier is NULL (= unbounded). -->
                            <xsl:text>unbounded</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$schema-Max-value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the effective schema value. -->
                <xsl:value-of select="$effective-schema-Max-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-property-embeddedinstance-class">
        <!-- Purpose: Get the class name of the embedded instance of properties for which an EmbeddedInstance qualifier is set.
            On success, the class name is returned if the EmbeddedInstance qualifier is set, and an empty strig is returned otherwise.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="prop" select="$schema-class/PROPERTY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="prop-array" select="$schema-class/PROPERTY.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($property-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($prop) + count($prop-array) = 0">
                <!-- We assume the property is a reference, so we are silent and return an empty string. No further checking needed here. -->
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of EmbeddedInstance qualifier as defined in schema class. -->
                <xsl:variable name="schema-EmbeddedInstance-value">
                    <xsl:choose>
                        <xsl:when test="count($prop) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'EMBEDDEDINSTANCE' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($prop-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($prop-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'EMBEDDEDINSTANCE' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the schema value -->
                <xsl:value-of select="$schema-EmbeddedInstance-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-parameter-embeddedinstance-class">
        <!-- Purpose: Get the class name of the embedded instance of parameters for which an EmbeddedInstance qualifier is set.
            On success, the class name is returned if the EmbeddedInstance qualifier is set, and an empty strig is returned otherwise.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="parameter" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:variable name="parameter-array" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]/PARAMETER.ARRAY[ translate(@NAME, $lower-case, $upper-case) = translate($parameter-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($parameter) + count($parameter-array) = 0">
                <!-- We assume the parameter is a reference, so we are silent and return an empty string. No further checking needed here. -->
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of EmbeddedInstance qualifier as defined in schema class. -->
                <xsl:variable name="schema-EmbeddedInstance-value">
                    <xsl:choose>
                        <xsl:when test="count($parameter) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'EMBEDDEDINSTANCE' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                        <xsl:when test="count($parameter-array) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($parameter-array/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'EMBEDDEDINSTANCE' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the schema value -->
                <xsl:value-of select="$schema-EmbeddedInstance-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-schema-returnvalue-embeddedinstance-class">
        <!-- Purpose: Get the class name of the embedded instance of return values for which an EmbeddedInstance qualifier is set.
            On success, the class name is returned if the EmbeddedInstance qualifier is set, and an empty strig is returned otherwise.
            On error, an error message is issued, and "(unknown)" along with the error message is returned. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:variable name="schema-name">
            <xsl:value-of select="substring-before($class-name,'_')"/>
        </xsl:variable>
        <xsl:variable name="schema-version">
            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@version"/>
        </xsl:variable>
        <xsl:variable name="schema-version-segment">
            <xsl:value-of select="concat(substring-before($schema-version,'.'),'.',substring-before(substring-after(concat($schema-version,'.'),'.'),'.'))"/>
            <xsl:if test="/mrp:ProfileSpecification/mrp:Profile/mrp:ProfileAttributes/mrp:Schemas/mrp:SchemaReference[ @name = $schema-name ]/@experimental = 'true'">
                <!-- This test also covers the default case of "false". -->
                <xsl:text>+</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="cim-xml-file-url" select="concat($cim-xml-root-url, '/', $schema-name, '/', $schema-version-segment, '/', $class-name, '.xml')"/>
        <xsl:variable name="schema-class" select="document($cim-xml-file-url)/CIM/DECLARATION/DECLGROUP/VALUE.OBJECT/CLASS"/>
        <xsl:variable name="method" select="$schema-class/METHOD[ translate(@NAME, $lower-case, $upper-case) = translate($method-name, $lower-case, $upper-case) ]"/>
        <xsl:choose>
            <xsl:when test="count($schema-class) = 0">
                <xsl:text>(unknown)</xsl:text>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Setup Error: CIM-XML file not found, or file has unknown content: <xsl:value-of select="$cim-xml-file-url"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="count($method) = 0">
                <!-- We assume the return value is a reference, so we are silent and return an empty string. No further checking needed here. -->
            </xsl:when>
            <xsl:otherwise>
                <!-- Retrieve value of EmbeddedInstance qualifier as defined in schema class. -->
                <xsl:variable name="schema-EmbeddedInstance-value">
                    <xsl:choose>
                        <xsl:when test="count($method) &gt; 0">
                            <xsl:value-of select="translate(normalize-space(string($method/QUALIFIER[ translate(@NAME, $lower-case, $upper-case) = 'EMBEDDEDINSTANCE' ]/VALUE)), $upper-case, $lower-case)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <!-- Return the schema value -->
                <xsl:value-of select="$schema-EmbeddedInstance-value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="check-property-reference-rules">
        <!-- Purpose: Verify rules on reference types for a property.
            On success, nothing is returned.
            On error, an error message is issued. -->
        <!-- Invocation context: mrp:Property. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <!-- Verify reference related attributes -->
        <xsl:variable name="property-is-reference">
            <xsl:call-template name="get-schema-property-is-reference">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="property-name" select="$property-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="$property-is-reference = 'true'">
            <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
            <xsl:if test="not(@refClassAdaptation != '')">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Required attribute "refClassAdaptation" is missing on reference property "<xsl:value-of select="$property-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
        <xsl:if test="$property-is-reference = 'false'">
            <xsl:if test="@refClassAdaptation != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refClassAdaptation" is specified on non-reference property "<xsl:value-of select="$property-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="@refMin != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refMin" is specified on non-reference property "<xsl:value-of select="$property-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="@refMax != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refMax" is specified on non-reference property "<xsl:value-of select="$property-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="check-parameter-reference-rules">
        <!-- Purpose: Verify rules on reference types for a parameter.
            On success, nothing is returned.
            On error, an error message is issued. -->
        <!-- Invocation context: mrp:Parameter. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <!-- Verify reference related attributes -->
        <xsl:variable name="parameter-is-reference">
            <xsl:call-template name="get-schema-parameter-is-reference">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="method-name" select="$method-name"/>
                <xsl:with-param name="parameter-name" select="$parameter-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="$parameter-is-reference = 'true'">
            <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
            <xsl:if test="not(@refClassAdaptation != '')">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Required attribute "refClassAdaptation" is missing on reference-typed parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
        <xsl:if test="$parameter-is-reference = 'false'">
            <xsl:if test="@refClassAdaptation != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refClassAdaptation" is specified on non-reference-typed parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="@refMin != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refMin" is specified on non-reference-typed parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="@refMax != ''">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Reference-specific attribute "refMax" is specified on non-reference-typed parameter "<xsl:value-of select="$parameter-name"/>" of method "<xsl:value-of select="$method-name"/>" defined in class adaptation "<xsl:value-of select="$adaptation-name"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-schema-property-key">
        <!-- Purpose: Output the KEY qualifier of a property, taking into account the underlying schema and the global qualifier default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-property-is-key">
            <xsl:call-template name="get-schema-property-is-key">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="property-name" select="$property-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the KEY qualifier. -->
        <xsl:choose>
            <xsl:when test="$schema-property-is-key = 'true'">
                <xsl:value-of select="$qualifier-key-keyword"/>
            </xsl:when>
            <xsl:when test="$schema-property-is-key = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-property-is-key"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-schema-property-required">
        <!-- Purpose: Output the REQUIRED qualifier of a property, taking into account the underlying schema and the global qualifier default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="property-name"/>
        <xsl:variable name="schema-property-is-required">
            <xsl:call-template name="get-schema-property-is-required">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="property-name" select="$property-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the REQUIRED property. -->
        <xsl:choose>
            <xsl:when test="$schema-property-is-required = 'true'">
                <xsl:value-of select="$qualifier-required-keyword"/>
            </xsl:when>
            <xsl:when test="$schema-property-is-required = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-property-is-required"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-schema-parameter-direction">
        <!-- Purpose: Output the direction of a method parameter, taking into account the underlying schema and the global qualifier default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-parameter-is-in">
            <xsl:call-template name="get-schema-parameter-is-in">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="method-name" select="$method-name"/>
                <xsl:with-param name="parameter-name" select="$parameter-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="schema-parameter-is-out">
            <xsl:call-template name="get-schema-parameter-is-out">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="method-name" select="$method-name"/>
                <xsl:with-param name="parameter-name" select="$parameter-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the direction. -->
        <xsl:choose>
            <xsl:when test="$schema-parameter-is-in = 'true'">
                <xsl:value-of select="$qualifier-in-keyword"/>
                <xsl:text> </xsl:text>
            </xsl:when>
            <xsl:when test="$schema-parameter-is-in = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-parameter-is-in"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$schema-parameter-is-out = 'true'">
                <xsl:value-of select="$qualifier-out-keyword"/>
            </xsl:when>
            <xsl:when test="$schema-parameter-is-out = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-parameter-is-out"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-schema-parameter-required">
        <!-- Purpose: Output the REQUIRED qualifier of a method parameter, taking into account the underlying schema and the global qualifier default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:variable name="schema-parameter-is-required">
            <xsl:call-template name="get-schema-parameter-is-required">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="method-name" select="$method-name"/>
                <xsl:with-param name="parameter-name" select="$parameter-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the REQUIRED property. -->
        <xsl:choose>
            <xsl:when test="$schema-parameter-is-required = 'true'">
                <xsl:value-of select="$qualifier-required-keyword"/>
            </xsl:when>
            <xsl:when test="$schema-parameter-is-required = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-parameter-is-required"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-schema-returnvalue-required">
        <!-- Purpose: Output the REQUIRED qualifier of a method return value, taking into account the underlying schema and the global qualifier default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="class-name"/>
        <xsl:param name="method-name"/>
        <xsl:variable name="schema-returnvalue-is-required">
            <xsl:call-template name="get-schema-returnvalue-is-required">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="method-name" select="$method-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Output the REQUIRED property. -->
        <xsl:choose>
            <xsl:when test="$schema-returnvalue-is-required = 'true'">
                <xsl:value-of select="$qualifier-required-keyword"/>
            </xsl:when>
            <xsl:when test="$schema-returnvalue-is-required = 'false'">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Pass through the error -->
                <xsl:copy-of select="$schema-returnvalue-is-required"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-effective-ref-multiplicity">
        <!-- Purpose: Output the effective multiplicity of a reference ("min .. max"),
            taking into account the global defaults, any multiplicity defined in the underlying schema,
            and any multiplicity constraints defined in the profile. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="class-name"/>
        <xsl:param name="reference-name"/>
        <xsl:param name="profile-ref-min"/>
        <xsl:param name="profile-ref-max"/>
        <xsl:variable name="schema-ref-min">
            <xsl:call-template name="get-schema-ref-multiplicity-min">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="reference-name" select="$reference-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="schema-ref-max">
            <xsl:call-template name="get-schema-ref-multiplicity-max">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="reference-name" select="$reference-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Determine the effective multiplicity from profile and schema-defined multiplicity. -->
        <xsl:variable name="effective-ref-min">
            <xsl:choose>
                <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                <xsl:when test="not($profile-ref-min != '')">
                    <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                    <xsl:copy-of select="$schema-ref-min"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$profile-ref-min"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="effective-ref-max">
            <xsl:choose>
                <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                <xsl:when test="not($profile-ref-max != '')">
                    <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                    <xsl:copy-of select="$schema-ref-max"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$profile-ref-max"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
        <xsl:copy-of select="$effective-ref-min"/>
        <xsl:text> .. </xsl:text>
        <xsl:choose>
            <xsl:when test="$effective-ref-max = 'unbounded'">
                <xsl:text>*</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                <xsl:copy-of select="$effective-ref-max"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$profile-ref-min &lt; $schema-ref-min">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in association class adaptation "<xsl:value-of select="$adaptation-name"/>" constrains its minimum multiplicity to "<xsl:value-of select="$profile-ref-min"/>", which is invalid because it is less than the minimum multiplicity "<xsl:value-of select="$schema-ref-min"/>" defined in schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="($profile-ref-max = 'unbounded' and $schema-ref-max != 'unbounded') or ($profile-ref-max != 'unbounded' and $schema-ref-max != 'unbounded' and $profile-ref-max &gt; $schema-ref-max)">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in association class adaptation "<xsl:value-of select="$adaptation-name"/>" constrains its maximum multiplicity to "<xsl:value-of select="$profile-ref-max"/>", which is invalid because it is greater than the maximum multiplicity "<xsl:value-of select="$schema-ref-max"/>" defined in schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-effective-ref-multiplicity-constraint">
        <!-- Purpose: Output a constraint text for the effective multiplicity of a reference,
            taking into account the global defaults, any multiplicity defined in the underlying schema,
            and any multiplicity constraints defined in the profile. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="class-name"/>
        <xsl:param name="reference-name"/>
        <xsl:param name="profile-ref-min"/>
        <xsl:param name="profile-ref-max"/>
        <xsl:variable name="schema-ref-min">
            <xsl:call-template name="get-schema-ref-multiplicity-min">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="reference-name" select="$reference-name"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="schema-ref-max">
            <xsl:call-template name="get-schema-ref-multiplicity-max">
                <xsl:with-param name="class-name" select="$class-name"/>
                <xsl:with-param name="reference-name" select="$reference-name"/>
            </xsl:call-template>
        </xsl:variable>
        <!-- Determine the effective multiplicity from profile and schema-defined multiplicity. -->
        <xsl:variable name="effective-ref-min">
            <xsl:choose>
                <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                <xsl:when test="not($profile-ref-min != '')">
                    <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                    <xsl:copy-of select="$schema-ref-min"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$profile-ref-min"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="effective-ref-max">
            <xsl:choose>
                <!-- The following test also covers the case of the default value of the attribute. Testing for an unspecified attribute only seems to work in XSLT 1.0 when testing with !=, hence the somewhat strange expression. -->
                <xsl:when test="not($profile-ref-max != '')">
                    <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                    <xsl:copy-of select="$schema-ref-max"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$profile-ref-max"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$effective-ref-min != $schema-ref-min or $effective-ref-max != $schema-ref-max">
                <xsl:text>The multiplicity of [</xsl:text>
                <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                <xsl:copy-of select="$schema-ref-min"/>
                <xsl:text> .. </xsl:text>
                <xsl:choose>
                    <xsl:when test="$schema-ref-max = 'unbounded'">
                        <xsl:text>*</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                        <xsl:copy-of select="$schema-ref-max"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>] defined in the schema is constrained to [</xsl:text>
                <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                <xsl:copy-of select="$effective-ref-min"/>
                <xsl:text> .. </xsl:text>
                <xsl:choose>
                    <xsl:when test="$effective-ref-max = 'unbounded'">
                        <xsl:text>*</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                        <xsl:copy-of select="$effective-ref-max"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>].</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>The multiplicity of [</xsl:text>
                <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                <xsl:copy-of select="$schema-ref-min"/>
                <xsl:text> .. </xsl:text>
                <xsl:choose>
                    <xsl:when test="$schema-ref-max = 'unbounded'">
                        <xsl:text>*</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- We use copy-of (instead of value-of), in order to retain the elements in case the variable contains an error. -->
                        <xsl:copy-of select="$schema-ref-max"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>] defined in the schema is not further constrained.</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$profile-ref-min &lt; $schema-ref-min">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in association class adaptation "<xsl:value-of select="$adaptation-name"/>" constrains its minimum multiplicity to "<xsl:value-of select="$profile-ref-min"/>", which is invalid because it is less than the minimum multiplicity "<xsl:value-of select="$schema-ref-min"/>" defined in schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="($profile-ref-max = 'unbounded' and $schema-ref-max != 'unbounded') or ($profile-ref-max != 'unbounded' and $schema-ref-max != 'unbounded' and $profile-ref-max &gt; $schema-ref-max)">
            <xsl:call-template name="ErrorMsg">
                <xsl:with-param name="msg">Profile Error: Reference "<xsl:value-of select="$reference-name"/>" defined in association class adaptation "<xsl:value-of select="$adaptation-name"/>" constrains its maximum multiplicity to "<xsl:value-of select="$profile-ref-max"/>", which is invalid because it is greater than the maximum multiplicity "<xsl:value-of select="$schema-ref-max"/>" defined in schema association class "<xsl:value-of select="$class-name"/>".</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-ImplementationType">
        <!-- Purpose: Output the effective implementation type of an adaptation. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="implementation-type"/>
        <!-- The default value for the implementationType attribute has not yet been made explicit by the caller -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="is-association"/>
        <xsl:variable name="effective-implementation-type">
            <xsl:call-template name="get-effective-implementation-type">
                <xsl:with-param name="implementation-type" select="$implementation-type"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="translate($effective-implementation-type, $upper-case, $lower-case)"/>
        <xsl:choose>
            <xsl:when test="$effective-implementation-type = 'Indication' or $effective-implementation-type = 'Exception'">
                <xsl:choose>
                    <xsl:when test="$is-association = 'true'">
                        <!-- This test also covers the default case of "false". -->
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" has implementation type "<xsl:value-of select="$effective-implementation-type"/>" but states that the adapted class is an association (through its "isAssociation" attribute).</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$is-association = 'true'">
                        <!-- This test also covers the default case of "false". -->
                        <xsl:text> association adaptation</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> ordinary adaptation</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="get-effective-implementation-type">
        <!-- Purpose: Determine the effective implementation type of an association, taking into account the default. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="implementation-type"/>
        <xsl:choose>
            <xsl:when test="$implementation-type != ''">
                <xsl:value-of select="$implementation-type"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Default implementation type if no implementationType attribute is specified, as defined in DSP8028. -->
                <xsl:text>Instantiated</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-RequirementLevel">
        <!-- Purpose: Output a requirement level for a profile element (except for some types of profile elements that have special output templates). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="requirement-element"/>
        <xsl:choose>
            <xsl:when test="count($requirement-element) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">DSP8029 Error: Template "output-RequirementLevel" invoked without specifying the "requirement-element" parameter.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$requirement-element/@level"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-RequirementLevelOfAdaptation">
        <!-- Purpose: Output a requirement level for an adaptation. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="requirement-element"/>
        <xsl:param name="implementation-type"/>
        <!-- The default value for the implementationType attribute has already been made explicit by the caller -->
        <xsl:param name="adaptation-name"/>
        <xsl:choose>
            <xsl:when test="$implementation-type = 'Instantiated' or $implementation-type = 'Indication'">
                <xsl:choose>
                    <xsl:when test="count($requirement-element) = 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" has implementation type "<xsl:value-of select="$implementation-type"/>" but does not define a requirement level (that is, a "Requirement" element).</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$requirement-element/@level"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$implementation-type = 'Exception'">
                <xsl:text>See using protocols</xsl:text>
                <xsl:if test="count($requirement-element) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$implementation-type = 'Abstract'">
                <xsl:text>See derived adaptations</xsl:text>
                <xsl:if test="count($requirement-element) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$implementation-type = 'Embedded'">
                <xsl:text>See embedding elements</xsl:text>
                <xsl:if test="count($requirement-element) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <!-- Should not happen -->
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines an unknown implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-RequirementText">
        <!-- Purpose: Output the full text of a requirement, including the conditions, if any (that is, an element of type mrp:Requirement_Type, e.g. mrp:Requirement). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="text-begin"/>
        <xsl:param name="requirement-element"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <!-- Dummy loop, just to set the context. Should have just one iteration. -->
        <xsl:for-each select="$requirement-element">
            <xsl:choose>
                <xsl:when test="@level = 'Mandatory'">
                    <p>
                        <xsl:value-of select="$text-begin"/>
                        <xsl:text>mandatory.</xsl:text>
                    </p>
                </xsl:when>
                <xsl:when test="@level = 'Optional'">
                    <p>
                        <xsl:value-of select="$text-begin"/>
                        <xsl:text>optional.</xsl:text>
                    </p>
                </xsl:when>
                <xsl:when test="@level = 'Conditional' or @level = 'ConditionalExclusive'">
                    <p>
                        <xsl:value-of select="$text-begin"/>
                        <xsl:choose>
                            <xsl:when test="@level = 'Conditional'">
                                <xsl:text>conditional</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>conditional exclusive</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:text>, with the following condition:</xsl:text>
                    </p>
                    <div>
                        <xsl:call-template name="output-Condition">
                            <xsl:with-param name="requirement-element" select="self::*"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        </xsl:call-template>
                    </div>
                </xsl:when>
                <!-- The XSD prevents other values, so they are not tested. -->
            </xsl:choose>
            <!-- Output the requirement level description, if specified. -->
            <xsl:if test="count($requirement-element/mrp:Description) &gt; 0">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="$requirement-element/mrp:Description"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-ImplementationTypeAndRequirementTextOfAdaptation">
        <!-- Purpose: Output a statement about the implementation type and the requirement level of a class adaptation. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="requirement-element"/>
        <!-- The mrp:Requirement element of the adaptation. -->
        <xsl:param name="concrete-subclass-requirement-element"/>
        <!-- The mrp:ConcreteSubclassRequirement element of the adaptation. -->
        <xsl:param name="implementation-type"/>
        <!-- The default value for the implementationType attribute has already been made explicit by the caller -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="class-name"/>
        <xsl:param name="is-association"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <p>
            <!-- Output the implementation type of the adaptation (including information to distinguish ordinary and association). -->
            <xsl:text>The implementation type of this adaptation is </xsl:text>
            <xsl:call-template name="output-ImplementationType">
                <xsl:with-param name="implementation-type" select="$implementation-type"/>
                <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                <xsl:with-param name="is-association" select="$is-association"/>
            </xsl:call-template>
            <xsl:text>.</xsl:text>
        </p>
        <div>
            <!-- Output the requirement for implementing a concrete subclass, if specified. -->
            <xsl:variable name="schema-class-is-abstract">
                <xsl:call-template name="get-schema-class-is-abstract">
                    <xsl:with-param name="class-name" select="$class-name"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="count($concrete-subclass-requirement-element) &gt; 0">
                    <!-- A concrete subclass requirement has been specified. -->
                    <xsl:choose>
                        <xsl:when test="$implementation-type = 'Abstract'">
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" has implementation type "<xsl:value-of select="$implementation-type"/>" but specifies a requirement for implementing a concrete subclass (that is, a "ConcreteSubclassRequirement" element).</xsl:with-param>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="not($schema-class-is-abstract = 'true')">
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" adapting the concrete schema class "<xsl:value-of select="$class-name"/>" has implementation type "<xsl:value-of select="$implementation-type"/>" but specifies a requirement for implementing a concrete subclass (that is, a "ConcreteSubclassRequirement" element).</xsl:with-param>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- Output the general concrete subclass requirement. -->
                            <p>A concrete subclass of the abstract schema class <xsl:value-of select="$class-name"/> needs to be implemented.</p>
                            <!-- Output the requirement level description, if specified. -->
                            <xsl:if test="count($concrete-subclass-requirement-element/mrp:Description) &gt; 0">
                                <div>
                                    <xsl:call-template name="output-XHTMLText">
                                        <xsl:with-param name="XHTML-text-element" select="$concrete-subclass-requirement-element/mrp:Description"/>
                                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                    </xsl:call-template>
                                </div>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <!-- No concrete subclass requirement has been specified. -->
                    <xsl:choose>
                        <xsl:when test="$implementation-type != 'Abstract' and $schema-class-is-abstract = 'true'">
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" adapting the abstract schema class "<xsl:value-of select="$class-name"/>" has implementation type "<xsl:value-of select="$implementation-type"/>" but does not require that a concrete subclass needs to be implemented (through a "ConcreteSubclassRequirement" element).</xsl:with-param>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- Nothing to do in this case -->
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </div>
        <div>
            <!-- Output the requirement level of the adaptation. -->
            <xsl:choose>
                <xsl:when test="$implementation-type = 'Instantiated' or $implementation-type = 'Indication'">
                    <xsl:choose>
                        <xsl:when test="count($requirement-element) = 0">
                            <xsl:call-template name="ErrorMsg">
                                <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" has implementation type "<xsl:value-of select="$implementation-type"/>" but does not define a requirement level (that is, a "Requirement" element).</xsl:with-param>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="output-RequirementText">
                                <xsl:with-param name="text-begin" select="'The requirement level for this adaptation is '"/>
                                <xsl:with-param name="requirement-element" select="$requirement-element"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$implementation-type = 'Exception'">
                    <p>The requirement level for this exception adaptation is left to be defined by protocols using this exception.</p>
                    <xsl:if test="count($requirement-element) &gt; 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$implementation-type = 'Abstract'">
                    <p>The requirement level for this abstract adaptation is left to be defined in its derived adaptations.</p>
                    <xsl:if test="count($requirement-element) &gt; 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$implementation-type = 'Embedded'">
                    <p>The requirement level for this embedded adaptation is left to be defined in its embedding elements.</p>
                    <xsl:if test="count($requirement-element) &gt; 0">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines a requirement level (that is, a "Requirement" element) but has implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Should not happen -->
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Class adaptation "<xsl:value-of select="$adaptation-name"/>" defines an unknown implementation type "<xsl:value-of select="$implementation-type"/>".</xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    <xsl:template name="get-ValueRequirementDescriptionText">
        <!-- Purpose: Retrieve the XHTML text for the Description column of a value requirement table. -->
        <!-- This XHTML text is used for making the decision whether to use a table cell or a subclause (based on its length),
               and as the actual text to be used, both in the table cell and in the subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="value-requirement-element"/>
        <!-- The mrp:Value element representing the value requirement (that is, not its mrp:Value child element representing the value). -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:if test="count($value-requirement-element/mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="$value-requirement-element/mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <xsl:if test="$value-requirement-element/mrp:Requirement/@level = 'Conditional' or $value-requirement-element/mrp:Requirement/@level = 'ConditionalExclusive'">
            <div>
                <p>Condition:</p>
                <xsl:call-template name="output-Condition">
                    <xsl:with-param name="requirement-element" select="$value-requirement-element/mrp:Requirement"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
        <xsl:if test="count($value-requirement-element/mrp:Requirement/mrp:Description) &gt; 0">
            <div>
                <xsl:call-template name="output-XHTMLText">
                    <xsl:with-param name="XHTML-text-element" select="$value-requirement-element/mrp:Requirement/mrp:Description"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    <xsl:template name="output-Condition">
        <!-- Purpose: Output a condition (that is, an element of type mrp:Condition_Type, e.g. mrp:Condition). -->
        <!-- Invocation context: Any. -->
        <!-- Todo: Verify that no mrp:Condition element is specified when the requirement level is not also conditional or conditional exclusive.
However, this template is only invoked when the requirement level is one of those, so the template would need to be changed such that it is
always invoked, and performs the test whether a condition is to be emitted, inside of the template. This again requires to control on the caller
side what textual elements are to be used around the generated condition text. -->
        <xsl:param name="requirement-element"/>
        <!-- The mrp:Requirement element, with mrp:Condition as a direct child. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:choose>
            <xsl:when test="count($requirement-element/mrp:Condition) = 0">
                <!--There is no Condition child element specified. -->
                <!-- $element-element is the profile element that has the requirement level specified (element structure: $element-element/mrp:Requirement/mrp:Condition -->
                <xsl:variable name="element-element" select="$requirement-element/.."/>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">
                        <xsl:text>Profile Error: </xsl:text>
                        <xsl:choose>
                            <xsl:when test="local-name($element-element) = 'RelatedProfile'">
                                <!-- Element hierarchy within profile: mrp:RelatedProfile -->
                                <xsl:text>Related profile with reference name "</xsl:text>
                                <xsl:value-of select="$element-element/@refName"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Feature'">
                                <!-- Element hierarchy within profile: mrp:Feature -->
                                <xsl:text>Feature "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'ClassAdaptation'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation -->
                                <xsl:text>Adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'BaseAdaptation'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:BaseAdaptation -->
                                <xsl:text>Base adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'AlertMessage'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:BaseAdaptation/mrp:AlertMessage -->
                                <xsl:text>Alert message "</xsl:text>
                                <xsl:value-of select="concat($element-element/@prefix,$element-element/@sequenceNumber)"/>
                                <xsl:text>" required by base adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Metric'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:BaseAdaptation/mrp:Metric -->
                                <xsl:text>Metric "</xsl:text>
                                <xsl:value-of select="$element-element/@localId"/>
                                <xsl:text>" required by base adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Property'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Property -->
                                <xsl:text>Property "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Initialization'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Property/mrp:Initialization -->
                                <xsl:text>Initialization of property "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element/..) = 'Initialization' and local-name($element-element) = 'Value'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Property/mrp:Initialization/mrp:Value -->
                                <xsl:text>Initialization value "</xsl:text>
                                <xsl:value-of select="$element-element/mrp:Value"/>
                                <xsl:text>" of property "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Modification'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Property/mrp:Modification -->
                                <xsl:text>Modification of property "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element/..) = 'Modification' and local-name($element-element) = 'Value'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Property/mrp:Modification/mrp:Value -->
                                <xsl:text>Modification value "</xsl:text>
                                <xsl:value-of select="$element-element/mrp:Value"/>
                                <xsl:text>" of property "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Method'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Method -->
                                <xsl:text>Method "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element/..) = 'Method' and local-name($element-element) = 'Error'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Method/mrp:Error -->
                                <xsl:text>An error of method "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element/..) = 'Parameter' and local-name($element-element) = 'Value'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Method/mrp:Parameter/mrp:Value -->
                                <xsl:text>Value "</xsl:text>
                                <xsl:value-of select="$element-element/mrp:Value"/>
                                <xsl:text>" of parameter "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of method "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element) = 'Operation'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Operation -->
                                <xsl:text>Operation "</xsl:text>
                                <xsl:value-of select="$element-element/@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                            <xsl:when test="local-name($element-element/..) = 'Operation' and local-name($element-element) = 'Error'">
                                <!-- Element hierarchy within profile: mrp:ClassAdaptation/mrp:Operation/mrp:Error -->
                                <xsl:text>An error of operation "</xsl:text>
                                <xsl:value-of select="$element-element/../@name"/>
                                <xsl:text>" of adaptation "</xsl:text>
                                <xsl:value-of select="$element-element/../../@name"/>
                                <xsl:text>"</xsl:text>
                            </xsl:when>
                        </xsl:choose>
                        <xsl:text> specifies a requirement level "</xsl:text>
                        <xsl:value-of select="$requirement-element/@level"/>
                        <xsl:text>" without specifying a condition (that is, a "Condition" element).</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Normal case, there is a Condition child element specified. -->
                <xsl:for-each select="$requirement-element/mrp:Condition">
                    <!-- Dummy loop, just to set the context. Should have just one iteration. -->
                    <xsl:for-each select="child::*">
                        <!-- This loop should go only once (since mrp:Condition can have only one child element according to the XSD). -->
                        <div class="Normal-Indent1">
                            <xsl:call-template name="output-ConditionItem">
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </div>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-ConditionItem">
        <!-- Purpose: Output a condition item. -->
        <!-- Invocation context: A substitution element of the (abstract) head element mrp:ConditionItem. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:choose>
            <xsl:when test="local-name(self::*) = 'Condition.AND'">
                <xsl:text>
</xsl:text>
                <xsl:text>All of the following is true:</xsl:text>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="child::*">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-ConditionItem">
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'Condition.OR'">
                <xsl:text>
</xsl:text>
                <xsl:text>At least one of the following is true:</xsl:text>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="child::*">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-ConditionItem"/>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'Condition.XOR'">
                <xsl:text>
</xsl:text>
                <xsl:text>Either the first or the second of the following is true:</xsl:text>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="child::*">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-ConditionItem">
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'Condition.NOT'">
                <xsl:text>
</xsl:text>
                <xsl:text>The following is NOT true:</xsl:text>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="child::*">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-ConditionItem">
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                    <xsl:text>
</xsl:text>
                </ul>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'Condition.IMPLIES'">
                <xsl:text>
</xsl:text>
                <xsl:text>The first item implies the second item:</xsl:text>
                <xsl:text>
</xsl:text>
                <ul class="List-Bullet">
                    <xsl:for-each select="child::*">
                        <xsl:text>
</xsl:text>
                        <li class="List-Bullet">
                            <xsl:call-template name="output-ConditionItem">
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ProfileImplementationCondition'">
                <xsl:text>The </xsl:text>
                <xsl:call-template name="output-link-Profile-tableentry">
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                </xsl:call-template>
                <xsl:text> profile is implemented.</xsl:text>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'FeatureImplementationCondition'">
                <xsl:text>The </xsl:text>
                <xsl:call-template name="output-link-Feature-tableentry">
                    <xsl:with-param name="feature-name" select="@featureName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
                <xsl:text> feature</xsl:text>
                <xsl:text> is implemented.</xsl:text>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ClassAdaptationImplementationCondition'">
                <xsl:variable name="adaptation-name">
                    <xsl:value-of select="@name"/>
                </xsl:variable>
                <xsl:text>The </xsl:text>
                <xsl:call-template name="output-link-Adaptation-tableentry">
                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
                <xsl:text> adaptation</xsl:text>
                <xsl:text> is implemented.</xsl:text>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ManagedEnvironmentCondition'">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="self::node()"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Invalid type of condition "<xsl:value-of select="local-name(self::*)"/>" defined on an element.</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-Constraint">
        <!-- Purpose: Output a constraint (that is, an element of type mrp:Constraint_Type, e.g. mrp:Constraint or mrp:PreCondition). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="constraint-element"/>
        <xsl:param name="ocl-context-adaptation" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <!-- Dummy loop, just to set the context. Should have just one iteration. -->
        <xsl:for-each select="$constraint-element">
            <xsl:choose>
                <xsl:when test="child::node() = mrp:OCLConstraint">
                    <p>
                        <xsl:text>OCL constraint with context of a </xsl:text>
                        <xsl:call-template name="output-link-Adaptation-tableentry">
                            <xsl:with-param name="adaptation-name" select="$ocl-context-adaptation"/>
                        </xsl:call-template>
                        <xsl:text> instance:</xsl:text>
                    </p>
                    <xsl:if test="$ocl-context-adaptation = ''">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">DSP8029 Error: Template "output-Constraint" invoked with an OCL constraint without specifying an OCL context (that is, the "ocl-context-adaptation" parameter).</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:text>
</xsl:text>
                    <table class="Code">
                        <tbody>
                            <xsl:text>
</xsl:text>
                            <tr>
                                <td>
                                    <pre class="Code">
                                        <!-- If XSLT 2.0 was supported by browsers, we could use its fn:replace() function to improve the formatting
experience of OCL code by inserting a zero width space (U+200B) after some strings, e.g. ".", "->", "(", ",". However, as it stands right
now, the profile author needs to make sure there are sufficient spaces, each of which is a line break opportunity when lines exceed the
maximum line length (defined in DSP8054 in the various "Code" classes). -->
                                        <xsl:value-of select="mrp:OCLConstraint/mrp:Body/child::node()"/>
                                    </pre>
                                </td>
                            </tr>
                            <xsl:text>
</xsl:text>
                        </tbody>
                    </table>
                    <xsl:if test="count(mrp:OCLConstraint/mrp:Description) &gt; 0">
                        <p>Explanation:</p>
                        <div class="Normal-Indent1">
                            <xsl:call-template name="output-XHTMLText">
                                <xsl:with-param name="XHTML-text-element" select="mrp:OCLConstraint/mrp:Description"/>
                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            </xsl:call-template>
                        </div>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: Invalid type of constraint "<xsl:value-of select="local-name(child::*)"/>" defined on an element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-PropertyInitializationValueTable">
        <!-- Purpose: Output a property initialization value table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="property-name"/>
        <xsl:param name="initialization-element"/>
        <!-- initialization-element: Reference to the mrp:Initialization element within the property requirement. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <p>The following table identifies initialization value requirements for this property, if client initialization is implemented:</p>
        <xsl:text>
</xsl:text>
        <table class="Table">
            <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-P-',$property-name,'-InitializationValueRequirements')"/></xsl:attribute>
            <caption class="Table-Caption">
                <xsl:value-of select="$property-name"/>: Initialization value requirements</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Initialization value</th>
                    <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="$initialization-element/mrp:Value">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <!-- Column: Value -->
                            <xsl:value-of select="mrp:Value"/>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Requirement -->
                            <xsl:call-template name="output-RequirementLevel">
                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                            </xsl:call-template>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Description -->
                            <xsl:variable name="value-requirement-description-text">
                                <xsl:call-template name="get-ValueRequirementDescriptionText">
                                    <xsl:with-param name="value-requirement-element" select="self::node()"/>
                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                                    <xsl:variable name="value-req-heading-id">
                                        <xsl:value-of select="$generated-heading-id-prefix"/>
                                        <xsl:text>A-</xsl:text>
                                        <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-P-</xsl:text>
                                        <xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-IV-</xsl:text>
                                        <xsl:value-of select="translate(mrp:Value, $uri-translate-from, $uri-translate-to)"/>
                                    </xsl:variable>
                                    <xsl:text>See </xsl:text>
                                    <xsl:call-template name="output-link-Heading-subclause">
                                        <xsl:with-param name="id" select="$value-req-heading-id"/>
                                        <xsl:with-param name="linktext" select="concat('Initialization value: ',mrp:Value)"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </xsl:when>
                                <xsl:when test="$value-requirement-description-text != ''">
                                    <xsl:copy-of select="$value-requirement-description-text"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>See schema definition.</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-PropertyModificationValueTable">
        <!-- Purpose: Output a property modification value table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="property-name"/>
        <xsl:param name="modification-element"/>
        <!-- modification-element: Reference to the mrp:Modification element within the property requirement. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <p>The following table identifies modification value requirements for this property, if client modification is implemented:</p>
        <xsl:text>
</xsl:text>
        <table class="Table">
            <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-P-',$property-name,'-ModificationValueRequirements')"/></xsl:attribute>
            <caption class="Table-Caption">
                <xsl:value-of select="$property-name"/>: Modification value requirements</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Modification value</th>
                    <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="$modification-element/mrp:Value">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <!-- Column: Value -->
                            <xsl:value-of select="mrp:Value"/>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Requirement -->
                            <xsl:call-template name="output-RequirementLevel">
                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                            </xsl:call-template>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Description -->
                            <xsl:variable name="value-requirement-description-text">
                                <xsl:call-template name="get-ValueRequirementDescriptionText">
                                    <xsl:with-param name="value-requirement-element" select="self::node()"/>
                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                                    <xsl:variable name="value-req-heading-id">
                                        <xsl:value-of select="$generated-heading-id-prefix"/>
                                        <xsl:text>A-</xsl:text>
                                        <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-P-</xsl:text>
                                        <xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-MV-</xsl:text>
                                        <xsl:value-of select="translate(mrp:Value, $uri-translate-from, $uri-translate-to)"/>
                                    </xsl:variable>
                                    <xsl:text>See </xsl:text>
                                    <xsl:call-template name="output-link-Heading-subclause">
                                        <xsl:with-param name="id" select="$value-req-heading-id"/>
                                        <xsl:with-param name="linktext" select="concat('Modification value: ',mrp:Value)"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </xsl:when>
                                <xsl:when test="$value-requirement-description-text != ''">
                                    <xsl:copy-of select="$value-requirement-description-text"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>See schema definition.</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-ParameterInputValueTable">
        <!-- Purpose: Output a parameter input value table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:param name="parameter-element"/>
        <!-- parameter-element: Reference to the mrp:Parameter element within the parameter requirement. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <p>The following table identifies input value requirements for this parameter:</p>
        <xsl:text>
</xsl:text>
        <table class="Table">
            <xsl:attribute name="id"><xsl:value-of select="concat('T-A-',$adaptation-name,'-M-',$method-name,'-P-',$parameter-name,'-InputValueRequirements')"/></xsl:attribute>
            <caption class="Table-Caption">
                <xsl:value-of select="$parameter-name"/>: Input value requirements</caption>
            <thead class="Table-Head">
                <xsl:text>
</xsl:text>
                <tr>
                    <th class="Table-HeadCell">Input value</th>
                    <th class="Table-HeadCell">Require<xsl:value-of select="$soft-hyphen"/>ment</th>
                    <th class="Table-HeadCell">Description</th>
                </tr>
                <xsl:text>
</xsl:text>
            </thead>
            <tbody class="Table-Body">
                <xsl:for-each select="$parameter-element/mrp:Value">
                    <xsl:text>
</xsl:text>
                    <tr>
                        <td class="Table-BodyCell">
                            <!-- Column: Value -->
                            <xsl:value-of select="mrp:Value"/>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Requirement -->
                            <xsl:call-template name="output-RequirementLevel">
                                <xsl:with-param name="requirement-element" select="mrp:Requirement"/>
                            </xsl:call-template>
                        </td>
                        <td class="Table-BodyCell">
                            <!-- Column: Description -->
                            <xsl:variable name="value-requirement-description-text">
                                <xsl:call-template name="get-ValueRequirementDescriptionText">
                                    <xsl:with-param name="value-requirement-element" select="self::node()"/>
                                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                </xsl:call-template>
                            </xsl:variable>
                            <xsl:choose>
                                <xsl:when test="string-length($value-requirement-description-text) &gt; $description-table-limit">
                                    <xsl:variable name="value-req-heading-id">
                                        <xsl:value-of select="$generated-heading-id-prefix"/>
                                        <xsl:text>A-</xsl:text>
                                        <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-M-</xsl:text>
                                        <xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-P-</xsl:text>
                                        <xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/>
                                        <xsl:text>-IV-</xsl:text>
                                        <xsl:value-of select="translate(mrp:Value, $uri-translate-from, $uri-translate-to)"/>
                                    </xsl:variable>
                                    <xsl:text>See </xsl:text>
                                    <xsl:call-template name="output-link-Heading-subclause">
                                        <xsl:with-param name="id" select="$value-req-heading-id"/>
                                        <xsl:with-param name="linktext" select="concat('Input value: ',mrp:Value)"/>
                                    </xsl:call-template>
                                    <xsl:text>.</xsl:text>
                                </xsl:when>
                                <xsl:when test="$value-requirement-description-text != ''">
                                    <xsl:copy-of select="$value-requirement-description-text"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>See schema definition.</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template name="output-FeatureUsage">
        <!-- Purpose: Output a unordered list of the usage of a given feature in any feature implementation conditions of this profle. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="feature-name"/>
        <!-- Note: The following for loops need to be kept in sync with the XPATH expressions in template "output-FeatureUsageCount". -->
        <xsl:text>
</xsl:text>
        <ul>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]">
                <xsl:text>
</xsl:text>
                <li>
                    <xsl:call-template name="output-link-Feature-tableentry">
                        <xsl:with-param name="feature-name" select="@name"/>
                    </xsl:call-template>
                    <xsl:text> feature.</xsl:text>
                </li>
            </xsl:for-each>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]">
                <xsl:text>
</xsl:text>
                <li>
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="@name"/>
                    </xsl:call-template>
                    <xsl:text> adaptation.</xsl:text>
                </li>
            </xsl:for-each>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]">
                <xsl:text>
</xsl:text>
                <li>
                    <xsl:call-template name="output-link-Property-tableentry">
                        <xsl:with-param name="adaptation-name" select="../@name"/>
                        <xsl:with-param name="property-name" select="@name"/>
                    </xsl:call-template>
                    <xsl:text> property in </xsl:text>
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="../@name"/>
                    </xsl:call-template>
                    <xsl:text> adaptation.</xsl:text>
                </li>
            </xsl:for-each>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]">
                <xsl:text>
</xsl:text>
                <li>
                    <xsl:call-template name="output-link-Method-tableentry">
                        <xsl:with-param name="adaptation-name" select="../@name"/>
                        <xsl:with-param name="method-name" select="@name"/>
                    </xsl:call-template>
                    <xsl:text> method in </xsl:text>
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="../@name"/>
                    </xsl:call-template>
                    <xsl:text> adaptation.</xsl:text>
                </li>
            </xsl:for-each>
            <xsl:for-each select="/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Operation[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]">
                <xsl:text>
</xsl:text>
                <li>
                    <xsl:variable name="operation-name" select="@name"/>
                    <xsl:variable name="operation-element" select="self::*"/>
                    <xsl:variable name="adaptation-name" select="../@name"/>
                    <xsl:variable name="operation-moniker-short">
                        <xsl:call-template name="get-operation-moniker">
                            <xsl:with-param name="operation-element" select="$operation-element"/>
                            <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                            <xsl:with-param name="short" select="'true'"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:variable name="operation-profile-type">
                        <xsl:call-template name="get-operation-profile-type">
                            <xsl:with-param name="operation-set" select="$operation-set"/>
                            <xsl:with-param name="operation-name" select="$operation-name"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:variable name="first-association-adaptation-name">
                        <xsl:choose>
                            <xsl:when test="$operation-profile-type = 'Referenced'">
                                <xsl:call-template name="get-traversal-operation-first-association-adaptation-name">
                                    <xsl:with-param name="operation-element" select="$operation-element"/>
                                    <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- empty string, indicating it is no association traversal operation for the following template. -->
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <xsl:call-template name="output-link-Operation-tableentry">
                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                        <xsl:with-param name="operation-name" select="$operation-name"/>
                        <xsl:with-param name="association-adaptation-name" select="$first-association-adaptation-name"/>
                        <xsl:with-param name="linktext" select="$operation-moniker-short"/>
                    </xsl:call-template>
                    <xsl:text> operation in </xsl:text>
                    <xsl:call-template name="output-link-Adaptation-tableentry">
                        <xsl:with-param name="adaptation-name" select="$adaptation-name"/>
                    </xsl:call-template>
                    <xsl:text> adaptation.</xsl:text>
                </li>
            </xsl:for-each>
            <xsl:text>
</xsl:text>
        </ul>
    </xsl:template>
    <xsl:template name="output-FeatureUsageCount">
        <!-- Purpose: Output the number of usages of a given feature in feature implementation conditions defined in this profile. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="feature-name"/>
        <!-- Note: The folowing XPATH expression needs to be kept in sync with the for loops in template "output-FeatureUsage". -->
        <xsl:value-of select="
count(/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature
[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]) +
count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation
[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]) +
count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Property
[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]) +
count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Method
[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ]) +
count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation/mrp:Operation
[ mrp:Requirement/mrp:Condition/descendant-or-self::*/mrp:FeatureImplementationCondition/@featureName = $feature-name ])
"/>
    </xsl:template>
    <xsl:template name="output-FeatureDiscovery">
        <!-- Purpose: Output a feature discovery description (that is, an mrp:Discovery element). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="discovery-element"/>
        <xsl:param name="feature-name"/>
        <xsl:param name="granularity-type"/>
        <xsl:param name="instance-granularity-adaptation-name"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:for-each select="$discovery-element">
            <!-- Dummy loop, just to set the context (to mrp:Discovery). Should have just one iteration. -->
            <p>
                <xsl:text>It can be concluded that the feature is available </xsl:text>
                <xsl:choose>
                    <xsl:when test="$granularity-type = 'instance'">
                        <xsl:text>for a </xsl:text>
                        <xsl:call-template name="output-link-Adaptation-tableentry">
                            <xsl:with-param name="adaptation-name" select="$instance-granularity-adaptation-name"/>
                        </xsl:call-template>
                        <xsl:text> instance </xsl:text>
                    </xsl:when>
                    <xsl:when test="$granularity-type = 'profile'">
                        <!-- empty, since a qualification with this profile is not needed. -->
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Cannot happen if the MRP profile conforms to the XSD. -->
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>if:</xsl:text>
            </p>
            <xsl:text>
</xsl:text>
            <ul class="List-Bullet">
                <xsl:for-each select="child::*">
                    <!-- Dummy loop, just to set the context (to the substitution element of the mrp:AbstractFeatureDiscoveryDescription head element). Should have just one iteration. -->
                    <xsl:text>
</xsl:text>
                    <li class="List-Bullet">
                        <xsl:call-template name="output-FeatureDiscoveryItem">
                            <xsl:with-param name="feature-name" select="$feature-name"/>
                            <xsl:with-param name="granularity-type" select="$granularity-type"/>
                            <xsl:with-param name="instance-granularity-adaptation-name" select="$instance-granularity-adaptation-name"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        </xsl:call-template>
                    </li>
                </xsl:for-each>
                <xsl:text>
</xsl:text>
            </ul>
            <xsl:choose>
                <xsl:when test="@noReverseConclusion = 'true'">
                    <p>Otherwise, no conclusion can be drawn on whether or not the feature is available.</p>
                </xsl:when>
                <xsl:otherwise>
                    <p>Otherwise, it can be concluded that the feature is not available.</p>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-FeatureDiscoveryItem">
        <!-- Purpose: Output a discovery item. -->
        <!-- Invocation context: A substitution element of the (abstract) head element mrp:AbstractFeatureDiscoveryDescription. -->
        <xsl:param name="feature-name"/>
        <xsl:param name="granularity-type"/>
        <xsl:param name="instance-granularity-adaptation-name"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:choose>
            <xsl:when test="local-name(self::*) = 'OCLDiscovery'">
                <p>The following OCL derivation constraint evaluates to a Boolean value of True.</p>
                <p>
                    <xsl:text>OCL context: </xsl:text>
                    <xsl:choose>
                        <xsl:when test="$granularity-type = 'instance'">
                            <xsl:text>A </xsl:text>
                            <xsl:call-template name="output-link-Adaptation-tableentry">
                                <xsl:with-param name="adaptation-name" select="$instance-granularity-adaptation-name"/>
                            </xsl:call-template>
                            <xsl:text> instance.</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- $granularity-type = 'profile' -->
                            <xsl:text>A </xsl:text>
                            <xsl:value-of select="$PRP-RegisteredProfile-adaptation-name"/>
                            <xsl:text> instance for this profile.</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </p>
                <xsl:text>
</xsl:text>
                <table class="Code">
                    <tbody>
                        <xsl:text>
</xsl:text>
                        <tr>
                            <td>
                                <pre class="Code">
                                    <!-- If XSLT 2.0 was supported by browsers, we could use its fn:replace() function to improve the formatting
experience of OCL code by inserting a zero width space (U+200B) after some strings, e.g. ".", "->", "(", ",". However, as it stands right
now, the profile author needs to make sure there are sufficient spaces, each of which is a line break opportunity when lines exceed the
maximum line length (defined in DSP8054 in the various "Code" classes). -->
                                    <xsl:value-of select="mrp:Body/child::node()"/>
                                </pre>
                            </td>
                        </tr>
                        <xsl:text>
</xsl:text>
                    </tbody>
                </table>
                <xsl:if test="count(mrp:Description) &gt; 0">
                    <p>Explanation:</p>
                    <div class="Normal-Indent1">
                        <xsl:call-template name="output-XHTMLText">
                            <xsl:with-param name="XHTML-text-element" select="mrp:Description"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        </xsl:call-template>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'TextDiscovery'">
                <div>
                    <xsl:call-template name="output-XHTMLText">
                        <xsl:with-param name="XHTML-text-element" select="self::*"/>
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Feature "<xsl:value-of select="$feature-name"/> specifies an unsupported feature discovery description element "<xsl:value-of select="local-name(self::*)"/>".</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-XHTMLText">
        <!-- Purpose: Output the content of an element with XHTML text (e.g. mrp:Description). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="XHTML-text-element"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="topmost-allowed-heading-level" select="''"/>
        <!-- topmost-allowed-heading-level: An empty string means that no heading is allowed. -->
        <!-- The element to be output, e.g. mrp:Description. -->
        <!-- Check whether the element exists. Normally, the XSD or checking code in calling templates is expected to
            ensure that, so this is just to double check. Unfortunately, it does not seem to be possible to figure out the
            element's name once it is missing. -->
        <xsl:choose>
            <xsl:when test="$topmost-allowed-heading-level = ''">
                <!-- No heading elements are allowed in the XHTML description text. -->
                <xsl:if test="count($XHTML-text-element/descendant::* [
                    local-name(self::node()) = 'h1' or local-name(self::node()) = 'h2' or
                    local-name(self::node()) = 'h3' or local-name(self::node()) = 'h4' or
                    local-name(self::node()) = 'h5' or local-name(self::node()) = 'h6' or
                    local-name(self::node()) = 'h7' or local-name(self::node()) = 'h8' or
                    local-name(self::node()) = 'h9' ] ) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XHTML heading elements (that is, "h1" ... "h9" elements) are not allowed in this description element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$topmost-allowed-heading-level = 'h2'">
                <!-- Only heading elements with a heading level not above topmost-allowed-heading-level are allowed in the XHTML description text. -->
                <xsl:if test="count($XHTML-text-element/descendant::* [
                    local-name(self::node()) = 'h1' ] ) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XHTML heading elements with a heading level above <xsl:value-of select="$topmost-allowed-heading-level"/> (that is, "h<xsl:value-of select="$topmost-allowed-heading-level+1"/>" ... "h9" elements) are not allowed in this description element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$topmost-allowed-heading-level = 'h3'">
                <!-- Only heading elements with a heading level not above topmost-allowed-heading-level are allowed in the XHTML description text. -->
                <xsl:if test="count($XHTML-text-element/descendant::* [
                    local-name(self::node()) = 'h1' or local-name(self::node()) = 'h2' ] ) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XHTML heading elements with a heading level above <xsl:value-of select="$topmost-allowed-heading-level"/> (that is, "h<xsl:value-of select="$topmost-allowed-heading-level+1"/>" ... "h9" elements) are not allowed in this description element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$topmost-allowed-heading-level = 'h4'">
                <!-- Only heading elements with a heading level not above topmost-allowed-heading-level are allowed in the XHTML description text. -->
                <xsl:if test="count($XHTML-text-element/descendant::* [
                    local-name(self::node()) = 'h1' or local-name(self::node()) = 'h2' or local-name(self::node()) = 'h3' ] ) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XHTML heading elements with a heading level above <xsl:value-of select="$topmost-allowed-heading-level"/> (that is, "h<xsl:value-of select="$topmost-allowed-heading-level+1"/>" ... "h9" elements) are not allowed in this description element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$topmost-allowed-heading-level = 'h5'">
                <!-- Only heading elements with a heading level not above topmost-allowed-heading-level are allowed in the XHTML description text. -->
                <xsl:if test="count($XHTML-text-element/descendant::* [
                    local-name(self::node()) = 'h1' or local-name(self::node()) = 'h2' or local-name(self::node()) = 'h3' or local-name(self::node()) = 'h4' ] ) &gt; 0">
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XHTML heading elements with a heading level above <xsl:value-of select="$topmost-allowed-heading-level"/> (that is, "h<xsl:value-of select="$topmost-allowed-heading-level+1"/>" ... "h9" elements) are not allowed in this description element.</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <!-- Should not happen. -->
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">DSP8029 Error: Template "output-XHTMLText" invoked with the invalid value "<xsl:value-of select="$topmost-allowed-heading-level"/>" for the "topmost-allowed-heading-level" parameter.</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="count($XHTML-text-element) = 0">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Required XHTML text element (that is, "XHTMLWithLinks" element) is not specified in a description element.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name($XHTML-text-element/child::*[1]) = 'XHTML'">
                <xsl:call-template name="output-XHTMLWithLinks">
                    <xsl:with-param name="xhtml-element" select="$XHTML-text-element/child::*[1]"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name($XHTML-text-element/child::*[1]) = 'XHTMLWithLinks'">
                <xsl:call-template name="output-XHTMLWithLinks">
                    <xsl:with-param name="xhtml-element" select="$XHTML-text-element/child::*[1]"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Should not happen if compliant to XSD -->
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Unknown child element "<xsl:value-of select="local-name($XHTML-text-element/child::*[1])"/>" specified in an XHTML text element (that is, an "XHTMLWithLinks" element).</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-XHTMLWithLinks">
        <!-- Purpose: Output the content of an element of type mrp:XHTMLWithLinks_Type (e.g. mrp:Description). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="xhtml-element"/>
        <!-- The element to be output, e.g. mrp:Description. -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <!-- Process the child nodes of the input node. -->
        <!-- Note: Child nodes are comments, elements and text nodes. Attributes of the input node are not child nodes. -->
        <xsl:for-each select="$xhtml-element/child::node()">
            <xsl:choose>
                <xsl:when test="namespace-uri(self::*) = $xmlns-mrp">
                    <!-- Invoke special processing if the child node is an mrp:* element. -->
                    <xsl:call-template name="output-XHTMLWithLinks-linkelement">
                        <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                        <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                        <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="self::text()">
                    <!-- The node is text in between XML tags -->
                    <xsl:copy-of select="self::text()"/>
                </xsl:when>
                <xsl:when test="local-name(self::*) = 'img'">
                    <!-- Todo: Also check the namespace in the test above. -->
                    <!-- The node is an XHTML <img> element. -->
                    <xsl:choose>
                        <xsl:when test="starts-with(@src,'data:')">
                            <!-- The image already is embedded. Copy the <img> element as is. -->
                            <xsl:element name="img">
                                <!-- Copy the attributes of that element. -->
                                <xsl:copy-of select="attribute::*"/>
                                <!-- Recursive processing for the current element is not needed, since <img> does not have child elements. -->
                            </xsl:element>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- The image is presumably linked. -->
                            <xsl:choose>
                                <xsl:when test="$standalone = 'true'">
                                    <!-- Embed the image. -->
                                    <xsl:variable name="image-file" select="@src"/>
                                    <xsl:variable name="image-file-ext">
                                        <xsl:choose>
                                            <!-- <xsl:when test="contains($image-file,'.png')">png</xsl:when> -->
                                            <xsl:when test="contains($image-file,'.gif')">gif</xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <xsl:variable name="image-media-type">
                                        <xsl:choose>
                                            <!-- <xsl:when test="$image-file-ext = 'png'">image/png</xsl:when> -->
                                            <xsl:when test="$image-file-ext = 'gif'">image/gif</xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <xsl:if test="$image-file-ext = ''">
                                        <xsl:call-template name="ErrorMsg">
                                            <xsl:with-param name="msg">Profile Error: The image file "<xsl:value-of select="$image-file"/>" referenced by an XHTML "img" element has an unsupported file extension (supported is only .gif).</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:comment> Embedded base64-encoded image from "<xsl:value-of select="$image-file"/>". </xsl:comment>
                                    <xsl:text>
</xsl:text>
                                    <xsl:element name="img">
                                        <!-- Copy all attributes of that element, except for the "src" attribute. -->
                                        <xsl:copy-of select="attribute::* [local-name(self::*) != 'src']"/>
                                        <!-- For some reason, line breaks created by means of xsl:text elements get escaped to %0A in the attribute value. -->
                                        <xsl:attribute name="src"><xsl:text>data:</xsl:text><xsl:value-of select="$image-media-type"/><xsl:text>;base64,#EMBED-FILE-AS-BASE64(</xsl:text><xsl:value-of select="$image-file"/><xsl:text>)</xsl:text></xsl:attribute>
                                        <!-- Recursive processing for the current element is not needed, since <img> does not have child elements. -->
                                    </xsl:element>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:element name="img">
                                        <!-- Copy the attributes of that element. -->
                                        <xsl:copy-of select="attribute::*"/>
                                        <!-- Recursive processing for the current element is not needed, since <img> does not have child elements. -->
                                    </xsl:element>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="self::*">
                    <!-- The node is an XML element. -->
                    <!-- Copy the child element, presumably an XHTML element. -->
                    <xsl:variable name="element-name" select="local-name(self::*)"/>
                    <xsl:element name="{$element-name}">
                        <!-- The value of the name attribute is interpreted as an XSLT "attribute value template", and the expression
                            inside of the {} is interpreted as an XPATH expression.
                            The use of local-name() in the XPATH expression removes any namespace prefixes from XHTML elements. -->
                        <!-- Copy the attributes of that element. -->
                        <xsl:copy-of select="attribute::*"/>
                        <!-- Call recursive processing for the current element. -->
                        <xsl:call-template name="output-XHTMLWithLinks">
                            <xsl:with-param name="xhtml-element" select="self::*"/>
                            <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                            <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                            <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="self::comment()">
                    <!-- The node is an XML comment (in the MRP profile or in the message text). -->
                    <!-- Output it as a comment. Alternatively, we could drop it. -->
                    <xsl:comment>
                        <xsl:text> XML comment in the MRP profile or in the MRPO message text:
</xsl:text>
                        <xsl:value-of select="self::comment()"/>
                    </xsl:comment>
                    <xsl:text>
</xsl:text>
                </xsl:when>
                <xsl:when test="self::processing-instruction()">
                    <!-- The node is an XML processing instruction. Not allowed, for now. -->
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XML processing instruction "<xsl:value-of select="name(self::processing-instruction())"/>" is not supported in "XHTMLWithLinks" elements.</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <!-- The node is of unknown type or a namespace node (that is, "xmlns:xxx"). -->
                    <xsl:call-template name="ErrorMsg">
                        <xsl:with-param name="msg">Profile Error: XML node "<xsl:value-of select="name(self::node())"/>" is not supported in "XHTMLWithLinks" elements.</xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="output-XHTMLWithLinks-linkelement">
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <!-- Purpose: Output a link element in description text. For the set of supported link elements, see the code of this template. -->
        <!-- Invocation Context: The link element (e.g. mrp:ClassAdaptationLink). -->
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="local-name(self::*) = 'ClassAdaptationLink'">
                <xsl:call-template name="output-link-Adaptation-tableentry">
                    <xsl:with-param name="adaptation-name" select="child::text()"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'PropertyLink'">
                <xsl:call-template name="output-link-Property-tableentry">
                    <xsl:with-param name="property-name" select="child::text()"/>
                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'MethodLink'">
                <xsl:call-template name="output-link-Method-tableentry">
                    <xsl:with-param name="method-name" select="child::text()"/>
                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ParameterLink'">
                <xsl:call-template name="output-link-Parameter-tableentry">
                    <xsl:with-param name="parameter-name" select="child::text()"/>
                    <xsl:with-param name="method-name" select="@methodName"/>
                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ReturnValueLink'">
                <xsl:call-template name="output-link-ReturnValue-tableentry">
                    <xsl:with-param name="method-name" select="@methodName"/>
                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'OperationLink'">
                <xsl:call-template name="output-link-Operation-tableentry">
                    <xsl:with-param name="operation-name" select="child::text()"/>
                    <xsl:with-param name="adaptation-name" select="@adaptationName"/>
                    <xsl:with-param name="association-adaptation-name" select="@associationAdaptationName"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'FeatureLink'">
                <xsl:call-template name="output-link-Feature-tableentry">
                    <xsl:with-param name="feature-name" select="child::text()"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'ProfileLink'">
                <xsl:call-template name="output-link-Profile-tableentry">
                    <xsl:with-param name="profile-ref-name" select="child::text()"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'UseCaseLink'">
                <xsl:call-template name="output-link-UseCase-tableentry">
                    <xsl:with-param name="usecase-name" select="child::text()"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'StateDescriptionLink'">
                <xsl:call-template name="output-link-StateDescription-tableentry">
                    <xsl:with-param name="statedescription-name" select="child::text()"/>
                    <xsl:with-param name="profile-ref-name" select="@profileRefName"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'NormativeReferenceLink'">
                <xsl:call-template name="output-link-NormativeReferences-entry">
                    <xsl:with-param name="ref-name" select="@refName"/>
                    <xsl:with-param name="linktext" select="child::text()"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'BibliographyLink'">
                <xsl:call-template name="output-link-Bibliography-entry">
                    <xsl:with-param name="ref-name" select="@refName"/>
                    <xsl:with-param name="linktext" select="child::text()"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'TermLink'">
                <xsl:call-template name="output-link-TermsAndDefinitions-entry">
                    <xsl:with-param name="ref-name" select="@refName"/>
                    <xsl:with-param name="document-ref-name" select="@docRefName"/>
                    <xsl:with-param name="linktext" select="child::text()"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'SymbolLink'">
                <xsl:call-template name="output-link-SymbolsAndAbbreviations-entry">
                    <xsl:with-param name="ref-name" select="@refName"/>
                    <xsl:with-param name="document-ref-name" select="@docRefName"/>
                    <xsl:with-param name="linktext" select="child::text()"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'HeadingLink'">
                <xsl:call-template name="output-link-Heading-subclause">
                    <xsl:with-param name="id" select="@id"/>
                    <xsl:with-param name="document-ref-name" select="@docRefName"/>
                    <xsl:with-param name="linktext" select="child::text()"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name(self::*) = 'XHTMLRegistryText'">
                <xsl:call-template name="output-XHTMLRegistryText">
                    <xsl:with-param name="XHTMLRegistryText-element" select="self::*"/>
                    <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                    <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                    <xsl:with-param name="invoked-from-text-fragment" select="$invoked-from-text-fragment"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: Unknown MRP extension element "<xsl:value-of select="local-name(self::*)"/>" specified in an "XHTMLWithLinks" element.</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-XHTMLRegistryText">
        <!-- Purpose: Output a link to a heading subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="XHTMLRegistryText-element"/>
        <!-- The XHTMLRegistryText element, in the following structure:
            <mrp:XHTMLRegistryText regRefName="TextReg_DMTF_DSP8008" textFragmentName="Copyright Notice">
                <mrp:DynamicElementValue name="Years">2010-2011</mrp:DynamicElementValue>
            </mrp:XHTMLRegistryText>
            The regRefName attribute points to a text registry reference defined in the subject profile, by means of its reference name.
            The text registry reference has the URL of the text registry.
            The text registry then contains the text fragment definition, identified by text fragment name (NAME attribute of MESSAGE element).
            The static and dynamic elements of the text fragment are assembled, taking into account the dynamic element values defined in the mrp:DynamicElementValue elements.
            The assembled value of the text fragment is then interpreted as XHTML.
        -->
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether we are invoked from the MRPO text registry (that is, a text fragment defined in a text registry invokes another text fragment). If so, no access to the MRP profile is possible. -->
        <xsl:variable name="text-fragment-name">
            <xsl:value-of select="$XHTMLRegistryText-element/@textFragmentName"/>
        </xsl:variable>
        <xsl:variable name="text-registry-ref-name">
            <xsl:value-of select="$XHTMLRegistryText-element/@regRefName"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'true'">
                <!-- We don't support recursion of text fragments, currently.
                    In the future, we could extent that, if the profile context was propagated properly. Propagating subject profile name and
                    organization as done currently, is a first step but not sufficient. -->
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: An "XHTMLRegistryText" element cannot be used in an XHTML text fragment defined in a text registry.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="count(/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:TextRegistries/mrp:TextRegistryReference [ @name = $text-registry-ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A text registry with reference name "<xsl:value-of select="$text-registry-ref-name"/>" is referenced in an "XHTMLRegistryText" element but is not defined or defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="text-registry-url">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:DocumentControlInformation/mrp:TextRegistries/mrp:TextRegistryReference [ @name = $text-registry-ref-name ]/mrp:Location"/>
                        </xsl:variable>
                        <!-- Open the text registry. -->
                        <xsl:variable name="registry-doc" select="document($text-registry-url)"/>
                        <xsl:choose>
                            <xsl:when test="count($registry-doc) != 1">
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile or Setup Error: Text registry file specified for a "XHTMLRegistryText" element not found: "<xsl:value-of select="$text-registry-url"/>"</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- Provide access to the text fragments. -->
                                <xsl:variable name="registry-entries" select="$registry-doc/mr:REGISTRY/mr:REGISTRY_ENTRIES"/>
                                <xsl:choose>
                                    <xsl:when test="count($registry-entries) != 1">
                                        <xsl:call-template name="ErrorMsg">
                                            <xsl:with-param name="msg">Profile or Setup Error: Text registry file specified for a "XHTMLRegistryText" element is not a text registry: "<xsl:value-of select="$text-registry-url"/>"</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <!-- Locate the specified text fragment in the registry. -->
                                        <xsl:variable name="text-fragment-element" select="$registry-entries/mr:MESSAGE[ @NAME = $text-fragment-name ]"/>
                                        <xsl:choose>
                                            <xsl:when test="count($text-fragment-element) = 0">
                                                <xsl:call-template name="ErrorMsg">
                                                    <xsl:with-param name="msg">Profile Error: Text fragment with name "<xsl:value-of select="$text-fragment-name"/> not found in text registry "<xsl:value-of select="$text-registry-url"/>" but specified in an "XHTMLRegistryText" element.</xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <!-- Assemble the elements of the text fragment. -->
                                                <xsl:for-each select="$text-fragment-element/mr:MESSAGE_COMPONENTS/*">
                                                    <xsl:choose>
                                                        <xsl:when test="local-name() = 'DYNAMIC_ELEMENT' or local-name() = 'REPEAT_DYNAMIC_ELEMENT'">
                                                            <!-- Note: The following test also covers for the default of 'true' -->
                                                            <xsl:if test="not (@EXPECTED_IN_MESSAGE = 'false')">
                                                                <!-- Note: The following test also covers for the default of 'false' -->
                                                                <xsl:variable name="dynamic-element-name" select="@NAME"/>
                                                                <xsl:variable name="dynamic-element-value-element" select="$XHTMLRegistryText-element/mrp:DynamicElementValue[@name = $dynamic-element-name]"/>
                                                                <xsl:if test="@IS_ARRAY = 'true'">
                                                                    <xsl:call-template name="ErrorMsg">
                                                                        <xsl:with-param name="msg">Profile Error: Text fragment with name "<xsl:value-of select="$text-fragment-name"/> defined in text registry "<xsl:value-of select="$text-registry-url"/>" specifies the dynamic element named "<xsl:value-of select="$dynamic-element-name"/> to be an array (through the "IS_ARRAY" attribute) but array typed dynamic elements are not supported in text fragments.</xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:if>
                                                                <xsl:choose>
                                                                    <xsl:when test="count($dynamic-element-value-element) = 0">
                                                                        <!-- There was no mrp:DynamicElementValue specified for this dynamic element of the text fragment. -->
                                                                        <xsl:call-template name="ErrorMsg">
                                                                            <xsl:with-param name="msg">Profile Error: The "XHTMLRegistryText" element referencing the text fragment with name "<xsl:value-of select="$text-fragment-name"/>" defined in text registry "<xsl:value-of select="$text-registry-url"/>" does not specify a value for the dynamic element named "<xsl:value-of select="$dynamic-element-name"/>" (through the "DynamicElementValue" element).</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <xsl:value-of select="$dynamic-element-value-element/text()"/>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:if>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <!-- static element -->
                                                            <xsl:call-template name="output-XHTMLWithLinks">
                                                                <xsl:with-param name="xhtml-element" select="self::node()"/>
                                                                <xsl:with-param name="subject-profile-name" select="$subject-profile-name"/>
                                                                <xsl:with-param name="subject-profile-organization" select="$subject-profile-organization"/>
                                                                <xsl:with-param name="invoked-from-text-fragment" select="'true'"/>
                                                            </xsl:call-template>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:for-each>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Profile-tableentry">
        <!-- Purpose: Output a link to an entry in the profile references table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="profile-ref-name"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="linktext" select="$profile-ref-name"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a profile link but is not defined or is defined more than once in this profile.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="a" xml:space="default">
                    <xsl:attribute name="class">ElementRef</xsl:attribute>
                    <xsl:attribute name="href"><xsl:text>#T-P-</xsl:text><xsl:value-of select="translate($profile-ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Profile references table entry for the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="ElementRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Feature-subclause">
        <!-- Purpose: Output a link to a feature subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="feature-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Feature: ',$feature-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the feature is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile feature link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>F-</xsl:text><xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$feature-name"/><xsl:text> feature in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the feature is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature[ @name = $feature-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A feature "<xsl:value-of select="$feature-name"/>" is referenced in a feature link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>F-</xsl:text><xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"></xsl:value-of></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$feature-name"/><xsl:text> feature</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Feature-tableentry">
        <!-- Purpose: Output a link to an entry in the features table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="feature-name"/>
        <xsl:param name="linktext" select="$feature-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the feature is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile feature link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-F-</xsl:text><xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Features table entry for the </xsl:text><xsl:value-of select="$feature-name"/><xsl:text> feature in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the feature is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Features/mrp:Feature[ @name = $feature-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A feature "<xsl:value-of select="$feature-name"/>" is referenced in a feature link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-F-</xsl:text><xsl:value-of select="translate($feature-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Features table entry for the </xsl:text><xsl:value-of select="$feature-name"/><xsl:text> feature</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Adaptation-subclause">
        <!-- Purpose: Output a link to a class adaptation subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Adaptation: ',$adaptation-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="adaptation-anchor-name">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="adaptation-heading-id">
            <xsl:value-of select="$generated-heading-id-prefix"/>
            <xsl:text>A-</xsl:text>
            <xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the adaptation is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile class adaptation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$adaptation-anchor-name"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the adaptation is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a class adaptation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$adaptation-anchor-name"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Adaptation-tableentry">
        <!-- Purpose: Output a link to an entry in the class adaptations table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="linktext" select="$adaptation-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the adaptation is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile class adaptation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Adaptations table entry for the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the adaptation is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a class adaptation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Adaptations table entry for the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Property-subclause">
        <!-- Purpose: Output a link to a property subclause (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="property-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Property: ',$property-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the property is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile property link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$property-name"/><xsl:text> property of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the property is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a property link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Property[ @name = $property-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A property "<xsl:value-of select="$property-name"/>" is referenced in a property link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$property-name"/><xsl:text> property of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Property-tableentry">
        <!-- Purpose: Output a link to an entry in the properties table (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="property-name"/>
        <xsl:param name="linktext" select="$property-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the property is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile property link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="$property-name"/><xsl:text> property of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the property is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a property link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Property[ @name = $property-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A property "<xsl:value-of select="$property-name"/>" is referenced in a property link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($property-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="$property-name"/><xsl:text> property of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Method-subclause">
        <!-- Purpose: Output a link to a method subclause (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Method: ',$method-name,'(&#xA0;)','&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile method link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a method link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a method link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Method-tableentry">
        <!-- Purpose: Output a link to an entry in the methods table (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="linktext" select="concat($method-name,'(&#xA0;)')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile method link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a method link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a method link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Parameter-subclause">
        <!-- Purpose: Output a link to a parameter subclause (within a method subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Parameter: ',$parameter-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method with the parameter is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile parameter link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$parameter-name"/><xsl:text> parameter of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method with the parameter is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a parameter link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a parameter link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]/mrp:Parameter[ @name = $parameter-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A parameter "<xsl:value-of select="$parameter-name"/>" is referenced in a parameter link but is not defined in method "<xsl:value-of select="$method-name"/>" defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$parameter-name"/><xsl:text> parameter of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Parameter-tableentry">
        <!-- Purpose: Output a link to an entry in the parameters table (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="parameter-name"/>
        <xsl:param name="linktext" select="$parameter-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method with the parameter is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile parameter link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Parameter requirements table entry for the </xsl:text><xsl:value-of select="$parameter-name"/><xsl:text> parameter of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method with the parameter is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a parameter link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a parameter link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]/mrp:Parameter[ @name = $parameter-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A parameter "<xsl:value-of select="$parameter-name"/>" is referenced in a parameter link but is not defined in method "<xsl:value-of select="$method-name"/>" defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-P-</xsl:text><xsl:value-of select="translate($parameter-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Parameter requirements table entry for the </xsl:text><xsl:value-of select="$parameter-name"/><xsl:text> parameter of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-ReturnValue-subclause">
        <!-- Purpose: Output a link to a return value subclause (within a method subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="linktext" select="'subclause &quot;Return value&quot;'"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method with the return value is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile return value link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-RV</xsl:text></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the return value of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method with the return value is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a return value link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a return value link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-RV</xsl:text></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the return value of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-ReturnValue-tableentry">
        <!-- Purpose: Output a link to the return value entry in the parameters table (within a method subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="method-name"/>
        <xsl:param name="linktext" select="'Return value'"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the method with the return value is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile return value link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-RV</xsl:text></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Parameter requirements table entry for the return value of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the method with the return value is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in a return value link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Method[ @name = $method-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A method "<xsl:value-of select="$method-name"/>" is referenced in a return value link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-M-</xsl:text><xsl:value-of select="translate($method-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-RV</xsl:text></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Parameter requirements table entry for the return value of the </xsl:text><xsl:value-of select="concat($method-name,'(&#xA0;)')"/><xsl:text> method of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Operation-subclause">
        <!-- Purpose: Output a link to a operation subclause (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="operation-name"/>
        <xsl:param name="association-adaptation-name" select="''"/>
        <xsl:param name="linktext" select="''"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="linktext2">
            <xsl:choose>
                <xsl:when test="$linktext != ''">
                    <xsl:value-of select="$linktext"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>subclause &quot;Operation: </xsl:text>
                    <xsl:value-of select="$operation-name"/>
                    <xsl:text>(&#xA0;)</xsl:text>
                    <xsl:if test="$association-adaptation-name != ''">
                        <xsl:text> for </xsl:text>
                        <xsl:value-of select="$association-adaptation-name"/>
                    </xsl:if>
                    <xsl:text>&quot;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext2"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the operation is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile operation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:if test="$association-adaptation-name != ''"><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:if></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause '</xsl:text><xsl:value-of select="$linktext2"/>'<xsl:text> of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the operation is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$linktext2"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in an operation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Operation[ @name = $operation-name ]) = 0">
                        <xsl:value-of select="$linktext2"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: An operation "<xsl:value-of select="$operation-name"/>" is referenced in an operation link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:if test="$association-adaptation-name != ''"><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:if></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause '</xsl:text><xsl:value-of select="$linktext2"/><xsl:text>' of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$linktext2"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$linktext2"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Operation-tableentry">
        <!-- Purpose: Output a link to an entry in the operations table (within a class adaptation subclause). -->
        <!-- Invocation context: Any. -->
        <xsl:param name="adaptation-name"/>
        <xsl:param name="operation-name"/>
        <xsl:param name="association-adaptation-name" select="''"/>
        <xsl:param name="linktext" select="''"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="linktext2">
            <xsl:choose>
                <xsl:when test="$linktext != ''">
                    <xsl:value-of select="$linktext"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$operation-name"/>
                    <xsl:text>(&#xA0;)</xsl:text>
                    <xsl:if test="$association-adaptation-name != ''">
                        <xsl:text> for </xsl:text>
                        <xsl:value-of select="$association-adaptation-name"/>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext2"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the operation is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile operation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:if test="$association-adaptation-name != ''"><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:if></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="$linktext2"/><xsl:text> operation of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the operation is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A class adaptation "<xsl:value-of select="$adaptation-name"/>" is referenced in an operation link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:Elements/mrp:ClassAdaptation[ @name = $adaptation-name ]/mrp:Operation[ @name = $operation-name ]) = 0">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: An operation "<xsl:value-of select="$operation-name"/>" is referenced in an operation link but is not defined in adaptation "<xsl:value-of select="$adaptation-name"/>" defined in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-A-</xsl:text><xsl:value-of select="translate($adaptation-name, $uri-translate-from, $uri-translate-to)"/><xsl:text>-O-</xsl:text><xsl:value-of select="translate($operation-name, $uri-translate-from, $uri-translate-to)"/><xsl:if test="$association-adaptation-name != ''"><xsl:text>-A-</xsl:text><xsl:value-of select="translate($association-adaptation-name, $uri-translate-from, $uri-translate-to)"/></xsl:if></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Element requirements table entry for the </xsl:text><xsl:value-of select="$linktext2"/><xsl:text> operation of the </xsl:text><xsl:value-of select="$adaptation-name"/><xsl:text> adaptation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-UseCase-subclause">
        <!-- Purpose: Output a link to a use case subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="usecase-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;Use case: ',$usecase-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the use case is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile use case link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>UC-</xsl:text><xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$usecase-name"/><xsl:text> use case in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the use case is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:UseCase[ @name = $usecase-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A use case named "<xsl:value-of select="$usecase-name"/>" is referenced by a use case link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>UC-</xsl:text><xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$usecase-name"/><xsl:text> use case</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-UseCase-tableentry">
        <!-- Purpose: Output a link to a use case entry in the use cases table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="usecase-name"/>
        <xsl:param name="linktext" select="$usecase-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the use case is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile use case link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-UC-</xsl:text><xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Use cases table entry for the </xsl:text><xsl:value-of select="$usecase-name"/><xsl:text> use case in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the use case is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:UseCase[ @name = $usecase-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A use case named "<xsl:value-of select="$usecase-name"/>" is referenced in a use case link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-UC-</xsl:text><xsl:value-of select="translate($usecase-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Use cases table entry for the </xsl:text><xsl:value-of select="$usecase-name"/><xsl:text> use case</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-StateDescription-subclause">
        <!-- Purpose: Output a link to a state description subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="statedescription-name"/>
        <xsl:param name="linktext" select="concat('subclause &quot;State description: ',$statedescription-name,'&quot;')"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:variable name="profile-linktext">
            <xsl:value-of select="$linktext"/>
            <xsl:if test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <xsl:text> in </xsl:text>
                <xsl:value-of select="$related-profile-element/@name"/>
                <xsl:text> profile</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the state description is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile state description link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="HeadingRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>SD-</xsl:text><xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$statedescription-name"/><xsl:text> state description in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="HeadingRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the state description is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:StateDescription[ @name = $statedescription-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A state description named "<xsl:value-of select="$statedescription-name"/>" referenced in a state description link is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="HeadingRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$generated-heading-id-prefix"/><xsl:text>SD-</xsl:text><xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Subclause for the </xsl:text><xsl:value-of select="$statedescription-name"/><xsl:text> state description</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="HeadingRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-StateDescription-tableentry">
        <!-- Purpose: Output a link to a state description entry in the use cases table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="statedescription-name"/>
        <xsl:param name="linktext" select="$statedescription-name"/>
        <xsl:param name="profile-ref-name" select="''"/>
        <xsl:param name="subject-profile-name" select="''"/>
        <xsl:param name="subject-profile-organization" select="''"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:variable name="profile-linktext">
            <xsl:if test="$profile-ref-name != ''">
                <xsl:value-of select="$profile-ref-name"/>
                <xsl:text>::</xsl:text>
            </xsl:if>
            <xsl:value-of select="$linktext"/>
        </xsl:variable>
        <xsl:variable name="related-profile-element" select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]"/>
        <xsl:variable name="invoked-from-subject-profile" select="$related-profile-element/@name = $subject-profile-name and $related-profile-element/@organization = $subject-profile-organization"/>
        <xsl:choose>
            <xsl:when test="$profile-ref-name != '' and $invoked-from-subject-profile = false()">
                <!-- A profile is specified that is not the subject profile, so the state description is supposed to be defined in that profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A profile reference named "<xsl:value-of select="$profile-ref-name"/>" is referenced in a cross-profile state description link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="docRefName">
                            <xsl:value-of select="/mrp:ProfileSpecification/mrp:Profile/mrp:RelatedProfiles/mrp:RelatedProfile[ @refName = $profile-ref-name ]/@docRefName"/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]) != 1">
                                <xsl:value-of select="$profile-linktext"/>
                                <xsl:call-template name="ErrorMsg">
                                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$docRefName"/>" is referenced by the profile reference named "<xsl:value-of select="$profile-ref-name"/>" but is not defined or is defined more than once in this profile.</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="location">
                                    <xsl:value-of select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $docRefName ]/mrp:Location"/>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$location = ''">
                                        <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                        <xsl:value-of select="$profile-linktext"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>
</xsl:text>
                                        <a class="ElementRef">
                                            <xsl:attribute name="href"><xsl:value-of select="$location"/><xsl:text>#T-SD-</xsl:text><xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                            <xsl:attribute name="title"><xsl:text>Use cases table entry for the </xsl:text><xsl:value-of select="$statedescription-name"/><xsl:text> state description in the </xsl:text><xsl:value-of select="$profile-ref-name"/><xsl:text> profile</xsl:text></xsl:attribute>
                                            <xsl:choose>
                                                <xsl:when test="$output-link-span-element = 'true'">
                                                    <span class="ElementRef">
                                                        <xsl:value-of select="$profile-linktext"/>
                                                    </span>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$profile-linktext"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No profile or subject profile is specified, so the state description is supposed to be defined in this profile. -->
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:UseCases/mrp:StateDescription[ @name = $statedescription-name ]) != 1">
                        <xsl:value-of select="$profile-linktext"/>
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A state description named "<xsl:value-of select="$statedescription-name"/>" is referenced in a state description link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="ElementRef">
                            <xsl:attribute name="href"><xsl:text>#T-SD-</xsl:text><xsl:value-of select="translate($statedescription-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Use cases table entry for the </xsl:text><xsl:value-of select="$statedescription-name"/><xsl:text> state description</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="ElementRef">
                                        <xsl:value-of select="$profile-linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$profile-linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-MessageRegistries-tableentry">
        <!-- Purpose: Output a link to an entry in the message registry references table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="linktext" select="$ref-name"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:MessageRegistries/mrp:Registry[ @refName = $ref-name ]) != 1">
                <xsl:value-of select="$linktext"/>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: A message registry reference named "<xsl:value-of select="$ref-name"/>" is referenced in a message registry link but is not defined or is defined more than once in this profile.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>
</xsl:text>
                <a class="ElementRef">
                    <xsl:attribute name="href"><xsl:text>#T-MessageRegistries-</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Message registry references table entry named </xsl:text><xsl:value-of select="$ref-name"/></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="ElementRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-MetricRegistries-tableentry">
        <!-- Purpose: Output a link to an entry in the metric registry references table. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="linktext" select="$ref-name"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Profile/mrp:MetricRegistries/mrp:Registry[ @refName = $ref-name ]) != 1">
                <xsl:value-of select="$linktext"/>
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: A metric registry reference named "<xsl:value-of select="$ref-name"/>" is referenced in a metric registry link but is not defined or defined more than once in this profile.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>
</xsl:text>
                <a class="ElementRef">
                    <xsl:attribute name="href"><xsl:text>#T-MetricRegistries-</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Metric registry references table entry named </xsl:text><xsl:value-of select="$ref-name"/></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="ElementRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-NormativeReferences-entry">
        <!-- Purpose: Output a link to a normative references entry. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="linktext" select="$ref-name"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $ref-name ]) != 1">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: A normative reference entry named "<xsl:value-of select="$ref-name"/>" is referenced by a normative reference link but is not defined or is defined more than once in this profile.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>
</xsl:text>
                <a class="DocRef">
                    <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Normative References entry for this document</xsl:text></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="DocRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-NormativeReferencesOperationSet-entry">
        <!-- Purpose: Output a link to the operation set entry of the normative references. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-set"/>
        <xsl:variable name="ref-name">
            <xsl:text>Ref_DMTF_</xsl:text>
            <xsl:value-of select="$operation-set"/>
        </xsl:variable>
        <xsl:call-template name="output-link-NormativeReferences-entry">
            <xsl:with-param name="ref-name" select="$ref-name"/>
            <xsl:with-param name="linktext" select="$operation-set"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="output-link-Bibliography-entry">
        <!-- Purpose: Output a link to a bibliography entry. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="linktext" select="$ref-name"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:Bibliography/mrp:DocumentReference[ @name = $ref-name ]) != 1">
                <xsl:call-template name="ErrorMsg">
                    <xsl:with-param name="msg">Profile Error: A bibliography entry named "<xsl:value-of select="$ref-name"/>" is referenced in a bibliography link but is not defined or is defined more than once in this profile.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>
</xsl:text>
                <a class="DocRef">
                    <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Bibliography entry for the </xsl:text><xsl:value-of select="$linktext"/><xsl:text> reference</xsl:text></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="DocRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-TermsAndDefinitions-entry">
        <!-- Purpose: Output a link to a terms and definitions entry. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="document-ref-name" select="''"/>
        <xsl:param name="linktext"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$document-ref-name != ''">
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A normative references entry named "<xsl:value-of select="$document-ref-name"/>" is referenced in a cross-profile term link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="document-reference" select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]"/>
                        <xsl:choose>
                            <xsl:when test="$document-reference/mrp:Location != ''">
                                <xsl:text>
</xsl:text>
                                <a class="TermRef">
                                    <xsl:attribute name="href"><xsl:value-of select="$document-reference/mrp:Location"></xsl:value-of><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    <xsl:attribute name="title"><xsl:text>Terms and Definitions entry for this term in document </xsl:text><xsl:value-of select="$document-reference/mrp:OwningEntity"/><xsl:text>:</xsl:text><xsl:value-of select="$document-reference/mrp:ID"/></xsl:attribute>
                                    <xsl:choose>
                                        <xsl:when test="$output-link-span-element = 'true'">
                                            <span class="TermRef">
                                                <xsl:value-of select="$linktext"/>
                                            </span>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$linktext"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$linktext"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:TermsAndDefinitions/mrp:TermDefinition[ @name = $ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A terms and definitions entry with @refName="<xsl:value-of select="$ref-name"/>" is referenced in a term link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="TermRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Terms and Definitions entry for this term</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="TermRef">
                                        <xsl:value-of select="$linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-SymbolsAndAbbreviations-entry">
        <!-- Purpose: Output a link to a symbols and abbreviations entry. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="ref-name"/>
        <xsl:param name="document-ref-name" select="''"/>
        <xsl:param name="linktext"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$document-ref-name != ''">
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A normative references entry named "<xsl:value-of select="$document-ref-name"/>" is referenced in a cross-profile symbol link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="document-reference" select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]"/>
                        <xsl:choose>
                            <xsl:when test="$document-reference/mrp:Location != ''">
                                <xsl:text>
</xsl:text>
                                <a class="TermRef">
                                    <xsl:attribute name="href"><xsl:value-of select="$document-reference/mrp:Location"/><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                                    <xsl:attribute name="title"><xsl:text>Symbols and abbreviations entry for this symbol or abbreviation in document </xsl:text><xsl:value-of select="$document-reference/mrp:OwningEntity"/><xsl:text>:</xsl:text><xsl:value-of select="$document-reference/mrp:ID"/></xsl:attribute>
                                    <xsl:choose>
                                        <xsl:when test="$output-link-span-element = 'true'">
                                            <span class="TermRef">
                                                <xsl:value-of select="$linktext"/>
                                            </span>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$linktext"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$linktext"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:SymbolsAndAbbreviations/mrp:SymbolDefinition[ @name = $ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A symbol and abbreviations entry with @refName="<xsl:value-of select="$ref-name"/>" is referenced in a symbol link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>
</xsl:text>
                        <a class="TermRef">
                            <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="translate($ref-name, $uri-translate-from, $uri-translate-to)"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:text>Symbols and abbreviations entry for this symbol or abbreviation</xsl:text></xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="$output-link-span-element = 'true'">
                                    <span class="TermRef">
                                        <xsl:value-of select="$linktext"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$linktext"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-link-Heading-subclause">
        <!-- Purpose: Output a link to a heading subclause. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="id"/>
        <xsl:param name="document-ref-name" select="''"/>
        <xsl:param name="linktext"/>
        <xsl:param name="invoked-from-text-fragment" select="'false'"/>
        <!-- Flag indicating whether the XHTMLWithLinks is defined in a text fragment in a text registry. -->
        <xsl:choose>
            <xsl:when test="$document-ref-name != ''">
                <xsl:choose>
                    <xsl:when test="$invoked-from-text-fragment = 'false' and count(/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]) != 1">
                        <xsl:call-template name="ErrorMsg">
                            <xsl:with-param name="msg">Profile Error: A normative references entry named "<xsl:value-of select="$document-ref-name"/>" is referenced in a cross-profile heading link but is not defined or is defined more than once in this profile.</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="document-reference" select="/mrp:ProfileSpecification/mrp:NormativeReferences/mrp:DocumentReference[ @name = $document-ref-name ]"/>
                        <xsl:choose>
                            <xsl:when test="$document-reference/mrp:Location != ''">
                                <xsl:text>
</xsl:text>
                                <a class="HeadingRef">
                                    <xsl:attribute name="href"><xsl:value-of select="$document-reference/mrp:Location"/><xsl:text>#</xsl:text><xsl:value-of select="$id"/></xsl:attribute>
                                    <xsl:attribute name="title"><xsl:text>Heading with id=</xsl:text><xsl:value-of select="$id"/><xsl:text> in document </xsl:text><xsl:value-of select="$document-reference/mrp:OwningEntity"/><xsl:text>:</xsl:text><xsl:value-of select="$document-reference/mrp:ID"/></xsl:attribute>
                                    <xsl:choose>
                                        <xsl:when test="$output-link-span-element = 'true'">
                                            <span class="HeadingRef">
                                                <xsl:value-of select="$linktext"/>
                                                <xsl:text> in </xsl:text>
                                                <xsl:value-of select="$document-reference/mrp:OwningEntity"/>
                                                <xsl:text>:</xsl:text>
                                                <xsl:value-of select="$document-reference/mrp:ID"/>
                                            </span>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$linktext"/>
                                            <xsl:text> in </xsl:text>
                                            <xsl:value-of select="$document-reference/mrp:OwningEntity"/>
                                            <xsl:text>:</xsl:text>
                                            <xsl:value-of select="$document-reference/mrp:ID"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- The strategy is to tolerate that the normative reference entry does not have a mrp:Location specified. -->
                                <xsl:value-of select="$linktext"/>
                                <xsl:text> in </xsl:text>
                                <xsl:value-of select="$document-reference/mrp:OwningEntity"/>
                                <xsl:text>:</xsl:text>
                                <xsl:value-of select="$document-reference/mrp:ID"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- No document is specified, so the heading is supposed to be defined in this profile. -->
                <!-- No verification is done that a heading with this id value exists, due to the complexity of the test. -->
                <xsl:text>
</xsl:text>
                <a class="HeadingRef">
                    <xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="$id"/></xsl:attribute>
                    <xsl:attribute name="title"><xsl:text>Heading with id=</xsl:text><xsl:value-of select="$id"/></xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$output-link-span-element = 'true'">
                            <span class="HeadingRef">
                                <xsl:value-of select="$linktext"/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$linktext"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="ErrorMsg">
        <!-- Purpose: Output an error message. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="msg"/>
        <!-- Xalan-J supports a -L command line option that supposedly provides access available to the location
                     in the .mrp.xml source file via XPATH functions such as lineNumer(). However, this did not work and resulted
                         in a Java exception:
             <xsl:variable name="msg2" select="concat('.mrp.xml line ',lineNumber(),': ',$msg)"/>
        -->
        <span class="ErrorMsg">
            <xsl:value-of select="$msg"/>
        </span>
        <xsl:message>
            <xsl:value-of select="$msg"/>
        </xsl:message>
    </xsl:template>
    <xsl:template name="get-operation-profile-type">
        <!-- Purpose: Return the "profile specification type" of an operation. -->
        <!-- Return values: OrdinaryOrAssociation - the operation may be specified on any ardinary or association adaptation. -->
        <!-- Return values: Referenced - the operation may be specified on any adaptation that is referenced by an association adaptation defined in this profile. -->
        <!-- Return values: InvalidOperation - the operation name is invalid in the given operation set. -->
        <!-- Invocation context: Any. -->
        <xsl:param name="operation-set"/>
        <!-- operation-set: The operation set, either 'DSP0200' or 'DSP0223'
               DSP1001 1.1 requires that only DSP0223 is used, but this code still supports DSP0200 in addition, which does not hurt. -->
        <xsl:param name="operation-name"/>
        <!-- operation-name: The name of the operation in that operation set, e.g. 'AssociatorNames' (in DSP0200) -->
        <!-- Important note: The following variables need to be kept up to date as new operations emerge. -->
        <xsl:variable name="operations-DSP0223-OrdinaryOrAssociation" select="'|GetInstance|DeleteInstance|ModifyInstance|CreateInstance|GetClassInstancesWithPath|GetClassInstancePaths|OpenClassInstancesWithPath|OpenClassInstancePaths|InvokeMethod|InvokeStaticMethod|'"/>
        <xsl:variable name="operations-DSP0223-Referenced" select="'|GetAssociatedInstancesWithPath|GetAssociatedInstancePaths|GetReferencingInstancesWithPath|GetReferencingInstancePaths|OpenAssociatedInstancesWithPath|OpenAssociatedInstancePaths|OpenReferencingInstancesWithPath|OpenReferencingInstancePaths|OpenQueryInstances|PullInstancesWithPath|PullInstancePaths|PullInstances|CloseEnumeration|EnumerationCount|'"/>
        <xsl:variable name="operations-DSP0200-OrdinaryOrAssociation" select="'|GetInstance|DeleteInstance|ModifyInstance|CreateInstance|EnumerateInstances|EnumerateInstanceNames|OpenEnumerateInstances|OpenEnumerateInstancePaths|'"/>
        <xsl:variable name="operations-DSP0200-Referenced" select="'|Associators|AssociatorNames|References|ReferenceNames|OpenAssociatorInstances|OpenAssociatorInstancePaths|OpenReferenceInstances|OpenReferenceInstancePaths|OpenQueryInstances|PullInstancesWithPath|PullInstancePaths|CloseEnumeration|EnumerationCount|'"/>
        <xsl:choose>
            <xsl:when test="$operation-set = 'DSP0200'">
                <xsl:choose>
                    <xsl:when test="contains($operations-DSP0200-OrdinaryOrAssociation,concat('|',$operation-name,'|'))">
                        <xsl:text>OrdinaryOrAssociation</xsl:text>
                    </xsl:when>
                    <xsl:when test="contains($operations-DSP0200-Referenced,concat('|',$operation-name,'|'))">
                        <xsl:text>Referenced</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>InvalidOperation</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$operation-set = 'DSP0223'">
                <xsl:choose>
                    <xsl:when test="contains($operations-DSP0223-OrdinaryOrAssociation,concat('|',$operation-name,'|'))">
                        <xsl:text>OrdinaryOrAssociation</xsl:text>
                    </xsl:when>
                    <xsl:when test="contains($operations-DSP0223-Referenced,concat('|',$operation-name,'|'))">
                        <xsl:text>Referenced</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>InvalidOperation</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="output-heading-H1">
        <!-- Purpose: Output a H1 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading1'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h1>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h1 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h1 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h1>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-heading-H2">
        <!-- Purpose: Output a H2 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading2'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h2>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h2 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h2 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h2-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h2>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-heading-H3">
        <!-- Purpose: Output a H3 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading3'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h3>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h3 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h3 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h2-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h3-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h3>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-heading-H4">
        <!-- Purpose: Output a H4 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading4'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h4>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h4 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h4 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h2-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h3-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h4-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h4>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-heading-H5">
        <!-- Purpose: Output a H5 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading5'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h5>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h5 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h5 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h2-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h3-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h4-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h5-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h5>
        <xsl:text>
</xsl:text>
    </xsl:template>
    <xsl:template name="output-heading-H6">
        <!-- Purpose: Output a H6 level heading. -->
        <!-- Invocation context: any -->
        <xsl:param name="h1-number" select="0"/>
        <xsl:param name="h2-number"/>
        <xsl:param name="h3-number"/>
        <xsl:param name="h4-number"/>
        <xsl:param name="h5-number"/>
        <xsl:param name="h6-number"/>
        <xsl:param name="heading-text"/>
        <xsl:param name="heading-id" select="''"/>
        <xsl:param name="heading-class" select="'Heading6'"/>
        <xsl:param name="heading-style" select="''"/>
        <xsl:text>
</xsl:text>
        <h6>
            <xsl:if test="$heading-id != ''">
                <xsl:attribute name="id"><xsl:value-of select="$heading-id"/></xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class"><xsl:value-of select="$heading-class"/></xsl:attribute>
            <xsl:if test="$heading-style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$heading-style"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$heading-id != ''">
                    <xsl:attribute name="title"><xsl:text>Generated heading h6 with id=</xsl:text><xsl:value-of select="$heading-id"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="title"><xsl:text>Generated heading h6 with no id</xsl:text></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$generate-headnum = 'true' and $h1-number &gt; 0">
                <xsl:value-of select="$h1-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h2-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h3-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h4-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h5-number"/>
                <xsl:text>.</xsl:text>
                <xsl:value-of select="$h6-number"/>
                <xsl:value-of select="$headnum-delimiter"/>
            </xsl:if>
            <xsl:value-of select="$heading-text"/>
        </h6>
        <xsl:text>
</xsl:text>
    </xsl:template>
</xsl:stylesheet>
